/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.text;

import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.FullReadLines;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.text.CharArrayStringBuffer;

public abstract class PropertiesReader<T>
extends FullReadLines<T> {
    private char commentChar;

    public PropertiesReader(char commentChar, String description, ICharacterStream.Readable.Buffered stream, byte priority, IO.OperationType closeStreamAtEnd) {
        super(description, stream, priority, closeStreamAtEnd);
        this.commentChar = commentChar;
    }

    public PropertiesReader(String description, ICharacterStream.Readable.Buffered stream, byte priority, IO.OperationType closeStreamAtEnd) {
        this('#', description, stream, priority, closeStreamAtEnd);
    }

    @Override
    protected void processLine(CharArrayStringBuffer line) {
        if (line.isEmpty()) {
            return;
        }
        if (line.charAt(0) == this.commentChar) {
            return;
        }
        int i = line.indexOf('=');
        if (i < 0) {
            return;
        }
        CharArrayStringBuffer key = (CharArrayStringBuffer)line.substring(0, i);
        key.trim();
        CharArrayStringBuffer value = (CharArrayStringBuffer)line.substring(i + 1);
        value.trim();
        this.processProperty(key, value);
    }

    protected abstract void processProperty(CharArrayStringBuffer var1, CharArrayStringBuffer var2);
}

