/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.text;

import java.io.EOFException;
import java.io.IOException;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.text.CharArrayStringBuffer;
import net.lecousin.framework.util.ConcurrentCloseable;

public class TextLineStream
extends ConcurrentCloseable<IOException> {
    private ICharacterStream.Readable.Buffered input;

    public TextLineStream(ICharacterStream.Readable.Buffered input) {
        this.input = input;
    }

    public CharArrayStringBuffer nextLine() throws IOException {
        if (this.input.endReached()) {
            return null;
        }
        CharArrayStringBuffer line = new CharArrayStringBuffer();
        boolean prevCR = false;
        try {
            char c;
            while ((c = this.input.read()) != '\n') {
                if (c == '\r' && !prevCR) {
                    prevCR = true;
                    continue;
                }
                if (prevCR) {
                    line.append('\r');
                    prevCR = false;
                }
                if (c == '\r') {
                    prevCR = true;
                    continue;
                }
                line.append(c);
            }
        }
        catch (EOFException e) {
        }
        return line;
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        return this.input.closeAsync();
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.input = null;
        ondone.unblock();
    }

    @Override
    public byte getPriority() {
        return this.input.getPriority();
    }
}

