/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.locale;

import java.util.ArrayList;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.JoinPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.locale.ILocalizableString;

public class CompositeLocalizable
implements ILocalizableString {
    private static final long serialVersionUID = 1L;
    private String sep;
    private ILocalizableString[] elements;

    public CompositeLocalizable(String sep, ILocalizableString ... elements) {
        this.sep = sep;
        this.elements = elements;
    }

    @Override
    public AsyncSupplier<String, NoException> localize(String[] languageTag) {
        JoinPoint jp = new JoinPoint();
        ArrayList<AsyncSupplier<String, NoException>> list = new ArrayList<AsyncSupplier<String, NoException>>(this.elements.length);
        for (ILocalizableString s : this.elements) {
            AsyncSupplier<String, NoException> l = s.localize(languageTag);
            jp.addToJoin(l);
            list.add(l);
        }
        AsyncSupplier<String, NoException> result = new AsyncSupplier<String, NoException>();
        jp.start();
        jp.onDone(() -> {
            StringBuilder s = new StringBuilder();
            for (AsyncSupplier es : list) {
                if (s.length() > 0) {
                    s.append(this.sep);
                }
                s.append((String)es.getResult());
            }
            result.unblockSuccess(s.toString());
        });
        return result;
    }

    @Override
    public String localizeSync(String[] languageTag) {
        StringBuilder s = new StringBuilder();
        for (ILocalizableString ls : this.elements) {
            if (s.length() > 0) {
                s.append(this.sep);
            }
            s.append(ls.localizeSync(languageTag));
        }
        return s.toString();
    }
}

