/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.locale;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.JoinPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.locale.ILocalizableString;

public class LocalizableStringBuffer
implements ILocalizableString {
    private static final long serialVersionUID = 1L;
    private LinkedList<Serializable> list = new LinkedList();

    public LocalizableStringBuffer(Serializable ... list) {
        for (int i = 0; i < list.length; ++i) {
            this.list.add(list[i]);
        }
    }

    public void add(Serializable string) {
        this.list.add(string);
    }

    @Override
    public AsyncSupplier<String, NoException> localize(String[] languageTag) {
        JoinPoint jp = new JoinPoint();
        LinkedList<AsyncSupplier<String, NoException>> localizations = new LinkedList<AsyncSupplier<String, NoException>>();
        for (Serializable o : this.list) {
            if (!(o instanceof ILocalizableString)) continue;
            AsyncSupplier<String, NoException> l = ((ILocalizableString)o).localize(languageTag);
            jp.addToJoin(l);
            localizations.add(l);
        }
        AsyncSupplier<String, NoException> result = new AsyncSupplier<String, NoException>();
        jp.start();
        jp.onDone(() -> {
            Iterator it = localizations.iterator();
            StringBuilder s = new StringBuilder();
            for (Serializable o : this.list) {
                if (o instanceof String) {
                    s.append((String)((Object)o));
                    continue;
                }
                if (o instanceof ILocalizableString) {
                    s.append((String)((AsyncSupplier)it.next()).getResult());
                    continue;
                }
                s.append(o);
            }
            result.unblockSuccess(s.toString());
        });
        return result;
    }

    @Override
    public String localizeSync(String[] languageTag) {
        StringBuilder s = new StringBuilder();
        for (Serializable o : this.list) {
            if (o instanceof String) {
                s.append((String)((Object)o));
                continue;
            }
            if (o instanceof ILocalizableString) {
                s.append(((ILocalizableString)o).localizeSync(languageTag));
                continue;
            }
            s.append(o);
        }
        return s.toString();
    }
}

