/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.log;

import net.lecousin.framework.application.Application;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.log.LogPattern;
import net.lecousin.framework.log.appenders.Appender;
import net.lecousin.framework.util.Pair;

class LoggerThread {
    private Thread thread;
    private TurnArray<Pair<Appender, LogPattern.Log>> logs = new TurnArray(200);
    private boolean stop = false;
    private Async<Exception> flushing = null;

    LoggerThread(Application app) {
        Async stopped = new Async();
        this.thread = app.getThreadFactory().newThread(() -> {
            while (true) {
                Pair<Appender, LogPattern.Log> log;
                TurnArray<Pair<Appender, LogPattern.Log>> turnArray = this.logs;
                synchronized (turnArray) {
                    log = this.logs.pollFirst();
                    if (log == null) {
                        if (this.flushing != null) {
                            this.flushing.unblock();
                            this.flushing = null;
                        }
                        if (this.stop) {
                            break;
                        }
                        try {
                            this.logs.wait();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
                try {
                    log.getValue1().append(log.getValue2());
                }
                catch (Exception t) {
                    app.getConsole().err("Error in log appender " + log.getValue1() + ": " + t.getMessage());
                    app.getConsole().err(t);
                }
            }
            System.out.println("Logger Thread stopped.");
            stopped.unblock();
        });
        this.thread.setName("Logger for " + app.getGroupId() + "." + app.getArtifactId() + " " + app.getVersion().toString());
        if (app.isStopping()) {
            return;
        }
        this.thread.start();
        app.toClose(() -> {
            this.stop = true;
            TurnArray<Pair<Appender, LogPattern.Log>> turnArray = this.logs;
            synchronized (turnArray) {
                this.logs.notify();
            }
            return stopped;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void log(Appender appender, LogPattern.Log log) {
        Pair<Appender, LogPattern.Log> p = new Pair<Appender, LogPattern.Log>(appender, log);
        TurnArray<Pair<Appender, LogPattern.Log>> turnArray = this.logs;
        synchronized (turnArray) {
            this.logs.addLast(p);
            this.logs.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IAsync<Exception> flush() {
        TurnArray<Pair<Appender, LogPattern.Log>> turnArray = this.logs;
        synchronized (turnArray) {
            if (this.flushing != null) {
                return this.flushing;
            }
            this.flushing = new Async();
            this.logs.notify();
            return this.flushing;
        }
    }
}

