/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.log.appenders;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.ParseException;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.util.LimitAsyncOperations;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.log.LogPattern;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.log.LoggerConfigurationException;
import net.lecousin.framework.log.LoggerFactory;
import net.lecousin.framework.log.appenders.Appender;
import net.lecousin.framework.text.StringUtil;

public class RollingFileAppender
implements Appender,
Closeable {
    private LoggerFactory factory;
    private File file;
    private FileIO.WriteOnly output = null;
    private long maxSize;
    private int maxFiles;
    private LogPattern pattern;
    private Logger.Level level;
    private boolean closed = false;
    private LimitAsyncOperations<FileLogOperation, Void, IOException> opStack = new LimitAsyncOperations(100, FileLogOperation::execute, null);
    private boolean first = true;

    public RollingFileAppender(LoggerFactory factory, String path, Logger.Level level, LogPattern pattern, long maxSize, int maxFiles) {
        this.factory = factory;
        this.file = new File(path);
        this.level = level;
        this.pattern = pattern;
        this.maxSize = maxSize;
        this.maxFiles = maxFiles;
        factory.getApplication().toClose(this);
    }

    public RollingFileAppender(LoggerFactory factory, XMLStreamReader reader, Map<String, Appender> appenders) throws LoggerConfigurationException, XMLStreamException {
        this.factory = factory;
        String levelStr = null;
        String patternStr = null;
        String path = null;
        String size = null;
        String files = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrValue = reader.getAttributeValue(i);
            if ("level".equals(attrName)) {
                levelStr = attrValue;
                continue;
            }
            if ("pattern".equals(attrName)) {
                patternStr = attrValue;
                continue;
            }
            if ("path".equals(attrName)) {
                path = attrValue;
                continue;
            }
            if ("size".equals(attrName)) {
                size = attrValue;
                continue;
            }
            if ("files".equals(attrName)) {
                files = attrValue;
                continue;
            }
            if ("name".equals(attrName) || "class".equals(attrName)) continue;
            throw new LoggerConfigurationException("Unknown attribute " + attrName);
        }
        if (levelStr == null) {
            throw new LoggerConfigurationException("Missing attribute level on rolling file Appender");
        }
        try {
            this.level = Logger.Level.valueOf(levelStr);
        }
        catch (Exception t) {
            throw new LoggerConfigurationException("Invalid level " + levelStr);
        }
        if (patternStr == null) {
            throw new LoggerConfigurationException("Missing attribute pattern on rolling file Appender");
        }
        this.pattern = new LogPattern(patternStr);
        if (path == null) {
            throw new LoggerConfigurationException("Missing attribute path on rolling file Appender");
        }
        this.file = new File(path);
        if (size == null) {
            throw new LoggerConfigurationException("Missing attribute size on rolling file Appender");
        }
        try {
            this.maxSize = StringUtil.parseSize(size);
        }
        catch (ParseException e) {
            throw new LoggerConfigurationException("Invalid rolling file size: " + size, e);
        }
        if (this.maxSize <= 0L) {
            throw new LoggerConfigurationException("Invalid rolling file size: " + size);
        }
        if (files == null) {
            throw new LoggerConfigurationException("Missing attribute files on rolling file Appender");
        }
        try {
            this.maxFiles = Integer.parseInt(files);
        }
        catch (NumberFormatException e) {
            throw new LoggerConfigurationException("Invalid maximum number of rolling files: " + files);
        }
        if (this.maxFiles <= 0) {
            throw new LoggerConfigurationException("Invalid maximum number of rolling files: " + files);
        }
        reader.next();
        while (reader.getEventType() != 2) {
            if (reader.getEventType() == 1) {
                throw new LoggerConfigurationException("Unexpected inner element " + reader.getLocalName());
            }
            reader.next();
            if (reader.hasNext()) continue;
        }
        factory.getApplication().toClose(this);
    }

    @Override
    public synchronized void append(LogPattern.Log log) {
        if (this.closed) {
            return;
        }
        try {
            if (this.first) {
                this.opStack.write(new OpenLogFile());
                this.first = false;
            }
            StringBuilder msg = this.pattern.generate(log);
            msg.append('\n');
            this.opStack.write(new AppendLog(ByteBuffer.wrap(msg.toString().getBytes(StandardCharsets.UTF_8))));
        }
        catch (Exception e) {
            this.factory.getApplication().getConsole().err(new Exception("Error logging in file " + this.file.getAbsolutePath(), e));
            try {
                if (this.output != null) {
                    this.output.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.output = null;
        }
    }

    @Override
    public int level() {
        return this.level.ordinal();
    }

    @Override
    public boolean needsThreadName() {
        return this.pattern.needsThreadName();
    }

    @Override
    public boolean needsLocation() {
        return this.pattern.needsLocation();
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        if (!this.first) {
            try {
                this.opStack.flush().blockThrow(0L);
                if (this.output != null) {
                    this.output.close();
                }
            }
            catch (Exception e) {
                throw IO.error(e);
            }
            this.output = null;
            this.first = true;
        }
    }

    @Override
    public IAsync<?> flush() {
        return this.opStack.flush();
    }

    private Void error(String message, Throwable cause, AsyncSupplier<Void, IOException> result) {
        IOException error = new IOException(message, cause);
        this.factory.getApplication().getConsole().err(error);
        result.error(error);
        return null;
    }

    private Void cannotCreateLogFile(File file, Throwable cause, AsyncSupplier<Void, IOException> result) {
        return this.error("Cannot create log file: " + file.getAbsolutePath(), cause, result);
    }

    private class AppendLog
    implements FileLogOperation {
        private ByteBuffer log;

        public AppendLog(ByteBuffer log) {
            this.log = log;
        }

        @Override
        public AsyncSupplier<Void, IOException> execute() {
            long fileSize;
            final AsyncSupplier<Void, IOException> result = new AsyncSupplier<Void, IOException>();
            try {
                fileSize = RollingFileAppender.this.output.getSizeSync();
            }
            catch (IOException e) {
                result.error(e);
                return result;
            }
            if (fileSize >= RollingFileAppender.this.maxSize) {
                RollingFileAppender.this.output.closeAsync().thenStart(new Task.OnFile<Void, NoException>(RollingFileAppender.this.file, "Roll log file", 5){

                    @Override
                    public Void run() {
                        File dir = RollingFileAppender.this.file.getParentFile();
                        File f = new File(dir, RollingFileAppender.this.file.getName() + '.' + RollingFileAppender.this.maxFiles);
                        try {
                            Files.deleteIfExists(f.toPath());
                        }
                        catch (IOException e) {
                            return RollingFileAppender.this.error("Unable to remove log file " + f.getAbsolutePath(), e, result);
                        }
                        for (int i = RollingFileAppender.this.maxFiles - 1; i >= 1; --i) {
                            f = new File(dir, RollingFileAppender.this.file.getName() + '.' + i);
                            if (!f.exists() || f.renameTo(new File(dir, RollingFileAppender.this.file.getName() + '.' + (i + 1)))) continue;
                            return RollingFileAppender.this.error("Unable to rename log file " + f.getAbsolutePath(), null, result);
                        }
                        f = new File(dir, RollingFileAppender.this.file.getName() + ".1");
                        if (!RollingFileAppender.this.file.renameTo(f)) {
                            return RollingFileAppender.this.error("Cannot rename log file from " + RollingFileAppender.this.file.getAbsolutePath() + " to " + f.getAbsolutePath(), null, result);
                        }
                        try {
                            if (!RollingFileAppender.this.file.createNewFile()) {
                                return RollingFileAppender.this.cannotCreateLogFile(RollingFileAppender.this.file, null, result);
                            }
                        }
                        catch (Exception t) {
                            return RollingFileAppender.this.cannotCreateLogFile(RollingFileAppender.this.file, t, result);
                        }
                        RollingFileAppender.this.output = new FileIO.WriteOnly(RollingFileAppender.this.file, 5);
                        RollingFileAppender.this.output.writeAsync(AppendLog.this.log).onDone(() -> result.unblockSuccess(null), (IAsync<IOException>)result);
                        return null;
                    }
                }, result);
                return result;
            }
            RollingFileAppender.this.output.writeAsync(this.log).onDone(() -> result.unblockSuccess(null), result);
            return result;
        }
    }

    private class OpenLogFile
    implements FileLogOperation {
        private OpenLogFile() {
        }

        @Override
        public AsyncSupplier<Void, IOException> execute() {
            final AsyncSupplier<Void, IOException> result = new AsyncSupplier<Void, IOException>();
            new Task.OnFile<Void, NoException>(RollingFileAppender.this.file, "Open log file", 5){

                @Override
                public Void run() {
                    if (!RollingFileAppender.this.file.exists()) {
                        File dir = RollingFileAppender.this.file.getParentFile();
                        if (!dir.exists() && !dir.mkdirs()) {
                            return RollingFileAppender.this.error("Cannot create log directory: " + dir.getAbsolutePath(), null, result);
                        }
                        try {
                            if (!RollingFileAppender.this.file.createNewFile()) {
                                return RollingFileAppender.this.cannotCreateLogFile(RollingFileAppender.this.file, null, result);
                            }
                        }
                        catch (Exception e) {
                            return RollingFileAppender.this.cannotCreateLogFile(RollingFileAppender.this.file, e, result);
                        }
                    }
                    RollingFileAppender.this.output = new FileIO.WriteOnly(RollingFileAppender.this.file, 5);
                    RollingFileAppender.this.output.seekAsync(IO.Seekable.SeekType.FROM_END, 0L).onDone(() -> RollingFileAppender.this.output.writeAsync(ByteBuffer.wrap(("\nStart logging with max size = " + RollingFileAppender.this.maxSize + " and max files = " + RollingFileAppender.this.maxFiles + "\n\n").getBytes(StandardCharsets.UTF_8))).onDone(() -> result.unblockSuccess(null), (IAsync<IOException>)result), (IAsync<IOException>)result);
                    return null;
                }
            }.start();
            return result;
        }
    }

    private static interface FileLogOperation {
        public AsyncSupplier<Void, IOException> execute();
    }
}

