/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.text;

import net.lecousin.framework.text.IString;

public abstract class ArrayString
implements IString {
    protected int start;
    protected int end;
    protected int usableEnd;

    @Override
    public int length() {
        return this.end - this.start + 1;
    }

    @Override
    public boolean isEmpty() {
        return this.end == -1 || this.end < this.start;
    }

    public void reset() {
        this.end = this.start - 1;
    }

    public abstract int firstChar();

    public abstract int lastChar();

    public int canAppendWithoutEnlarging() {
        return this.usableEnd - this.end;
    }

    public abstract void trimToSize();

    public abstract boolean appendNoEnlarge(char var1);

    @Override
    public ArrayString trimBeginning() {
        while (this.start <= this.end && Character.isWhitespace(this.firstChar())) {
            ++this.start;
        }
        return this;
    }

    @Override
    public ArrayString trimEnd() {
        while (this.end >= this.start && Character.isWhitespace(this.lastChar())) {
            --this.end;
        }
        return this;
    }

    @Override
    public ArrayString removeEndChars(int nb) {
        this.end -= nb;
        if (this.end < this.start - 1) {
            this.end = this.start - 1;
        }
        return this;
    }

    @Override
    public ArrayString removeStartChars(int nb) {
        this.start += nb;
        if (this.start > this.end) {
            this.start = this.end + 1;
        }
        return this;
    }

    public void moveForward(int skip) {
        this.start += skip;
    }

    public int arrayStart() {
        return this.start;
    }

    public abstract int countChar(char var1);
}

