/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.text;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.List;
import net.lecousin.framework.io.data.CharArray;

public interface IString
extends CharSequence,
Appendable {
    @Override
    public boolean isEmpty();

    public void setCharAt(int var1, char var2);

    @Override
    public IString append(char var1);

    public IString append(char[] var1, int var2, int var3);

    default public IString append(char[] chars) {
        return this.append(chars, 0, chars.length);
    }

    @Override
    public IString append(CharSequence var1);

    @Override
    public IString append(CharSequence var1, int var2, int var3);

    public int indexOf(char var1, int var2);

    public int indexOf(CharSequence var1, int var2);

    default public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    default public int indexOf(CharSequence s) {
        return this.indexOf(s, 0);
    }

    public IString substring(int var1);

    public IString substring(int var1, int var2);

    public int fill(char[] var1, int var2);

    default public int fill(char[] chars) {
        return this.fill(chars, 0);
    }

    public int fillIso8859Bytes(byte[] var1, int var2);

    default public int fillIso8859Bytes(byte[] bytes) {
        return this.fillIso8859Bytes(bytes, 0);
    }

    default public byte[] toIso8859Bytes() {
        byte[] bytes = new byte[this.length()];
        this.fillIso8859Bytes(bytes, 0);
        return bytes;
    }

    public IString trimBeginning();

    public IString trimEnd();

    default public IString trim() {
        this.trimBeginning();
        this.trimEnd();
        return this;
    }

    public IString replace(char var1, char var2);

    public IString replace(CharSequence var1, CharSequence var2);

    public IString replace(char var1, CharSequence var2);

    public IString replace(char var1, char[] var2);

    public IString replace(CharSequence var1, char var2);

    public IString replace(CharSequence var1, char[] var2);

    public IString replace(int var1, int var2, char var3);

    public IString replace(int var1, int var2, CharSequence var3);

    public IString replace(int var1, int var2, char[] var3);

    public IString removeEndChars(int var1);

    public IString removeStartChars(int var1);

    public IString toLowerCase();

    public IString toUpperCase();

    public List<? extends IString> split(char var1);

    public IString copy();

    default public boolean equals(CharSequence s) {
        int l = this.length();
        if (s.length() != l) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if (s.charAt(i) == this.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(CharSequence var1);

    public boolean endsWith(CharSequence var1);

    default public boolean isStartOf(CharSequence s) {
        int l = this.length();
        if (l > s.length()) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if (this.charAt(i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    default public String asString() {
        char[] chars = new char[this.length()];
        this.fill(chars);
        return new String(chars);
    }

    default public char[][] asCharacters() {
        int l = this.length();
        if (l == 0) {
            return new char[0][];
        }
        char[] chars = new char[l];
        this.fill(chars);
        return new char[][]{chars};
    }

    public CharArray[] asCharBuffers();

    default public ByteBuffer encode(Charset cs) throws CharacterCodingException {
        CharArray[] cbs = this.asCharBuffers();
        if (cbs.length == 0) {
            return ByteBuffer.allocate(0);
        }
        int len = this.length();
        if (len == 0) {
            return ByteBuffer.allocate(0);
        }
        CharsetEncoder ce = cs.newEncoder();
        int en = (int)((float)len * ce.maxBytesPerChar());
        byte[] ba = new byte[en];
        ce.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
        ByteBuffer bb = ByteBuffer.wrap(ba);
        CoderResult cr = null;
        for (int i = 0; i < cbs.length; ++i) {
            cr = ce.encode(cbs[i].toCharBuffer(), bb, i == cbs.length - 1);
        }
        if (!cr.isUnderflow()) {
            cr.throwException();
        }
        if (!(cr = ce.flush(bb)).isUnderflow()) {
            cr.throwException();
        }
        bb.flip();
        return bb;
    }
}

