/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.text;

import java.math.BigInteger;
import java.text.ParseException;
import net.lecousin.framework.encoding.EncodingException;
import net.lecousin.framework.encoding.HexaDecimalEncoding;

public final class StringUtil {
    private StringUtil() {
    }

    public static StringBuilder paddingLeft(StringBuilder s, int length, char padding) {
        while (s.length() < length) {
            s.insert(0, padding);
        }
        return s;
    }

    public static StringBuilder paddingLeft(StringBuilder to, String s, int length, char padding) {
        for (int i = s.length(); i < length; ++i) {
            to.append(padding);
        }
        to.append(s);
        return to;
    }

    public static StringBuilder paddingLeft(StringBuilder s, long value, int fixedSize) {
        String str = Long.toString(value);
        return StringUtil.paddingLeft(s, str, fixedSize, ' ');
    }

    public static StringBuilder paddingRight(StringBuilder s, int length, char padding) {
        while (s.length() < length) {
            s.append(padding);
        }
        return s;
    }

    public static StringBuilder paddingRight(StringBuilder to, String s, int nb, char padding) {
        to.append(s);
        for (int i = s.length(); i < nb; ++i) {
            to.append(padding);
        }
        return to;
    }

    public static StringBuilder paddingRight(StringBuilder s, long value, int fixedSize) {
        String str = Long.toString(value);
        return StringUtil.paddingRight(s, str, fixedSize, ' ');
    }

    public static String encodeHexa(byte[] data) {
        return StringUtil.encodeHexa(data, 0, data.length);
    }

    public static String encodeHexa(byte[] data, int off, int len) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            str.append(HexaDecimalEncoding.encodeDigit(data[i + off] >>> 4 & 0xF)).append(HexaDecimalEncoding.encodeDigit(data[i + off] & 0xF));
        }
        return str.toString();
    }

    public static String encodeHexa(byte b) {
        return "" + HexaDecimalEncoding.encodeDigit(b >>> 4 & 0xF) + HexaDecimalEncoding.encodeDigit(b & 0xF);
    }

    public static String encodeHexaPadding(long value) {
        char[] s = new char[]{HexaDecimalEncoding.encodeDigit((int)(value >> 60 & 0xFL)), HexaDecimalEncoding.encodeDigit((int)(value >> 56 & 0xFL)), HexaDecimalEncoding.encodeDigit((int)(value >> 52 & 0xFL)), HexaDecimalEncoding.encodeDigit((int)(value >> 48 & 0xFL)), HexaDecimalEncoding.encodeDigit((int)(value >> 44 & 0xFL)), HexaDecimalEncoding.encodeDigit((int)(value >> 40 & 0xFL)), HexaDecimalEncoding.encodeDigit((int)(value >> 36 & 0xFL)), HexaDecimalEncoding.encodeDigit((int)(value >> 32 & 0xFL)), HexaDecimalEncoding.encodeDigit((int)(value >> 28 & 0xFL)), HexaDecimalEncoding.encodeDigit((int)(value >> 24 & 0xFL)), HexaDecimalEncoding.encodeDigit((int)(value >> 20 & 0xFL)), HexaDecimalEncoding.encodeDigit((int)(value >> 16 & 0xFL)), HexaDecimalEncoding.encodeDigit((int)(value >> 12 & 0xFL)), HexaDecimalEncoding.encodeDigit((int)(value >> 8 & 0xFL)), HexaDecimalEncoding.encodeDigit((int)(value >> 4 & 0xFL)), HexaDecimalEncoding.encodeDigit((int)(value & 0xFL))};
        return new String(s);
    }

    public static byte[] decodeHexa(String s) throws EncodingException {
        byte[] data = new byte[s.length() / 2];
        StringUtil.decodeHexa(s, data);
        return data;
    }

    public static void decodeHexa(String s, byte[] data) throws EncodingException {
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)((HexaDecimalEncoding.decodeChar(s.charAt(i * 2)) << 4) + HexaDecimalEncoding.decodeChar(s.charAt(i * 2 + 1)));
        }
    }

    public static byte decodeHexaByte(String hexa) throws EncodingException {
        int i = HexaDecimalEncoding.decodeChar(hexa.charAt(0));
        if (hexa.length() > 1) {
            i = i << 4 | HexaDecimalEncoding.decodeChar(hexa.charAt(1));
        }
        return (byte)i;
    }

    public static long decodeHexaLong(String hexa) throws EncodingException {
        long l = HexaDecimalEncoding.decodeChar(hexa.charAt(0));
        for (int i = 1; i < hexa.length(); ++i) {
            l <<= 4;
            l |= (long)HexaDecimalEncoding.decodeChar(hexa.charAt(i));
        }
        return l;
    }

    public static String possibleValues(Class<? extends Enum<?>> e) {
        StringBuilder s = new StringBuilder();
        try {
            Enum[] values = (Enum[])e.getMethod("values", new Class[0]).invoke(null, new Object[0]);
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    s.append(", ");
                }
                s.append(values[i].name());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s.toString();
    }

    public static String size(long size) {
        if (size < 1024L) {
            return Long.toString(size);
        }
        if (size < 0x100000L) {
            return String.format("%.2f KB", (double)size / 1024.0);
        }
        if (size < 0x40000000L) {
            return String.format("%.2f MB", (double)size / 1048576.0);
        }
        if (size < 0x10000000000L) {
            return String.format("%.2f GB", (double)size / 1.073741824E9);
        }
        return String.format("%.2f TB", (double)size / 1.099511627776E12);
    }

    public static String size(Number size) {
        if (size instanceof BigInteger) {
            return StringUtil.size((BigInteger)size);
        }
        return StringUtil.size(size.longValue());
    }

    public static String size(BigInteger s) {
        if (s.compareTo(new BigInteger(Long.toString(Long.MAX_VALUE))) <= 0) {
            return StringUtil.size(s.longValue());
        }
        BigInteger tera = s.divide(new BigInteger(Long.toString(0x10000000000L)));
        return tera.toString() + " TB";
    }

    public static long parseSize(String s) throws ParseException {
        int pos;
        int len = s.length();
        char c = s.charAt(0);
        if (c < '0' || c > '9') {
            throw new ParseException("A size must start with a digit: " + s, 0);
        }
        long value = (long)c - 48L;
        for (pos = 1; pos < len && (c = s.charAt(pos)) >= '0' && c <= '9'; ++pos) {
            value = value * 10L + (long)(c - 48);
        }
        if (pos == len) {
            return value;
        }
        while (pos < len && s.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos == len) {
            return value;
        }
        c = s.charAt(pos);
        Double dvalue = null;
        if (c == '.') {
            int i;
            for (i = pos + 1; i < len && Character.isDigit(s.charAt(i)); ++i) {
            }
            try {
                dvalue = Double.valueOf(Long.toString(value) + s.substring(pos, i));
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid size number: " + s, pos);
            }
            if (pos == len) {
                return value;
            }
            for (pos = i; pos < len && s.charAt(pos) == ' '; ++pos) {
            }
            if (pos == len) {
                return value;
            }
        }
        if ((c = s.charAt(pos)) == 'B') {
            return value;
        }
        if (c == 'K') {
            return dvalue != null ? (long)(dvalue * 1024.0) : value * 1024L;
        }
        if (c == 'M') {
            return dvalue != null ? (long)(dvalue * 1024.0 * 1024.0) : value * 1024L * 1024L;
        }
        if (c == 'G') {
            return dvalue != null ? (long)(dvalue * 1024.0 * 1024.0 * 1024.0) : value * 1024L * 1024L * 1024L;
        }
        if (c == 'T') {
            return dvalue != null ? (long)(dvalue * 1024.0 * 1024.0 * 1024.0 * 1024.0) : value * 1024L * 1024L * 1024L * 1024L;
        }
        throw new ParseException("Invalid size unit: " + s, pos);
    }

    public static String duration(long ms) {
        StringBuilder s = new StringBuilder(20);
        if (ms > 3600000L) {
            s.append(ms / 3600000L).append('h');
            ms %= 3600000L;
        }
        if (s.length() > 0 || ms > 60000L) {
            s.append(ms / 60000L).append('m');
            ms %= 60000L;
        }
        if (s.length() > 0 || ms > 1000L) {
            s.append(ms / 1000L).append('s');
            ms %= 1000L;
        }
        s.append(ms).append("ms");
        return s.toString();
    }

    public static int count(String string, String toSearch) {
        int i;
        int pos = 0;
        int count = 0;
        while ((i = string.indexOf(toSearch, pos)) != -1) {
            ++count;
            pos = i + toSearch.length();
        }
        return count;
    }
}

