/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.text;

import java.util.ArrayDeque;
import java.util.ArrayList;
import net.lecousin.framework.text.IStringPattern;

public class WildcardFilePattern
implements IStringPattern {
    private final String[] wcs;

    public WildcardFilePattern(String wildcard) {
        this.wcs = WildcardFilePattern.splitOnTokens(wildcard);
    }

    public static String[] splitOnTokens(String text) {
        if (text.indexOf(63) == -1 && text.indexOf(42) == -1) {
            return new String[]{text};
        }
        char[] array = text.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        char prevChar = '\u0000';
        for (char ch : array) {
            if (ch == '?' || ch == '*') {
                if (buffer.length() != 0) {
                    list.add(buffer.toString());
                    buffer.setLength(0);
                }
                if (ch == '?') {
                    list.add("?");
                } else if (prevChar != '*') {
                    list.add("*");
                }
            } else {
                buffer.append(ch);
            }
            prevChar = ch;
        }
        if (buffer.length() != 0) {
            list.add(buffer.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public boolean matches(String filename) {
        boolean anyChars = false;
        int textIdx = 0;
        int wcsIdx = 0;
        ArrayDeque<int[]> backtrack = new ArrayDeque<int[]>();
        do {
            if (!backtrack.isEmpty()) {
                int[] array = (int[])backtrack.pop();
                wcsIdx = array[0];
                textIdx = array[1];
                anyChars = true;
            }
            while (wcsIdx < this.wcs.length) {
                if (this.wcs[wcsIdx].equals("?")) {
                    if (++textIdx > filename.length()) break;
                    anyChars = false;
                } else if (this.wcs[wcsIdx].equals("*")) {
                    anyChars = true;
                    if (wcsIdx == this.wcs.length - 1) {
                        textIdx = filename.length();
                    }
                } else {
                    if (anyChars) {
                        if ((textIdx = WildcardFilePattern.checkIndexOf(filename, textIdx, this.wcs[wcsIdx])) == -1) break;
                        int repeat = WildcardFilePattern.checkIndexOf(filename, textIdx + 1, this.wcs[wcsIdx]);
                        if (repeat >= 0) {
                            backtrack.push(new int[]{wcsIdx, repeat});
                        }
                    } else if (!WildcardFilePattern.checkRegionMatches(filename, textIdx, this.wcs[wcsIdx])) break;
                    textIdx += this.wcs[wcsIdx].length();
                    anyChars = false;
                }
                ++wcsIdx;
            }
            if (wcsIdx != this.wcs.length || textIdx != filename.length()) continue;
            return true;
        } while (!backtrack.isEmpty());
        return false;
    }

    private static int checkIndexOf(String str, int strStartIndex, String search) {
        int endIndex = str.length() - search.length();
        if (endIndex >= strStartIndex) {
            for (int i = strStartIndex; i <= endIndex; ++i) {
                if (!WildcardFilePattern.checkRegionMatches(str, i, search)) continue;
                return i;
            }
        }
        return -1;
    }

    private static boolean checkRegionMatches(String str, int strStartIndex, String search) {
        return str.regionMatches(true, strStartIndex, search, 0, search.length());
    }
}

