/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.nio.ByteBuffer;
import net.lecousin.framework.text.StringUtil;

public final class DebugUtil {
    private DebugUtil() {
    }

    public static String getCaller() {
        Exception e = new Exception();
        StackTraceElement[] stack = e.getStackTrace();
        if (stack == null || stack.length < 2) {
            return "?";
        }
        return stack[2].getClassName() + "#" + stack[2].getMethodName() + ":" + stack[2].getLineNumber();
    }

    public static StringBuilder createStackTrace(StringBuilder s, Throwable t, boolean includeCause) {
        Throwable cause;
        s.append(t.getClass().getName());
        s.append(": ");
        s.append(t.getMessage());
        DebugUtil.createStackTrace(s, t.getStackTrace());
        if (includeCause && (cause = t.getCause()) != null && cause != t) {
            s.append("\nCaused by: ");
            DebugUtil.createStackTrace(s, cause, true);
        }
        return s;
    }

    public static StringBuilder createStackTrace(StringBuilder s, StackTraceElement[] stack) {
        if (stack != null) {
            for (StackTraceElement e : stack) {
                s.append("\n\tat ");
                s.append(e.getClassName());
                if (e.getMethodName() != null) {
                    s.append('.');
                    s.append(e.getMethodName());
                }
                if (e.getFileName() == null) continue;
                s.append('(');
                s.append(e.getFileName());
                s.append(':');
                s.append(e.getLineNumber());
                s.append(')');
            }
        }
        return s;
    }

    public static void dumpHex(StringBuilder s, byte[] buffer, int offset, int length) {
        DebugUtil.dumpHex(s, ByteBuffer.wrap(buffer, offset, length));
    }

    public static void dumpHex(StringBuilder s, ByteBuffer buffer) {
        int savePos = buffer.position();
        int line = 0;
        while (buffer.hasRemaining()) {
            int i;
            s.append(StringUtil.encodeHexaPadding(16L * (long)line)).append(' ');
            int l = buffer.remaining() >= 16 ? 16 : buffer.remaining();
            byte[] b = new byte[l];
            buffer.get(b);
            for (i = 0; i < 16; ++i) {
                if (b.length <= i) {
                    s.append("   ");
                    continue;
                }
                s.append(StringUtil.encodeHexa(b[i])).append(' ');
            }
            s.append("  ");
            for (i = 0; i < 16; ++i) {
                if (b.length <= i) {
                    s.append(' ');
                    continue;
                }
                char c = (char)(b[i] & 0xFF);
                if (c < ' ' || c > '\u007f') {
                    c = '.';
                }
                s.append(c);
            }
            s.append("\r\n");
            ++line;
        }
        buffer.position(savePos);
    }
}

