/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.mutable.Mutable;

public final class ProcessUtil {
    private ProcessUtil() {
    }

    public static void onProcessExited(Process process, IntConsumer exitValueListener) {
        Application app = LCCore.getApplication();
        Mutable<Object> mt = new Mutable<Object>(null);
        Thread t = app.getThreadFactory().newThread(() -> {
            try {
                exitValueListener.accept(process.waitFor());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            app.interrupted((Thread)mt.get());
        });
        mt.set(t);
        t.setName("Waiting for process to exit");
        t.start();
        app.toInterruptOnShutdown(t);
    }

    public static void consumeProcessConsole(Process process, Consumer<String> outputListener, Consumer<String> errorListener) {
        Application app = LCCore.getApplication();
        ThreadFactory factory = app.getThreadFactory();
        ConsoleConsumer cc = new ConsoleConsumer(process.getInputStream(), outputListener);
        Thread t = factory.newThread(cc);
        t.setName("Process output console consumer");
        cc.app = app;
        cc.t = t;
        t.start();
        app.toInterruptOnShutdown(t);
        cc = new ConsoleConsumer(process.getErrorStream(), errorListener);
        t = factory.newThread(cc);
        t.setName("Process error console consumer");
        cc.app = app;
        cc.t = t;
        t.start();
        app.toInterruptOnShutdown(t);
    }

    public static class ConsoleConsumer
    implements Runnable {
        private InputStream input;
        private Consumer<String> listener;
        private Application app;
        private Thread t;

        public ConsoleConsumer(InputStream input, Consumer<String> listener) {
            this.input = input;
            this.listener = listener;
        }

        @Override
        public void run() {
            StringBuilder line = new StringBuilder();
            byte[] buffer = new byte[1024];
            block4: while (true) {
                int nb;
                try {
                    nb = this.input.read(buffer);
                }
                catch (Exception e) {
                    break;
                }
                if (nb < 0) break;
                if (nb == 0) continue;
                String s = new String(buffer, 0, nb, StandardCharsets.ISO_8859_1);
                while (true) {
                    if (s.length() <= 0) continue block4;
                    int i = s.indexOf(13);
                    int j = s.indexOf(10);
                    if (i < 0 && j < 0) {
                        line.append(s);
                        continue block4;
                    }
                    if (i < 0) {
                        line.append(s.substring(0, j));
                        this.listener.accept(line.toString());
                        line = new StringBuilder();
                        s = s.substring(j + 1);
                        continue;
                    }
                    if (j < 0) {
                        line.append(s.substring(0, i));
                        this.listener.accept(line.toString());
                        line = new StringBuilder();
                        s = s.substring(i + 1);
                        continue;
                    }
                    if (i == j - 1) {
                        line.append(s.substring(0, i));
                        this.listener.accept(line.toString());
                        line = new StringBuilder();
                        s = s.substring(j + 1);
                        continue;
                    }
                    if (j < i) {
                        i = j;
                    }
                    line.append(s.substring(0, i));
                    this.listener.accept(line.toString());
                    line = new StringBuilder();
                    s = s.substring(i + 1);
                }
                break;
            }
            if (line.length() > 0) {
                this.listener.accept(line.toString());
            }
            try {
                this.input.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.app.interrupted(this.t);
        }
    }
}

