/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml;

import java.io.Serializable;
import net.lecousin.framework.exception.LocalizableException;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.locale.ILocalizableString;
import net.lecousin.framework.locale.LocalizableString;
import net.lecousin.framework.locale.LocalizableStringBuffer;

public class XMLException
extends LocalizableException {
    public static final String LOCALIZED_NAMESPACE_XML_ERROR = "lc.xml.error";
    public static final String LOCALIZED_MESSAGE_NOT_XML = "Not an XML file";
    public static final String LOCALIZED_MESSAGE_INVALID_XML = "Invalid XML";
    public static final String LOCALIZED_MESSAGE_UNEXPECTED_CHARACTER = "Unexpected character";
    public static final String LOCALIZED_MESSAGE_UNEXPECTED_END = "Unexpected end";
    public static final String LOCALIZED_MESSAGE_UNEXPECTED_ELEMENT = "Unexpected element";
    public static final String LOCALIZED_MESSAGE_EXPECTED_CHARACTER = "Expected character";
    public static final String LOCALIZED_MESSAGE_IN_XML_DOCUMENT = "in XML document";
    public static final String LOCALIZED_MESSAGE_IN_INTERNAL_SUBSET = "in internal subset declaration";
    private static final long serialVersionUID = -963187033082725980L;

    public XMLException(ICharacterStream.Readable stream, Object context, String message, Serializable ... values) {
        super(XMLException.get(stream, context, (ILocalizableString)new LocalizableString(LOCALIZED_NAMESPACE_XML_ERROR, message, values)));
    }

    public XMLException(ICharacterStream.Readable stream, Object context, ILocalizableString message) {
        super(XMLException.get(stream, context, message));
    }

    public XMLException(ICharacterStream.Readable stream, Object context, ILocalizableString ... messages) {
        super(XMLException.get(stream, context, XMLException.get(messages)));
    }

    private static ILocalizableString get(ICharacterStream.Readable stream, Object context, ILocalizableString message) {
        LocalizableStringBuffer result = new LocalizableStringBuffer(message);
        if (stream instanceof ICharacterStream.Readable.PositionInText) {
            result.add((Serializable)((Object)" "));
            result.add(new LocalizableString(LOCALIZED_NAMESPACE_XML_ERROR, "at", new Serializable[0]));
            result.add((Serializable)((Object)" "));
            result.add(new LocalizableString(LOCALIZED_NAMESPACE_XML_ERROR, "line", new Serializable[0]));
            result.add((Serializable)((Object)(" " + ((ICharacterStream.Readable.PositionInText)stream).getLine() + " ")));
            result.add(new LocalizableString(LOCALIZED_NAMESPACE_XML_ERROR, "character", new Serializable[0]));
            result.add((Serializable)((Object)(" " + ((ICharacterStream.Readable.PositionInText)stream).getPositionInLine())));
        }
        if (context != null) {
            result.add((Serializable)((Object)" ("));
            result.add((Serializable)((Object)context.toString()));
            result.add((Serializable)((Object)")"));
        }
        return result;
    }

    private static ILocalizableString get(ILocalizableString ... messages) {
        LocalizableStringBuffer res = new LocalizableStringBuffer(new Serializable[0]);
        for (int i = 0; i < messages.length; ++i) {
            if (i > 0) {
                res.add((Serializable)((Object)" "));
            }
            res.add(messages[i]);
        }
        return res;
    }
}

