/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.encoding.charset.CharacterDecoder;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.data.ByteArray;
import net.lecousin.framework.io.data.Chars;
import net.lecousin.framework.io.data.CompositeChars;
import net.lecousin.framework.io.text.BufferedReadableCharacterStream;
import net.lecousin.framework.io.text.BufferedReadableCharacterStreamLocation;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.locale.ILocalizableString;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.text.CharArrayStringBuffer;
import net.lecousin.framework.text.IString;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.xml.XMLException;

public abstract class XMLStreamEvents {
    public Event event = new Event();
    protected int maxTextSize = -1;
    protected int maxCDataSize = -1;
    protected ICharacterStream.Readable.Buffered stream;
    private static byte[] charType = new byte[]{99, 99, 99, 99, 99, 99, 99, 99, 99, 2, 2, 99, 99, 2, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 2, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 1, 1, 99, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 99, 99, 99, 99, 99, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 99, 99, 99, 0, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 1, 99, 99, 99, 99, 99, 99, 99, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, 0, 0, 0, 0};

    public final ICharacterStream.Readable.Buffered getCharacterStream() {
        return this.stream;
    }

    public int getMaximumTextSize() {
        return this.maxTextSize;
    }

    public void setMaximumTextSize(int max) {
        this.maxTextSize = max;
    }

    public int getMaximumCDataSize() {
        return this.maxCDataSize;
    }

    public void setMaximumCDataSize(int max) {
        this.maxCDataSize = max;
    }

    public IString getNamespaceURI(CharSequence namespacePrefix) {
        if (namespacePrefix.length() == 0) {
            for (ElementContext ctx : this.event.context) {
                if (ctx.defaultNamespace == null) continue;
                return ctx.defaultNamespace;
            }
            return new CharArrayStringBuffer();
        }
        for (ElementContext ctx : this.event.context) {
            for (Pair<IString, IString> ns : ctx.namespaces) {
                if (!ns.getValue1().equals(namespacePrefix)) continue;
                return ns.getValue2();
            }
        }
        return new CharArrayStringBuffer();
    }

    public Attribute getAttributeByFullName(CharSequence name) {
        for (Attribute attr : this.event.attributes) {
            if (!attr.text.equals(name)) continue;
            return attr;
        }
        return null;
    }

    public Attribute getAttributeByLocalName(CharSequence name) {
        for (Attribute attr : this.event.attributes) {
            if (!attr.localName.equals(name)) continue;
            return attr;
        }
        return null;
    }

    public Attribute getAttributeWithPrefix(CharSequence prefix, CharSequence name) {
        for (Attribute attr : this.event.attributes) {
            if (!attr.localName.equals(name) || !attr.namespacePrefix.equals(prefix)) continue;
            return attr;
        }
        return null;
    }

    public Attribute getAttributeWithNamespaceURI(CharSequence uri, CharSequence name) {
        for (Attribute attr : this.event.attributes) {
            if (!attr.localName.equals(name) || !this.getNamespaceURI(attr.namespacePrefix).equals(uri)) continue;
            return attr;
        }
        return null;
    }

    public IString getAttributeValueByFullName(CharSequence name) {
        for (Attribute attr : this.event.attributes) {
            if (!attr.text.equals(name)) continue;
            return attr.value;
        }
        return null;
    }

    public IString getAttributeValueByLocalName(CharSequence name) {
        for (Attribute attr : this.event.attributes) {
            if (!attr.localName.equals(name)) continue;
            return attr.value;
        }
        return null;
    }

    public IString getAttributeValueWithPrefix(CharSequence prefix, CharSequence name) {
        for (Attribute attr : this.event.attributes) {
            if (!attr.localName.equals(name) || !attr.namespacePrefix.equals(prefix)) continue;
            return attr.value;
        }
        return null;
    }

    public IString getAttributeValueWithNamespaceURI(CharSequence uri, CharSequence name) {
        for (Attribute attr : this.event.attributes) {
            if (!attr.localName.equals(name) || !this.getNamespaceURI(attr.namespacePrefix).equals(uri)) continue;
            return attr.value;
        }
        return null;
    }

    public Attribute removeAttributeByFullName(CharSequence name) {
        Iterator it = this.event.attributes.iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            if (!attr.text.equals(name)) continue;
            it.remove();
            return attr;
        }
        return null;
    }

    public Attribute removeAttributeByLocalName(CharSequence name) {
        Iterator it = this.event.attributes.iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            if (!attr.localName.equals(name)) continue;
            it.remove();
            return attr;
        }
        return null;
    }

    public Attribute removeAttributeWithPrefix(CharSequence prefix, CharSequence name) {
        Iterator it = this.event.attributes.iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            if (!attr.localName.equals(name) || !attr.namespacePrefix.equals(prefix)) continue;
            it.remove();
            return attr;
        }
        return null;
    }

    public Attribute removeAttributeWithNamespaceURI(CharSequence uri, CharSequence name) {
        Iterator it = this.event.attributes.iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            if (!attr.localName.equals(name) || !this.getNamespaceURI(attr.namespacePrefix).equals(uri)) continue;
            it.remove();
            return attr;
        }
        return null;
    }

    protected void reset() {
        if (Event.Type.START_ELEMENT.equals((Object)this.event.type) && this.event.isClosed || Event.Type.END_ELEMENT.equals((Object)this.event.type)) {
            this.event.context.removeFirst();
        }
        this.event.type = null;
        this.event.text = null;
        this.event.namespacePrefix = null;
        this.event.localName = null;
        this.event.isClosed = false;
        this.event.attributes = null;
        this.event.system = null;
        this.event.publicId = null;
    }

    protected void onStartElement(int i) {
        if (i < 0) {
            this.event.namespacePrefix = new CharArrayStringBuffer();
            this.event.localName = this.event.text;
        } else {
            this.event.namespacePrefix = this.event.text.substring(0, i);
            this.event.localName = this.event.text.substring(i + 1);
        }
        ElementContext ctx = new ElementContext();
        ctx.text = this.event.text;
        ctx.namespacePrefix = this.event.namespacePrefix;
        ctx.localName = this.event.localName;
        this.readNamespaces(ctx);
        this.event.context.addFirst(ctx);
        this.event.namespaceURI = this.getNamespaceURI(this.event.namespacePrefix);
    }

    protected void readNamespaces(ElementContext ctx) {
        LinkedList<Pair<IString, IString>> list = new LinkedList<Pair<IString, IString>>();
        Iterator it = this.event.attributes.iterator();
        while (it.hasNext()) {
            Attribute a = (Attribute)it.next();
            if (a.namespacePrefix.isEmpty()) {
                if (!a.localName.equals("xmlns")) continue;
                ctx.defaultNamespace = a.value;
                it.remove();
                continue;
            }
            if (!a.namespacePrefix.equals("xmlns")) continue;
            list.add(new Pair<IString, IString>(a.localName, a.value));
            it.remove();
        }
        ctx.namespaces = list;
    }

    public static boolean isSpaceChar(char c) {
        return c < '\u0100' && charType[c] == 2;
    }

    public static boolean isNameStartChar(char c) {
        if (c < '\u0100') {
            return charType[c] == 0;
        }
        if (c < '\u2000') {
            if (c >= '\u0300' && c <= '\u036f') {
                return false;
            }
            return c != '\u037e';
        }
        if (c < '\ud800') {
            if (c <= '\u3000') {
                if (c < '\u2070') {
                    return c != '\u200c' && c != '\u200d';
                }
                if (c < '\u2190') {
                    return true;
                }
                if (c < '\u2c00') {
                    return false;
                }
                if (c > '\u2fef') {
                    return false;
                }
            }
            return true;
        }
        if (c >= '\ue000') {
            if (c < '\uf900') {
                return false;
            }
            if (c <= '\ufdcf') {
                return true;
            }
            if (c < '\ufdf0') {
                return false;
            }
            return c <= '\ufffd';
        }
        return c < '\udc00';
    }

    public static boolean isNameChar(char c) {
        if (c < '\u0100') {
            return charType[c] <= 1;
        }
        if (c < '\u2000') {
            return c != '\u037e';
        }
        if (c < '\ud800') {
            if (c <= '\u3000') {
                if (c < '\u2070') {
                    return c != '\u200c' && c != '\u200d' && c != '\u203f' && c != '\u2040';
                }
                if (c < '\u2190') {
                    return true;
                }
                if (c < '\u2c00' || c > '\u2fef') {
                    return false;
                }
            }
            return true;
        }
        if (c < '\ue000') {
            return true;
        }
        if (c < '\uf900') {
            return false;
        }
        if (c <= '\ufdcf') {
            return true;
        }
        if (c < '\ufdf0') {
            return false;
        }
        return c <= '\ufffd';
    }

    protected static class Starter {
        protected IO.Readable.Buffered io;
        protected int bufferSize;
        protected int maxBuffers;
        protected boolean addPositionInErrors;
        protected Charset givenEncoding;
        protected Charset bomEncoding;
        protected CharacterDecoder tmpDecoder;
        protected int line = 1;
        protected int posInLine = 1;
        protected CharArrayStringBuffer xmlVersion = null;
        protected CharArrayStringBuffer xmlEncoding = null;
        protected CharArrayStringBuffer xmlStandalone = null;
        private ByteArray firstBytes;
        private Chars.Readable chars;

        public Starter(IO.Readable.Buffered io, Charset givenEncoding, int bufferSize, int maxBuffers, boolean addPositionInErrors) {
            this.io = io;
            this.givenEncoding = givenEncoding;
            this.bufferSize = bufferSize;
            this.maxBuffers = maxBuffers;
            this.addPositionInErrors = addPositionInErrors;
        }

        public ICharacterStream.Readable.Buffered start() throws IOException, XMLException {
            Charset encoding;
            this.loadFirstBytes();
            this.readBOM();
            int posAfterBOM = this.firstBytes.position();
            try {
                this.tmpDecoder = this.givenEncoding != null ? CharacterDecoder.get(this.givenEncoding, this.bufferSize) : (this.bomEncoding != null ? CharacterDecoder.get(this.bomEncoding, this.bufferSize) : CharacterDecoder.get(StandardCharsets.UTF_8, this.bufferSize));
            }
            catch (Exception e) {
                throw new IOException("Error initializing character decoder", e);
            }
            boolean hasDecl = this.readXMLDeclaration();
            if (!hasDecl) {
                ICharacterStream.Readable.Buffered stream = this.initWithoutXMLDeclaration(posAfterBOM);
                if (this.addPositionInErrors) {
                    stream = new BufferedReadableCharacterStreamLocation(stream, this.line, this.posInLine);
                }
                return stream;
            }
            if (this.xmlEncoding != null && !(encoding = Charset.forName(this.xmlEncoding.asString())).equals(this.tmpDecoder.getEncoding())) {
                ICharacterStream.Readable.Buffered stream = this.initWithSpecifiedEncoding(posAfterBOM, encoding);
                if (this.addPositionInErrors) {
                    stream = new BufferedReadableCharacterStreamLocation(stream, this.line, this.posInLine);
                }
                return stream;
            }
            ConcurrentCloseable stream = new BufferedReadableCharacterStream((IO.Readable)this.io, this.tmpDecoder, this.bufferSize, this.maxBuffers, this.firstBytes.hasRemaining() ? this.firstBytes.toByteBuffer() : null, this.chars);
            if (this.addPositionInErrors) {
                stream = new BufferedReadableCharacterStreamLocation((ICharacterStream.Readable.Buffered)((Object)stream), this.line, this.posInLine);
            }
            return stream;
        }

        private void loadFirstBytes() throws IOException {
            ByteBuffer buf = this.io.readNextBuffer();
            if (buf != null) {
                this.firstBytes = ByteArray.readOnlyFromByteBuffer(buf);
                while (this.firstBytes.remaining() < 4 && (buf = this.io.readNextBuffer()) != null) {
                    byte[] b = (byte[])ByteArrayCache.getInstance().get(this.firstBytes.remaining() + buf.remaining(), true);
                    int l = this.firstBytes.remaining();
                    this.firstBytes.get(b, 0, l);
                    buf.get(b, l, buf.remaining());
                    this.firstBytes = new ByteArray(b);
                }
            } else {
                this.firstBytes = new ByteArray(new byte[0]);
            }
        }

        private void readBOM() throws XMLException {
            if (!this.firstBytes.hasRemaining()) {
                throw new XMLException(null, (Object)"File is empty", new ILocalizableString[0]);
            }
            switch (this.firstBytes.getForward(0) & 0xFF) {
                case 0: {
                    this.readBom00();
                    break;
                }
                case 239: {
                    this.readBomEF();
                    break;
                }
                case 254: {
                    this.readBomFE();
                    break;
                }
                case 255: {
                    this.readBomFF();
                    break;
                }
            }
        }

        private void readBomEF() throws XMLException {
            if (this.firstBytes.remaining() == 1) {
                throw new XMLException(null, (Object)"Not an XML file", new ILocalizableString[0]);
            }
            if (this.firstBytes.getForward(1) == -69) {
                if (this.firstBytes.remaining() == 2) {
                    throw new XMLException(null, (Object)"Not an XML file", new ILocalizableString[0]);
                }
                if (this.firstBytes.getForward(2) == -65) {
                    this.bomEncoding = StandardCharsets.UTF_8;
                    this.firstBytes.moveForward(3);
                }
            }
        }

        private void readBomFE() throws XMLException {
            if (this.firstBytes.remaining() == 1) {
                throw new XMLException(null, (Object)"Not an XML file", new ILocalizableString[0]);
            }
            if (this.firstBytes.getForward(1) == -1) {
                this.bomEncoding = StandardCharsets.UTF_16BE;
                this.firstBytes.moveForward(2);
            }
        }

        private void readBomFF() throws XMLException {
            this.readBom16or32((byte)-2, StandardCharsets.UTF_16LE, (byte)0, (byte)0, Charset.forName("UTF-32LE"));
        }

        private void readBom00() throws XMLException {
            this.readBom16or32((byte)0, StandardCharsets.UTF_16BE, (byte)-2, (byte)-1, Charset.forName("UTF-32BE"));
        }

        private void readBom16or32(byte second, Charset secondCharset, byte third, byte fourth, Charset fourthCharset) throws XMLException {
            if (this.firstBytes.remaining() == 1) {
                throw new XMLException(null, (Object)"Not an XML file", new ILocalizableString[0]);
            }
            if (this.firstBytes.getForward(1) == second) {
                if (this.firstBytes.remaining() == 2) {
                    throw new XMLException(null, (Object)"Not an XML file", new ILocalizableString[0]);
                }
                if (this.firstBytes.getForward(2) == third) {
                    if (this.firstBytes.remaining() == 3) {
                        throw new XMLException(null, (Object)"Not an XML file", new ILocalizableString[0]);
                    }
                    if (this.firstBytes.getForward(3) == fourth) {
                        this.bomEncoding = fourthCharset;
                        this.firstBytes.moveForward(4);
                    }
                    return;
                }
                this.bomEncoding = secondCharset;
                this.firstBytes.moveForward(2);
            }
        }

        private ICharacterStream.Readable.Buffered initWithoutXMLDeclaration(int posAfterBOM) {
            if (this.chars != null) {
                this.chars.setPosition(0);
                return new BufferedReadableCharacterStream((IO.Readable)this.io, this.tmpDecoder, this.bufferSize, this.maxBuffers, null, this.chars);
            }
            this.firstBytes.setPosition(posAfterBOM);
            return new BufferedReadableCharacterStream((IO.Readable)this.io, this.tmpDecoder, this.bufferSize, this.maxBuffers, this.firstBytes.toByteBuffer(), null);
        }

        private ICharacterStream.Readable.Buffered initWithSpecifiedEncoding(int posAfterBOM, Charset encoding) throws IOException {
            try {
                this.tmpDecoder = CharacterDecoder.get(encoding, this.bufferSize);
            }
            catch (Exception e) {
                throw new IOException("Error initializing character decoder", e);
            }
            this.firstBytes.setPosition(posAfterBOM);
            BufferedReadableCharacterStream stream = new BufferedReadableCharacterStream((IO.Readable)this.io, this.tmpDecoder, this.bufferSize, this.maxBuffers, this.firstBytes.toByteBuffer(), null);
            boolean end = false;
            block2: do {
                char c = stream.read();
                while (c == '?') {
                    c = stream.read();
                    if (c != '>') continue;
                    end = true;
                    continue block2;
                }
            } while (!end);
            return stream;
        }

        private char nextChar() throws IOException {
            if (this.chars == null) {
                if (this.firstBytes.hasRemaining()) {
                    this.chars = this.tmpDecoder.decode(this.firstBytes);
                    if (this.chars.hasRemaining()) {
                        return this.chars.get();
                    }
                }
                int l = this.firstBytes.length();
                byte[] b = (byte[])ByteArrayCache.getInstance().get(Math.max(512, l * 2), true);
                this.firstBytes.setPosition(0);
                this.firstBytes.get(b, 0, l);
                int nb = this.io.readFullySync(ByteBuffer.wrap(b, l, b.length - l));
                if (nb <= 0) {
                    throw new EOFException();
                }
                this.firstBytes = new ByteArray(b, 0, l + nb);
                this.firstBytes.setPosition(l);
                this.chars = this.tmpDecoder.decode(this.firstBytes);
                if (this.chars.hasRemaining()) {
                    return this.chars.get();
                }
                this.chars = this.tmpDecoder.flush();
                if (this.chars == null) {
                    throw new EOFException();
                }
                return this.chars.get();
            }
            if (this.chars.hasRemaining()) {
                return this.chars.get();
            }
            int l = this.firstBytes.length();
            byte[] b = (byte[])ByteArrayCache.getInstance().get(Math.max(512, l * 2), true);
            this.firstBytes.setPosition(0);
            this.firstBytes.get(b, 0, l);
            int nb = this.io.readFullySync(ByteBuffer.wrap(b, l, b.length - l));
            if (nb <= 0) {
                throw new EOFException();
            }
            this.firstBytes = new ByteArray(b, 0, l + nb);
            this.firstBytes.setPosition(l);
            Chars.Readable newChars = this.tmpDecoder.decode(this.firstBytes);
            if (!newChars.hasRemaining() && (newChars = this.tmpDecoder.flush()) == null) {
                throw new EOFException();
            }
            int pos = this.chars.length();
            this.chars = new CompositeChars.Readable(this.chars, newChars);
            this.chars.setPosition(pos);
            return this.chars.get();
        }

        private boolean readXMLDeclaration() throws IOException {
            char c;
            while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
            }
            if (c != '<') {
                return false;
            }
            if (this.chars.remaining() >= 5 ? this.chars.get() != '?' || (c = this.chars.get()) != 'x' && c != 'X' || (c = this.chars.get()) != 'm' && c != 'M' || (c = this.chars.get()) != 'l' && c != 'L' || !XMLStreamEvents.isSpaceChar(this.chars.get()) : this.nextChar() != '?' || (c = this.nextChar()) != 'x' && c != 'X' || (c = this.nextChar()) != 'm' && c != 'M' || (c = this.nextChar()) != 'l' && c != 'L' || !XMLStreamEvents.isSpaceChar(this.nextChar())) {
                return false;
            }
            while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
            }
            if (c != 'v' && c != 'V') {
                throw new IOException("Invalid XML Declaration: first attribute must be 'version'");
            }
            this.xmlVersion = this.eat(new char[]{'e', 'r', 's', 'i', 'o', 'n'}, new char[]{'E', 'R', 'S', 'I', 'O', 'N'});
            if (this.xmlVersion == null) {
                throw new IOException("Invalid XML Declaration: first attribute must be 'version'");
            }
            while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
            }
            if (c == 'e' || c == 'E') {
                this.xmlEncoding = this.eat(new char[]{'n', 'c', 'o', 'd', 'i', 'n', 'g'}, new char[]{'N', 'C', 'O', 'D', 'I', 'N', 'G'});
                if (this.xmlEncoding == null) {
                    throw new IOException("Invalid XML Declaration: unknown attribute");
                }
                while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
                }
            }
            if (c == 's' || c == 'S') {
                this.xmlStandalone = this.eat(new char[]{'t', 'a', 'n', 'd', 'a', 'l', 'o', 'n', 'e'}, new char[]{'T', 'A', 'N', 'D', 'A', 'L', 'O', 'N', 'E'});
                if (this.xmlStandalone == null) {
                    throw new IOException("Invalid XML Declaration: unknown attribute");
                }
                while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
                }
            }
            if (c != '?') {
                throw new IOException("Unexpected character '" + c + "' in XML declaration tag");
            }
            if (this.nextChar() != '>') {
                throw new IOException("Unexpected character '" + c + "' in XML declaration tag");
            }
            return true;
        }

        private CharArrayStringBuffer eat(char[] lowerCase, char[] upperCase) throws IOException {
            char c;
            int i;
            int l = lowerCase.length;
            if (this.chars.remaining() >= l) {
                for (i = 0; i < l; ++i) {
                    c = this.chars.get();
                    if (c == lowerCase[i] || c == upperCase[i]) continue;
                    return null;
                }
            } else {
                for (i = 0; i < l; ++i) {
                    c = this.nextChar();
                    if (c == lowerCase[i] || c == upperCase[i]) continue;
                    return null;
                }
            }
            while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
            }
            if (c != '=') {
                throw new IOException("Invalid XML Declaration: character '=' expected after attribute name");
            }
            while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
            }
            if (c != '\'' && c != '\"') {
                throw new IOException("Invalid XML Declaration: character ' or \" expected after '='");
            }
            char c2 = c;
            CharArrayStringBuffer value = new CharArrayStringBuffer();
            while ((c = this.nextChar()) != c2) {
                value.append(c);
            }
            return value;
        }
    }

    public static class Attribute {
        public IString text;
        public IString namespacePrefix;
        public IString localName;
        public IString value;
    }

    public static class ElementContext {
        public IString text;
        public IString namespacePrefix;
        public IString localName;
        public List<Pair<IString, IString>> namespaces = new LinkedList<Pair<IString, IString>>();
        public IString defaultNamespace = null;

        public String toString() {
            return "XML Element Context: " + (this.localName != null ? this.localName.asString() : "null");
        }
    }

    public static class Event {
        public Type type = null;
        public IString text = null;
        public IString namespacePrefix = null;
        public IString namespaceURI = null;
        public IString localName = null;
        public boolean isClosed = false;
        public LinkedList<Attribute> attributes = null;
        public CharArrayStringBuffer system = null;
        public CharArrayStringBuffer publicId = null;
        public LinkedList<ElementContext> context = new LinkedList();

        public Event copy() {
            Event event = new Event();
            event.type = this.type;
            event.text = this.text;
            event.namespacePrefix = this.namespacePrefix;
            event.localName = this.localName;
            event.namespaceURI = this.namespaceURI;
            event.isClosed = this.isClosed;
            if (this.attributes != null) {
                event.attributes = new LinkedList<Attribute>(this.attributes);
            }
            event.system = this.system;
            event.publicId = this.publicId;
            event.context.addAll(this.context);
            return event;
        }

        public static enum Type {
            PROCESSING_INSTRUCTION,
            DOCTYPE,
            COMMENT,
            TEXT,
            START_ELEMENT,
            END_ELEMENT,
            CDATA;

        }
    }
}

