/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml;

import java.util.HashMap;
import java.util.Map;
import net.lecousin.framework.collections.CollectionsUtil;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.text.CharArrayStringBuffer;
import net.lecousin.framework.xml.XMLStreamEvents;

public abstract class XMLStreamEventsAsync
extends XMLStreamEvents {
    public abstract IAsync<Exception> start();

    public abstract byte getPriority();

    public abstract Async<Exception> next();

    public IAsync<Exception> nextStartElement() {
        Async<Exception> next = this.next();
        if (next.isDone()) {
            if (next.hasError()) {
                return next;
            }
            if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
                return next;
            }
            return this.nextStartElement();
        }
        Async<Exception> sp = new Async<Exception>();
        next.onDone(() -> {
            if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
                sp.unblock();
                return;
            }
            new Next((Async)sp){

                @Override
                protected void onNext() {
                    if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)XMLStreamEventsAsync.this.event.type)) {
                        this.sp.unblock();
                    } else {
                        XMLStreamEventsAsync.this.nextStartElement().onDone(this.sp);
                    }
                }
            }.start();
        }, sp);
        return sp;
    }

    public AsyncSupplier<Boolean, Exception> nextInnerElement(XMLStreamEvents.ElementContext parent) {
        if (this.event.context.isEmpty() || XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type) && this.event.context.getFirst() == parent && this.event.isClosed || XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type) && this.event.context.getFirst() == parent) {
            return new AsyncSupplier<Boolean, Object>(Boolean.FALSE, null);
        }
        if (!CollectionsUtil.containsInstance(this.event.context, parent)) {
            return new AsyncSupplier<Object, Exception>(null, new Exception("Invalid context: parent element " + parent.localName + " is not in the current context"));
        }
        Async<Exception> next = this.next();
        while (next.isDone()) {
            if (next.hasError()) {
                return new AsyncSupplier(null, next.getError());
            }
            if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type)) {
                if (this.event.context.getFirst() == parent) {
                    return new AsyncSupplier<Boolean, Object>(Boolean.FALSE, null);
                }
            } else if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type) && this.event.context.size() > 1 && this.event.context.get(1) == parent) {
                return new AsyncSupplier<Boolean, Object>(Boolean.TRUE, null);
            }
            next = this.next();
        }
        AsyncSupplier<Boolean, Exception> result = new AsyncSupplier<Boolean, Exception>();
        Async<Exception> n = next;
        next.onDone(() -> {
            if (n.hasError()) {
                result.error((Exception)n.getError());
            } else if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type) && this.event.context.getFirst() == parent) {
                result.unblockSuccess(Boolean.FALSE);
            } else if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type) && this.event.context.size() > 1 && this.event.context.get(1) == parent) {
                result.unblockSuccess(Boolean.TRUE);
            } else {
                new ParsingTask(() -> this.nextInnerElement(parent).forward(result)).start();
            }
        }, result);
        return result;
    }

    public AsyncSupplier<Boolean, Exception> nextInnerElement(XMLStreamEvents.ElementContext parent, String childName) {
        AsyncSupplier<Boolean, Exception> next = this.nextInnerElement(parent);
        while (next.isDone()) {
            if (next.hasError()) {
                return next;
            }
            if (!next.getResult().booleanValue()) {
                return next;
            }
            if (this.event.text.equals(childName)) {
                return next;
            }
            next = this.nextInnerElement(parent);
        }
        AsyncSupplier<Boolean, Exception> result = new AsyncSupplier<Boolean, Exception>();
        AsyncSupplier<Boolean, Exception> n = next;
        next.onDone(() -> {
            if (n.hasError()) {
                result.error((Exception)n.getError());
            } else if (!((Boolean)n.getResult()).booleanValue()) {
                result.unblockSuccess(Boolean.FALSE);
            } else if (this.event.text.equals(childName)) {
                result.unblockSuccess(Boolean.TRUE);
            } else {
                new ParsingTask(() -> this.nextInnerElement(parent, childName).forward(result)).start();
            }
        }, result);
        return result;
    }

    protected boolean check(IAsync<Exception> op, IAsync<Exception> result) {
        if (op.hasError()) {
            result.error(op.getError());
            return false;
        }
        return true;
    }

    public AsyncSupplier<CharArrayStringBuffer, Exception> readInnerText() {
        if (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
            return new AsyncSupplier<Object, Exception>(null, new Exception("Invalid call of readInnerText: it must be called on a start element"));
        }
        if (this.event.isClosed) {
            return new AsyncSupplier<CharArrayStringBuffer, Object>(new CharArrayStringBuffer(), null);
        }
        CharArrayStringBuffer innerText = new CharArrayStringBuffer();
        AsyncSupplier<CharArrayStringBuffer, Exception> result = new AsyncSupplier<CharArrayStringBuffer, Exception>();
        this.readInnerText(innerText, result);
        return result;
    }

    private void readInnerText(CharArrayStringBuffer innerText, AsyncSupplier<CharArrayStringBuffer, Exception> result) {
        Async<Exception> next = this.next();
        while (next.isDone()) {
            if (!this.check(next, result)) {
                return;
            }
            if (XMLStreamEvents.Event.Type.COMMENT.equals((Object)this.event.type)) {
                next = this.next();
                continue;
            }
            if (XMLStreamEvents.Event.Type.TEXT.equals((Object)this.event.type)) {
                innerText.append(this.event.text);
                next = this.next();
                continue;
            }
            if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
                if (this.event.isClosed) {
                    next = this.next();
                    continue;
                }
                this.closeElement().thenStart(new ParsingTask(() -> this.readInnerText(innerText, result)), result);
                return;
            }
            if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type)) {
                result.unblockSuccess(innerText);
                return;
            }
            next = this.next();
        }
        next.onDone(() -> {
            if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
                if (this.event.isClosed) {
                    new ParsingTask(() -> this.readInnerText(innerText, result)).start();
                    return;
                }
                this.closeElement().thenStart(new ParsingTask(() -> this.readInnerText(innerText, result)), result);
                return;
            }
            if (XMLStreamEvents.Event.Type.COMMENT.equals((Object)this.event.type)) {
                new ParsingTask(() -> this.readInnerText(innerText, result)).start();
            } else if (XMLStreamEvents.Event.Type.TEXT.equals((Object)this.event.type)) {
                innerText.append(this.event.text);
                new ParsingTask(() -> this.readInnerText(innerText, result)).start();
            } else if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type)) {
                result.unblockSuccess(innerText);
            } else {
                new ParsingTask(() -> this.readInnerText(innerText, result)).start();
            }
        }, result);
    }

    public IAsync<Exception> closeElement() {
        if (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
            return new Async<Exception>(new Exception("Invalid call of closeElement: it must be called on a start element"));
        }
        if (this.event.isClosed) {
            return new Async<boolean>(true);
        }
        XMLStreamEvents.ElementContext ctx = this.event.context.getFirst();
        return this.closeElement(ctx);
    }

    public IAsync<Exception> closeElement(XMLStreamEvents.ElementContext ctx) {
        Async<Exception> next = this.next();
        while (next.isDone()) {
            if (next.hasError()) {
                return next;
            }
            if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type) && this.event.context.getFirst() == ctx) {
                return next;
            }
            next = this.next();
        }
        Async<Exception> result = new Async<Exception>();
        Async<Exception> n = next;
        next.onDone(() -> {
            if (!this.check(n, result)) {
                return;
            }
            if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type) && this.event.context.getFirst() == ctx) {
                result.unblock();
                return;
            }
            new ParsingTask(() -> this.closeElement(ctx).onDone(result)).start();
        }, result);
        return result;
    }

    public IAsync<Exception> searchElement(String elementName) {
        Async<Exception> next = this.next();
        while (next.isDone()) {
            if (next.hasError()) {
                return next;
            }
            if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type) && this.event.text.equals(elementName)) {
                return next;
            }
            next = this.next();
        }
        Async<Exception> result = new Async<Exception>();
        Async<Exception> n = next;
        next.onDone(() -> {
            if (n.hasError()) {
                result.error((Exception)n.getError());
            } else if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type) && this.event.text.equals(elementName)) {
                result.unblock();
            } else {
                new ParsingTask(() -> this.searchElement(elementName).onDone(result)).start();
            }
        }, result);
        return result;
    }

    public AsyncSupplier<Boolean, Exception> goInto(XMLStreamEvents.ElementContext rootContext, String ... innerElements) {
        return this.goInto(rootContext, 0, innerElements);
    }

    private AsyncSupplier<Boolean, Exception> goInto(XMLStreamEvents.ElementContext parent, int i, String ... innerElements) {
        AsyncSupplier<Boolean, Exception> next = this.nextInnerElement(parent, innerElements[i]);
        while (next.isDone()) {
            if (next.hasError()) {
                return next;
            }
            if (!next.getResult().booleanValue()) {
                return next;
            }
            if (++i == innerElements.length) {
                return next;
            }
            parent = this.event.context.getFirst();
            next = this.nextInnerElement(parent, innerElements[i]);
        }
        AsyncSupplier<Boolean, Exception> result = new AsyncSupplier<Boolean, Exception>();
        AsyncSupplier<Boolean, Exception> n = next;
        int ii = i;
        next.onDone(() -> {
            if (n.hasError()) {
                result.error((Exception)n.getError());
            } else if (!((Boolean)n.getResult()).booleanValue()) {
                result.unblockSuccess(Boolean.FALSE);
            } else if (ii == innerElements.length - 1) {
                result.unblockSuccess(Boolean.TRUE);
            } else {
                new ParsingTask(() -> this.goInto(this.event.context.getFirst(), ii + 1, innerElements).forward(result)).start();
            }
        }, result);
        return result;
    }

    public AsyncSupplier<Map<String, String>, Exception> readInnerElementsText() {
        AsyncSupplier<Map<String, String>, Exception> result = new AsyncSupplier<Map<String, String>, Exception>();
        HashMap<String, String> texts = new HashMap<String, String>();
        this.readInnerElementsText(this.event.context.getFirst(), texts, result);
        return result;
    }

    private void readInnerElementsText(XMLStreamEvents.ElementContext parent, Map<String, String> texts, AsyncSupplier<Map<String, String>, Exception> result) {
        AsyncSupplier<Boolean, Exception> next = this.nextInnerElement(parent);
        while (next.isDone()) {
            if (!this.check(next, result)) {
                return;
            }
            if (!next.getResult().booleanValue()) {
                result.unblockSuccess(texts);
                return;
            }
            String name = this.event.text.asString();
            AsyncSupplier<CharArrayStringBuffer, Exception> read = this.readInnerText();
            if (read.isDone()) {
                if (!this.check(read, result)) {
                    return;
                }
                texts.put(name, read.getResult().asString());
                next = this.nextInnerElement(parent);
                continue;
            }
            read.onDone(value -> {
                texts.put(name, value.asString());
                new ParsingTask(() -> this.readInnerElementsText(parent, texts, result)).start();
            }, result);
            return;
        }
        next.onDone(res -> {
            if (!res.booleanValue()) {
                result.unblockSuccess(texts);
                return;
            }
            String name = this.event.text.asString();
            new ParsingTask(() -> {
                AsyncSupplier<CharArrayStringBuffer, Exception> read = this.readInnerText();
                if (read.isDone()) {
                    if (!this.check(read, result)) {
                        return;
                    }
                    texts.put(name, read.getResult().asString());
                    this.readInnerElementsText(parent, texts, result);
                    return;
                }
                read.onDone(value -> {
                    texts.put(name, value.asString());
                    new ParsingTask(() -> this.readInnerElementsText(parent, texts, result)).start();
                }, (IAsync<Exception>)result);
            }).start();
        }, result);
    }

    protected class Next
    extends ParsingTask {
        protected Async<Exception> sp;

        public Next(Async<Exception> sp) {
            super(null);
            this.sp = sp;
        }

        @Override
        public Void run() {
            Async<Exception> next = XMLStreamEventsAsync.this.next();
            if (next.isDone()) {
                if (next.hasError()) {
                    this.sp.error((Exception)next.getError());
                } else {
                    this.onNext();
                }
                return null;
            }
            next.thenStart(new Task.Cpu<Void, NoException>("Parse XML", XMLStreamEventsAsync.this.getPriority()){

                @Override
                public Void run() {
                    Next.this.onNext();
                    return null;
                }
            }, this.sp);
            return null;
        }

        protected void onNext() {
            this.sp.unblock();
        }
    }

    protected class ParsingTask
    extends Task.Cpu<Void, NoException> {
        private Runnable r;

        public ParsingTask(Runnable r) {
            super("Parse XML", XMLStreamEventsAsync.this.getPriority());
            this.r = r;
        }

        @Override
        public Void run() {
            this.r.run();
            return null;
        }
    }
}

