/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml;

import java.io.EOFException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.xml.XMLException;
import net.lecousin.framework.xml.XMLStreamEvents;
import net.lecousin.framework.xml.XMLStreamEventsAsync;
import net.lecousin.framework.xml.XMLStreamEventsSync;

public interface XMLStreamEventsRecorder {
    public void startRecording(boolean var1);

    public void stopRecording();

    public void replay();

    public XMLStreamEvents.Event getFirstRecordedEvent();

    public static class Async
    extends XMLStreamEventsAsync
    implements XMLStreamEventsRecorder {
        protected XMLStreamEventsAsync xmlStream;
        protected boolean recording = false;
        protected LinkedList<XMLStreamEvents.Event> record = null;
        protected Iterator<XMLStreamEvents.Event> replaying = null;

        public Async(XMLStreamEventsAsync stream) {
            this.xmlStream = stream;
            this.event = stream.event;
        }

        @Override
        public byte getPriority() {
            return this.xmlStream.getPriority();
        }

        @Override
        public XMLStreamEvents.Event getFirstRecordedEvent() {
            return this.record != null && !this.record.isEmpty() ? this.record.getFirst() : null;
        }

        @Override
        public IAsync<Exception> start() {
            return this.xmlStream.start();
        }

        @Override
        public net.lecousin.framework.concurrent.async.Async<Exception> next() {
            if (this.replaying != null) {
                if (!this.replaying.hasNext()) {
                    return new net.lecousin.framework.concurrent.async.Async<Exception>(new EOFException());
                }
                this.event = this.replaying.next();
                return new net.lecousin.framework.concurrent.async.Async<boolean>(true);
            }
            net.lecousin.framework.concurrent.async.Async<Exception> next = this.xmlStream.next();
            next.onDone(() -> {
                if (next.isSuccessful()) {
                    this.event = this.xmlStream.event;
                    if (this.recording) {
                        this.record.add(this.xmlStream.event.copy());
                    }
                }
            });
            return next;
        }

        @Override
        public void startRecording(boolean recordCurrentEvent) {
            this.recording = true;
            this.record = new LinkedList();
            if (recordCurrentEvent) {
                this.record.add(this.xmlStream.event.copy());
            }
        }

        @Override
        public void stopRecording() {
            this.recording = false;
        }

        @Override
        public void replay() {
            this.replaying = this.record.iterator();
            this.event = !this.replaying.hasNext() ? null : this.replaying.next();
        }
    }

    public static class Sync
    extends XMLStreamEventsSync
    implements XMLStreamEventsRecorder {
        protected XMLStreamEventsSync xmlStream;
        protected boolean recording = false;
        protected LinkedList<XMLStreamEvents.Event> record = null;
        protected Iterator<XMLStreamEvents.Event> replaying = null;

        public Sync(XMLStreamEventsSync stream) {
            this.xmlStream = stream;
            this.event = stream.event;
        }

        @Override
        public XMLStreamEvents.Event getFirstRecordedEvent() {
            return this.record != null && !this.record.isEmpty() ? this.record.getFirst() : null;
        }

        @Override
        public void start() throws XMLException, IOException {
            this.xmlStream.start();
        }

        @Override
        public void next() throws XMLException, IOException {
            if (this.replaying != null) {
                if (!this.replaying.hasNext()) {
                    throw new EOFException();
                }
                this.event = this.replaying.next();
                return;
            }
            this.xmlStream.next();
            this.event = this.xmlStream.event;
            if (this.recording) {
                this.record.add(this.xmlStream.event.copy());
            }
        }

        @Override
        public void startRecording(boolean recordCurrentEvent) {
            this.recording = true;
            this.record = new LinkedList();
            if (recordCurrentEvent) {
                this.record.add(this.xmlStream.event.copy());
            }
        }

        @Override
        public void stopRecording() {
            this.recording = false;
        }

        @Override
        public void replay() {
            this.replaying = this.record.iterator();
            this.event = !this.replaying.hasNext() ? null : this.replaying.next();
        }
    }
}

