/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.LinkedList;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.encoding.number.DecimalNumber;
import net.lecousin.framework.encoding.number.HexadecimalNumber;
import net.lecousin.framework.encoding.number.NumberEncoding;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.PreBufferedReadable;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.locale.LocalizableString;
import net.lecousin.framework.text.CappedString;
import net.lecousin.framework.text.CharArrayString;
import net.lecousin.framework.text.CharArrayStringBuffer;
import net.lecousin.framework.text.IString;
import net.lecousin.framework.xml.XMLException;
import net.lecousin.framework.xml.XMLStreamEvents;
import net.lecousin.framework.xml.XMLStreamEventsSync;

public class XMLStreamReader
extends XMLStreamEventsSync {
    private Charset defaultEncoding;
    private int charactersBuffersSize;
    private int maxBuffers;
    private IO.Readable.Buffered io;
    private static final char[] CDATA = new char[]{'C', 'D', 'A', 'T', 'A', '['};
    private static final char[] OCTYPE = new char[]{'O', 'C', 'T', 'Y', 'P', 'E'};
    private static final char[] YSTEM = new char[]{'Y', 'S', 'T', 'E', 'M'};
    private static final char[] UBLIC = new char[]{'U', 'B', 'L', 'I', 'C'};

    public XMLStreamReader(IO.Readable io, Charset defaultEncoding, int charactersBuffersSize, int maxBuffers) {
        this.io = io instanceof IO.Readable.Buffered ? (IO.Readable.Buffered)io : new PreBufferedReadable(io, 1024, io.getPriority(), charactersBuffersSize, (byte)(io.getPriority() - 1), maxBuffers);
        this.defaultEncoding = defaultEncoding;
        this.charactersBuffersSize = charactersBuffersSize;
        this.maxBuffers = maxBuffers;
    }

    public XMLStreamReader(IO.Readable io, int charactersBuffersSize, int maxBuffers) {
        this(io, null, charactersBuffersSize, maxBuffers);
    }

    public static AsyncSupplier<XMLStreamReader, Exception> start(IO.Readable.Buffered io, int charactersBufferSize, int maxBuffers, boolean addPositionInErrors) {
        AsyncSupplier<XMLStreamReader, Exception> result = new AsyncSupplier<XMLStreamReader, Exception>();
        new Task.Cpu.FromRunnable("Start reading XML " + io.getSourceDescription(), io.getPriority(), () -> {
            XMLStreamReader reader = new XMLStreamReader(io, charactersBufferSize, maxBuffers);
            try {
                XMLStreamEvents.Starter start = new XMLStreamEvents.Starter(io, reader.defaultEncoding, reader.charactersBuffersSize, reader.maxBuffers, addPositionInErrors);
                reader.stream = start.start();
                reader.stream.canStartReading().thenStart(new Task.Cpu.FromRunnable("Start reading XML " + io.getSourceDescription(), io.getPriority(), () -> {
                    try {
                        reader.next();
                        result.unblockSuccess(reader);
                    }
                    catch (Exception e) {
                        result.unblockError(e);
                    }
                }), true);
            }
            catch (Exception e) {
                result.unblockError(e);
            }
        }).startOn(io.canStartReading(), true);
        return result;
    }

    @Override
    public void start() throws XMLException, IOException {
        XMLStreamEvents.Starter start = new XMLStreamEvents.Starter(this.io, this.defaultEncoding, this.charactersBuffersSize, this.maxBuffers, false);
        this.stream = start.start();
        this.next();
    }

    @Override
    public void next() throws XMLException, IOException {
        this.reset();
        char c = this.stream.read();
        if (c == '<') {
            this.readTag();
        } else {
            this.readChars(c);
        }
    }

    public void startRootElement() throws XMLException, IOException {
        this.start();
        while (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
            this.next();
        }
    }

    private void readTag() throws XMLException, IOException {
        block6: {
            try {
                char c = this.stream.read();
                if (XMLStreamReader.isNameStartChar(c)) {
                    this.readStartTag(c);
                    break block6;
                }
                if (c == '/') {
                    this.readEndTag();
                    break block6;
                }
                if (c == '!') {
                    this.readTagExclamation();
                    break block6;
                }
                if (c == '?') {
                    this.readProcessingInstruction();
                    break block6;
                }
                throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c));
            }
            catch (EOFException e) {
                throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0]));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readTagExclamation() throws XMLException, IOException {
        char c = this.stream.read();
        if (c == '-') {
            if (this.stream.read() != '-') throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Invalid XML", new Serializable[0]);
            this.readComment();
            return;
        } else if (c == '[') {
            if (!this.readExpectedChars(CDATA)) {
                throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Invalid XML", new Serializable[0]);
            }
            this.readCData();
            return;
        } else {
            if (c != 'D') throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Invalid XML", new Serializable[0]);
            if (!this.readExpectedChars(OCTYPE)) {
                throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Invalid XML", new Serializable[0]);
            }
            this.readDocType();
        }
    }

    private void readDocType() throws XMLException, IOException {
        char c;
        this.event.type = XMLStreamEvents.Event.Type.DOCTYPE;
        this.event.text = new CharArrayStringBuffer();
        this.readSpace();
        this.readName(this.event.text);
        while (XMLStreamReader.isSpaceChar(c = this.stream.read())) {
        }
        if (c == 'S') {
            if (!this.readExpectedChars(YSTEM)) {
                throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Invalid XML", new Serializable[0]);
            }
            this.readSpace();
            this.event.system = this.readSystemLiteral();
            c = this.stream.read();
            while (XMLStreamReader.isSpaceChar(c)) {
                c = this.stream.read();
            }
        } else if (c == 'P') {
            if (!this.readExpectedChars(UBLIC)) {
                throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Invalid XML", new Serializable[0]);
            }
            this.readSpace();
            this.event.publicId = this.readPublicIDLiteral();
            this.readSpace();
            this.event.system = this.readSystemLiteral();
            c = this.stream.read();
            while (XMLStreamReader.isSpaceChar(c)) {
                c = this.stream.read();
            }
        }
        if (c == '[') {
            this.readIntSubset();
            c = this.stream.read();
            while (XMLStreamReader.isSpaceChar(c)) {
                c = this.stream.read();
            }
        }
        if (c != '>') {
            throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c));
        }
    }

    private void readComment() throws XMLException, IOException {
        this.event.type = XMLStreamEvents.Event.Type.COMMENT;
        this.event.text = this.maxTextSize <= 0 ? new CharArrayStringBuffer() : new CappedString(this.maxTextSize);
        IString t = this.event.text;
        try {
            while (true) {
                if (!this.stream.readUntil('-', t)) {
                    throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "inside comment", new Serializable[0]));
                }
                char c = this.stream.read();
                if (c != '-') {
                    t.append(new CharArrayString(new char[]{'-', c}));
                    continue;
                }
                while (true) {
                    if ((c = this.stream.read()) == '>') {
                        return;
                    }
                    if (c != '-') break;
                    t.append('-');
                }
                t.append(new CharArrayString(new char[]{'-', '-', c}));
            }
        }
        catch (EOFException e) {
            throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "inside comment", new Serializable[0]));
        }
    }

    private boolean readExpectedChars(char[] expected) throws IOException {
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == this.stream.read()) continue;
            return false;
        }
        return true;
    }

    private void readCData() throws XMLException, IOException {
        this.event.type = XMLStreamEvents.Event.Type.CDATA;
        this.event.text = this.maxCDataSize <= 0 ? new CharArrayStringBuffer() : new CappedString(this.maxCDataSize);
        IString t = this.event.text;
        try {
            while (true) {
                if (!this.stream.readUntil(']', t)) {
                    throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "inside CDATA", new Serializable[0]));
                }
                char c = this.stream.read();
                if (c != ']') {
                    t.append(new char[]{']', c});
                    continue;
                }
                while (true) {
                    if ((c = this.stream.read()) == '>') {
                        return;
                    }
                    if (c != ']') break;
                    t.append(']');
                }
                t.append(new char[]{']', ']', c});
            }
        }
        catch (EOFException e) {
            throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "inside CDATA", new Serializable[0]));
        }
    }

    private void readStartTag(char c) throws XMLException, IOException {
        this.event.type = XMLStreamEvents.Event.Type.START_ELEMENT;
        this.event.attributes = new LinkedList();
        this.event.text = new CharArrayStringBuffer();
        int colonPos = this.continueReadName(this.event.text, c);
        while (true) {
            if (XMLStreamReader.isSpaceChar(c = this.stream.read())) continue;
            if (c == '>') break;
            if (c == '/') {
                if (this.stream.read() != '>') {
                    throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Invalid XML", new Serializable[0]);
                }
                this.event.isClosed = true;
                break;
            }
            if (!XMLStreamReader.isNameStartChar(c)) {
                throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c));
            }
            XMLStreamEvents.Attribute a = new XMLStreamEvents.Attribute();
            a.text = new CharArrayStringBuffer();
            int i = this.continueReadName(a.text, c);
            if (i < 0) {
                a.namespacePrefix = new CharArrayStringBuffer();
                a.localName = a.text;
            } else {
                a.namespacePrefix = a.text.substring(0, i);
                a.localName = a.text.substring(i + 1);
            }
            while (XMLStreamReader.isSpaceChar(c = this.stream.read())) {
            }
            if (c != '=') {
                throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Expected character", Character.valueOf(c), Character.valueOf('='));
            }
            while (XMLStreamReader.isSpaceChar(c = this.stream.read())) {
            }
            a.value = new CharArrayStringBuffer();
            if (c != '\"' && c != '\'') {
                throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c));
            }
            this.readAttrValue(a.value, c);
            this.event.attributes.add(a);
        }
        this.onStartElement(colonPos);
    }

    private void readProcessingInstruction() throws XMLException, IOException {
        this.event.type = XMLStreamEvents.Event.Type.PROCESSING_INSTRUCTION;
        this.event.attributes = new LinkedList();
        this.event.text = new CharArrayStringBuffer();
        this.readName(this.event.text);
        while (true) {
            char c;
            if (XMLStreamReader.isSpaceChar(c = this.stream.read())) continue;
            if (c == '?') {
                c = this.stream.read();
                if (c == '>') {
                    this.event.isClosed = true;
                    return;
                }
                this.stream.back(c);
                continue;
            }
            if (!XMLStreamReader.isNameStartChar(c)) continue;
            XMLStreamEvents.Attribute a = new XMLStreamEvents.Attribute();
            a.text = new CharArrayStringBuffer();
            int i = this.continueReadName(a.text, c);
            if (i < 0) {
                a.namespacePrefix = new CharArrayStringBuffer();
                a.localName = a.text;
            } else {
                a.namespacePrefix = a.text.substring(0, i);
                a.localName = a.text.substring(i + 1);
            }
            while (XMLStreamReader.isSpaceChar(c = this.stream.read())) {
            }
            if (c != '=') {
                this.event.attributes.add(a);
                this.stream.back(c);
                continue;
            }
            while (XMLStreamReader.isSpaceChar(c = this.stream.read())) {
            }
            a.value = new CharArrayStringBuffer();
            if (c != '\"' && c != '\'') {
                throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c));
            }
            this.readAttrValue(a.value, c);
            this.event.attributes.add(a);
        }
    }

    private void readAttrValue(IString value, char quote) throws XMLException, IOException {
        char c;
        int pos = 0;
        char[] chars = null;
        while ((c = this.stream.read()) != quote) {
            if (c == '&') {
                if (pos > 0) {
                    value.append(new CharArrayString(chars, 0, pos, chars.length));
                    pos = 0;
                }
                value.append(this.readReference());
                continue;
            }
            if (c == '\r') continue;
            if (c == '\n') {
                c = ' ';
            } else if (c == '<') {
                throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected character", Character.valueOf(c)), new LocalizableString("lc.xml.error", "in attribute value", new Serializable[0]));
            }
            if (pos == 0) {
                chars = new char[16];
            }
            chars[pos++] = c;
            if (pos != chars.length) continue;
            value.append(new CharArrayString(chars, 0, chars.length, chars.length));
            pos = 0;
        }
        if (pos > 0) {
            value.append(new CharArrayString(chars, 0, pos, chars.length));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readChars(char c) throws XMLException, IOException {
        this.event.type = XMLStreamEvents.Event.Type.TEXT;
        this.event.text = this.maxTextSize <= 0 ? new CharArrayStringBuffer() : new CappedString(this.maxTextSize);
        IString t = this.event.text;
        try {
            while (true) {
                block11: {
                    if (c == '<') {
                        this.stream.back(c);
                        return;
                    }
                    if (c == '\r') {
                        try {
                            c = this.stream.read();
                        }
                        catch (EOFException e) {
                            t.append(c);
                            return;
                        }
                        if (c == '\n') {
                            t.append(c);
                            break block11;
                        } else {
                            t.append('\r');
                            continue;
                        }
                    }
                    if (c == '&') {
                        CharSequence ref = this.readReference();
                        t.append(ref);
                    } else {
                        t.append(c);
                    }
                }
                c = this.stream.read();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private CharSequence readReference() throws XMLException, IOException {
        char c = this.stream.read();
        if (c == '#') {
            return new CharArrayString(this.readCharRef());
        }
        CharArrayStringBuffer name = new CharArrayStringBuffer();
        this.continueReadName(name, c);
        c = this.stream.read();
        if (c != ';') {
            throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c));
        }
        return XMLStreamReader.resolveEntityRef(name);
    }

    private char[] readCharRef() throws XMLException, IOException {
        NumberEncoding n;
        char c = this.stream.read();
        if (c == 'x') {
            n = new HexadecimalNumber();
        } else {
            n = new DecimalNumber();
            if (!n.addChar(c)) {
                throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c));
            }
        }
        while ((c = this.stream.read()) != ';') {
            if (n.addChar(c)) continue;
            throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c));
        }
        return Character.toChars((int)n.getNumber());
    }

    private static CharSequence resolveEntityRef(CharArrayStringBuffer name) {
        int l = name.length();
        if (l < 2) {
            CharArrayStringBuffer s = new CharArrayStringBuffer();
            s.append('&');
            s.append(name);
            s.append(';');
            return s;
        }
        char c = name.charAt(0);
        if (c == 'a') {
            if (l == 3) {
                if (name.charAt(1) == 'm' && name.charAt(2) == 'p') {
                    return new CharArrayString('&');
                }
            } else if (l == 4 && name.charAt(1) == 'p' && name.charAt(2) == 'o' && name.charAt(3) == 's') {
                return new CharArrayString('\'');
            }
        } else if (c == 'l') {
            if (l == 2 && name.charAt(1) == 't') {
                return new CharArrayString('<');
            }
        } else if (c == 'g') {
            if (l == 2 && name.charAt(1) == 't') {
                return new CharArrayString('>');
            }
        } else if (c == 'q' && l == 4 && name.charAt(1) == 'u' && name.charAt(2) == 'o' && name.charAt(3) == 't') {
            return new CharArrayString('\"');
        }
        CharArrayStringBuffer s = new CharArrayStringBuffer();
        s.append('&');
        s.append(name);
        s.append(';');
        return s;
    }

    private CharArrayStringBuffer readSystemLiteral() throws XMLException, IOException {
        char c = this.stream.read();
        if (c != '\"' && c != '\'') {
            throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Expected character", new Serializable[]{Character.valueOf(c), "simple or double quote"});
        }
        CharArrayStringBuffer literal = new CharArrayStringBuffer();
        char quote = c;
        while ((c = this.stream.read()) != quote) {
            literal.append(c);
        }
        return literal;
    }

    private CharArrayStringBuffer readPublicIDLiteral() throws XMLException, IOException {
        char c;
        char quote = this.stream.read();
        if (quote != '\"' && quote != '\'') {
            throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Expected character", new Serializable[]{Character.valueOf(quote), "\",'"});
        }
        CharArrayStringBuffer literal = new CharArrayStringBuffer();
        while ((c = this.stream.read()) != quote) {
            literal.append(c);
        }
        return literal;
    }

    private void readEndTag() throws XMLException, IOException {
        char c;
        this.event.type = XMLStreamEvents.Event.Type.END_ELEMENT;
        this.event.text = new CharArrayStringBuffer();
        this.readName(this.event.text);
        while ((c = this.stream.read()) != '>') {
            if (XMLStreamReader.isSpaceChar(c)) continue;
            throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c));
        }
        XMLStreamEvents.ElementContext ctx = this.event.context.peekFirst();
        if (ctx == null) {
            throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected end element", new Serializable[]{this.event.text.asString()});
        }
        if (!ctx.text.equals(this.event.text)) {
            throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected end element expected is", new Serializable[]{this.event.text.asString(), ctx.text.asString()});
        }
        this.event.namespacePrefix = ctx.namespacePrefix;
        this.event.localName = ctx.localName;
        this.event.namespaceURI = this.getNamespaceURI(this.event.namespacePrefix);
    }

    private void readIntSubset() throws XMLException, IOException {
        XMLStreamEvents.Event save = this.event.copy();
        while (true) {
            char c;
            try {
                c = this.stream.read();
            }
            catch (EOFException e) {
                throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in internal subset declaration", new Serializable[0]));
            }
            if (XMLStreamReader.isSpaceChar(c)) continue;
            if (c == ']') break;
            if (c == '%') {
                this.readIntSubsetPEReference();
                continue;
            }
            if (c != '<') {
                throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c));
            }
            this.readIntSubsetTag();
        }
        this.event = save;
    }

    private void readIntSubsetPEReference() throws XMLException, IOException {
        CharArrayStringBuffer name = new CharArrayStringBuffer();
        this.readName(name);
        try {
            char c;
            while (XMLStreamReader.isSpaceChar(c = this.stream.read())) {
            }
            if (c != ';') {
                throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c));
            }
        }
        catch (EOFException e) {
            throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in internal subset declaration", new Serializable[0]));
        }
    }

    private void readIntSubsetTag() throws XMLException, IOException {
        block4: {
            try {
                char c = this.stream.read();
                if (c == '!') {
                    this.readIntSubsetTagExclamation();
                    break block4;
                }
                if (c == '?') {
                    this.readProcessingInstruction();
                    break block4;
                }
                throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c));
            }
            catch (EOFException e) {
                throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0]));
            }
        }
    }

    private void readIntSubsetTagExclamation() throws XMLException, IOException {
        char c = this.stream.read();
        if (c == '-') {
            c = this.stream.read();
            if (c == '-') {
                this.readComment();
                return;
            }
            throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Invalid XML", new Serializable[0]);
        }
        if (c == 'E') {
            c = this.stream.read();
            if (c == 'L') {
                if (this.stream.read() == 'E' && this.stream.read() == 'M' && this.stream.read() == 'E' && this.stream.read() == 'N' && this.stream.read() == 'T' && XMLStreamReader.isSpaceChar(this.stream.read())) {
                    this.readElementDeclaration();
                    return;
                }
            } else if (c == 'N' && this.stream.read() == 'T' && this.stream.read() == 'I' && this.stream.read() == 'T' && this.stream.read() == 'Y' && XMLStreamReader.isSpaceChar(this.stream.read())) {
                this.readEntityDeclaration();
                return;
            }
        } else if (c == 'A') {
            if (this.stream.read() == 'T' && this.stream.read() == 'T' && this.stream.read() == 'L' && this.stream.read() == 'I' && this.stream.read() == 'S' && this.stream.read() == 'T' && XMLStreamReader.isSpaceChar(this.stream.read())) {
                this.readAttListDeclaration();
                return;
            }
        } else if (c == 'N' && this.stream.read() == 'O' && this.stream.read() == 'T' && this.stream.read() == 'A' && this.stream.read() == 'T' && this.stream.read() == 'I' && this.stream.read() == 'O' && this.stream.read() == 'N' && XMLStreamReader.isSpaceChar(this.stream.read())) {
            this.readNotationDeclaration();
            return;
        }
        throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c));
    }

    private void readElementDeclaration() throws XMLException, IOException {
        char c = this.stream.read();
        while (XMLStreamReader.isSpaceChar(c)) {
            c = this.stream.read();
        }
        this.stream.back(c);
        CharArrayStringBuffer name = new CharArrayStringBuffer();
        this.readName(name);
        c = this.stream.read();
        while (c != '>') {
            c = this.stream.read();
        }
    }

    private void readEntityDeclaration() throws IOException {
        char c = this.stream.read();
        while (XMLStreamReader.isSpaceChar(c)) {
            c = this.stream.read();
        }
        boolean inString = false;
        while (true) {
            if (inString) {
                if (c == '\"') {
                    inString = false;
                }
                c = this.stream.read();
                continue;
            }
            if (c == '\"') {
                inString = true;
            } else if (c == '>') break;
            c = this.stream.read();
        }
    }

    private void readAttListDeclaration() throws XMLException, IOException {
        this.readElementDeclaration();
    }

    private void readNotationDeclaration() throws XMLException, IOException {
        this.readElementDeclaration();
    }

    private int readName(IString name) throws XMLException, IOException {
        char c = this.stream.read();
        if (!XMLStreamReader.isNameStartChar(c)) {
            throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c));
        }
        return this.continueReadName(name, c);
    }

    private int continueReadName(IString name, char c) throws IOException {
        int colonPos;
        int charsSize = 16;
        char[] chars = new char[charsSize];
        chars[0] = c;
        int pos = 1;
        int n = colonPos = c == ':' ? 0 : -1;
        if (this.maxTextSize <= 0) {
            while (true) {
                c = chars[pos] = this.stream.read();
                if (!XMLStreamReader.isNameChar(chars[pos])) {
                    this.stream.back(chars[pos]);
                    if (pos > 0) {
                        name.append(new CharArrayString(chars, 0, pos, charsSize));
                    }
                    return colonPos;
                }
                if (c == ':' && colonPos == -1) {
                    colonPos = name.length() + pos;
                }
                if (++pos != charsSize) continue;
                name.append(new CharArrayString(chars));
                chars = new char[charsSize *= 2];
                pos = 0;
            }
        }
        int len = 1;
        while (true) {
            if (!XMLStreamReader.isNameChar(c = this.stream.read())) {
                this.stream.back(c);
                if (pos > 0) {
                    name.append(new CharArrayString(chars, 0, pos, charsSize));
                }
                return colonPos;
            }
            if (len >= this.maxTextSize) continue;
            chars[pos] = c;
            if (c == ':' && colonPos == -1) {
                colonPos = name.length() + pos;
            }
            if (++pos != charsSize) continue;
            name.append(new CharArrayString(chars));
            chars = new char[charsSize *= 2];
            pos = 0;
        }
    }

    private void readSpace() throws XMLException, IOException {
        char c = this.stream.read();
        if (!XMLStreamReader.isSpaceChar(c)) {
            throw new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c));
        }
        while (XMLStreamReader.isSpaceChar(c = this.stream.read())) {
        }
        this.stream.back(c);
    }
}

