/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.LinkedList;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.encoding.number.DecimalNumber;
import net.lecousin.framework.encoding.number.HexadecimalNumber;
import net.lecousin.framework.encoding.number.NumberEncoding;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.PreBufferedReadable;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.locale.ILocalizableString;
import net.lecousin.framework.locale.LocalizableString;
import net.lecousin.framework.text.CharArrayString;
import net.lecousin.framework.text.CharArrayStringBuffer;
import net.lecousin.framework.text.IString;
import net.lecousin.framework.xml.XMLException;
import net.lecousin.framework.xml.XMLStreamEvents;
import net.lecousin.framework.xml.XMLStreamEventsAsync;

public class XMLStreamReaderAsync
extends XMLStreamEventsAsync {
    private Charset defaultEncoding;
    private int charactersBuffersSize;
    private int maxBuffers;
    private IO.Readable.Buffered io;
    private State state;
    private int statePos = 0;

    public XMLStreamReaderAsync(IO.Readable io, Charset defaultEncoding, int charactersBuffersSize, int maxBuffers) {
        this.io = io instanceof IO.Readable.Buffered ? (IO.Readable.Buffered)io : new PreBufferedReadable(io, 1024, io.getPriority(), charactersBuffersSize, (byte)(io.getPriority() - 1), maxBuffers);
        this.defaultEncoding = defaultEncoding;
        this.charactersBuffersSize = charactersBuffersSize;
        this.maxBuffers = maxBuffers;
    }

    public XMLStreamReaderAsync(IO.Readable io, int charactersBuffersSize, int maxBuffers) {
        this(io, null, charactersBuffersSize, maxBuffers);
    }

    @Override
    public IAsync<Exception> start() {
        Async<Exception> sp = new Async<Exception>();
        this.io.canStartReading().thenStart(new Task.Cpu.FromRunnable(() -> {
            try {
                XMLStreamEvents.Starter start = new XMLStreamEvents.Starter(this.io, this.defaultEncoding, this.charactersBuffersSize, this.maxBuffers, false);
                this.stream = start.start();
                this.next().onDone(sp);
            }
            catch (Exception e) {
                sp.error(e);
            }
        }, "Start parsing XML", this.io.getPriority()), true);
        return sp;
    }

    @Override
    public Async<Exception> next() {
        Async<Exception> sp = new Async<Exception>();
        this.reset();
        this.state = State.START;
        this.nextChar(sp);
        return sp;
    }

    @Override
    public byte getPriority() {
        return this.io.getPriority();
    }

    public IAsync<Exception> startRootElement() {
        IAsync<Exception> start = this.start();
        if (start.isDone()) {
            if (start.hasError()) {
                return start;
            }
            if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
                return start;
            }
            return this.nextStartElement();
        }
        Async<Exception> sp = new Async<Exception>();
        start.thenStart(new XMLStreamEventsAsync.ParsingTask(this, () -> {
            if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
                sp.unblock();
            } else {
                this.nextStartElement().onDone(sp);
            }
        }), sp);
        return sp;
    }

    private void nextChar(Async<Exception> sp) {
        boolean continu;
        do {
            int c;
            try {
                c = this.stream.readAsync();
            }
            catch (IOException e) {
                sp.error(e);
                return;
            }
            if (c == -2) {
                this.stream.canStartReading().thenStart(new XMLStreamEventsAsync.ParsingTask(this, () -> this.nextChar(sp)), true);
                return;
            }
            switch (this.state) {
                case START: {
                    if (c == -1) {
                        sp.error(new EOFException("End of file reached, context = " + this.event.context));
                        return;
                    }
                    if (c == 60) {
                        this.state = State.TAG;
                        continu = true;
                        break;
                    }
                    this.state = State.CHARS;
                    this.event.type = XMLStreamEvents.Event.Type.TEXT;
                    this.event.text = new CharArrayStringBuffer();
                    continu = this.readChars(c, sp);
                    break;
                }
                case TAG: {
                    continu = this.readTag(c, sp);
                    break;
                }
                case TAG_EXCLAMATION: {
                    continu = this.readTagExclamation(c, sp);
                    break;
                }
                case PROCESSING_INSTRUCTION: {
                    continu = this.readProcessingInstruction(c, sp);
                    break;
                }
                case PROCESSING_INSTRUCTION_CLOSED: {
                    continu = this.readProcessingInstructionClosed(c, sp);
                    break;
                }
                case END_ELEMENT_NAME: {
                    continu = this.readEndElementName(c, sp);
                    break;
                }
                case START_ELEMENT_NAME: {
                    continu = this.readStartElementName(c, sp);
                    break;
                }
                case START_ELEMENT_SPACE: {
                    continu = this.readStartElementSpace(c, sp);
                    break;
                }
                case START_ELEMENT_CLOSED: {
                    continu = this.readStartElementClosed(c, sp);
                    break;
                }
                case ATTRIBUTE_NAME: {
                    continu = this.readAttributeName(c, sp);
                    break;
                }
                case ATTRIBUTE_NAME_SPACE: {
                    continu = this.readAttributeNameSpace(c, sp);
                    break;
                }
                case ATTRIBUTE_VALUE_SPACE: {
                    continu = this.readAttributeValueSpace(c, sp);
                    break;
                }
                case ATTRIBUTE_VALUE: {
                    continu = this.readAttributeValue(c, sp);
                    break;
                }
                case COMMENT: {
                    continu = this.readComment(c, sp);
                    break;
                }
                case CDATA: {
                    continu = this.readCData(c, sp);
                    break;
                }
                case DOCTYPE: {
                    continu = this.readDocType(c, sp);
                    break;
                }
                case DOCTYPE_NAME: {
                    continu = this.readDocTypeName(c, sp);
                    break;
                }
                case DOCTYPE_SPACE: {
                    continu = this.readDocTypeSpace(c, sp);
                    break;
                }
                case DOCTYPE_PUBLIC_NAME: {
                    continu = this.readDocTypePublicName(c, sp);
                    break;
                }
                case DOCTYPE_PUBLIC_SPACE: {
                    continu = this.readDocTypePublicSpace(c, sp);
                    break;
                }
                case DOCTYPE_PUBLIC_ID: {
                    continu = this.readDocTypePublicId(c, sp);
                    break;
                }
                case DOCTYPE_SYSTEM_NAME: {
                    continu = this.readDocTypeSystemName(c, sp);
                    break;
                }
                case DOCTYPE_SYSTEM_SPACE: {
                    continu = this.readDocTypeSystemSpace(c, sp);
                    break;
                }
                case DOCTYPE_SYSTEM_VALUE: {
                    continu = this.readDocTypeSystemValue(c, sp);
                    break;
                }
                case DOCTYPE_INTERNAL_SUBSET: {
                    continu = this.readInternalSubset(c, sp);
                    break;
                }
                case DOCTYPE_INTERNAL_SUBSET_PEREFERENCE: {
                    continu = this.readInternalSubsetPEReference(c, sp);
                    break;
                }
                case DOCTYPE_INTERNAL_SUBSET_TAG: {
                    continu = this.readInternalSubsetTag(c, sp);
                    break;
                }
                case CHARS: {
                    continu = this.readChars(c, sp);
                    break;
                }
                default: {
                    sp.error(new Exception("Unexpected state " + (Object)((Object)this.state)));
                    return;
                }
            }
        } while (continu);
    }

    private boolean readTag(int c, Async<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        if (c == 33) {
            this.state = State.TAG_EXCLAMATION;
            this.event.text = new CharArrayStringBuffer();
            return true;
        }
        if (c == 63) {
            this.state = State.PROCESSING_INSTRUCTION;
            this.event.text = new CharArrayStringBuffer();
            this.event.attributes = new LinkedList();
            this.event.type = XMLStreamEvents.Event.Type.PROCESSING_INSTRUCTION;
            return true;
        }
        if (c == 47) {
            this.state = State.END_ELEMENT_NAME;
            this.event.type = XMLStreamEvents.Event.Type.END_ELEMENT;
            this.event.text = new CharArrayStringBuffer();
            return true;
        }
        if (XMLStreamEvents.isNameStartChar((char)c)) {
            this.state = State.START_ELEMENT_NAME;
            this.event.type = XMLStreamEvents.Event.Type.START_ELEMENT;
            this.event.attributes = new LinkedList();
            this.event.text = new CharArrayStringBuffer();
            this.event.text.append((char)c);
            return true;
        }
        sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf((char)c)));
        return false;
    }

    private boolean readTagExclamation(int c, Async<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        if (this.event.text.isEmpty()) {
            if (c == 45) {
                this.event.text.append((char)c);
                return true;
            }
            if (c == 91) {
                this.event.text.append((char)c);
                return true;
            }
            if (c == 68) {
                this.event.text.append((char)c);
                return true;
            }
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Invalid XML", new Serializable[0]));
            return false;
        }
        char c1 = this.event.text.charAt(0);
        if (c1 == '-') {
            if (c == 45) {
                this.state = State.COMMENT;
                this.event.type = XMLStreamEvents.Event.Type.COMMENT;
                this.event.text = new CharArrayStringBuffer();
                return true;
            }
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Invalid XML", new Serializable[0]));
            return false;
        }
        if (c1 == '[') {
            this.event.text.append((char)c);
            if (this.event.text.length() < 7) {
                if (this.event.text.isStartOf("[CDATA[")) {
                    return true;
                }
                sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Invalid XML", new Serializable[0]));
                return false;
            }
            if (!this.event.text.equals("[CDATA[")) {
                sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Invalid XML", new Serializable[0]));
                return false;
            }
            this.state = State.CDATA;
            this.event.type = XMLStreamEvents.Event.Type.CDATA;
            this.event.text = new CharArrayStringBuffer();
            return true;
        }
        if (this.event.text.length() < 7) {
            this.event.text.append((char)c);
            if (this.event.text.isStartOf("DOCTYPE")) {
                return true;
            }
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Invalid XML", new Serializable[0]));
            return false;
        }
        if (!XMLStreamReaderAsync.isSpaceChar((char)c)) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Invalid XML", new Serializable[0]));
            return false;
        }
        this.state = State.DOCTYPE;
        this.event.type = XMLStreamEvents.Event.Type.DOCTYPE;
        this.event.text = new CharArrayStringBuffer();
        return true;
    }

    private boolean readDocType(int c, Async<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        if (XMLStreamReaderAsync.isSpaceChar((char)c)) {
            return true;
        }
        if (!XMLStreamEvents.isNameStartChar((char)c)) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf((char)c)));
            return false;
        }
        this.event.text.append((char)c);
        this.state = State.DOCTYPE_NAME;
        return true;
    }

    private boolean readDocTypeName(int c, Async<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        if (XMLStreamEvents.isNameChar((char)c)) {
            this.event.text.append((char)c);
            return true;
        }
        if (XMLStreamReaderAsync.isSpaceChar((char)c)) {
            this.state = State.DOCTYPE_SPACE;
            return true;
        }
        if (c == 91) {
            this.state = State.DOCTYPE_INTERNAL_SUBSET;
            return true;
        }
        if (c == 62) {
            sp.unblock();
            return false;
        }
        sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf((char)c)));
        return false;
    }

    private boolean readDocTypeSpace(int c, Async<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        if (XMLStreamReaderAsync.isSpaceChar((char)c)) {
            return true;
        }
        if (c == 91) {
            this.state = State.DOCTYPE_INTERNAL_SUBSET;
            return true;
        }
        if (c == 62) {
            sp.unblock();
            return false;
        }
        if (c == 80) {
            this.state = State.DOCTYPE_PUBLIC_NAME;
            this.statePos = 1;
            return true;
        }
        if (c == 83) {
            this.state = State.DOCTYPE_SYSTEM_NAME;
            this.statePos = 1;
            return true;
        }
        sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf((char)c)));
        return false;
    }

    private boolean readDocTypePublicName(int c, Async<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        if (this.statePos < 6) {
            if (c != "PUBLIC".charAt(this.statePos)) {
                sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf((char)c)));
                return false;
            }
            ++this.statePos;
            return true;
        }
        if (this.event.publicId == null) {
            this.event.publicId = new CharArrayStringBuffer();
        }
        if (this.event.publicId.length() > 0) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, (Object)this.event.context, (ILocalizableString)new LocalizableString("lc.xml.error", "Invalid XML", new Serializable[0])));
            return false;
        }
        if (!XMLStreamReaderAsync.isSpaceChar((char)c)) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf((char)c)));
            return false;
        }
        this.state = State.DOCTYPE_PUBLIC_SPACE;
        return true;
    }

    private boolean readDocTypePublicSpace(int c, Async<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        if (XMLStreamReaderAsync.isSpaceChar((char)c)) {
            return true;
        }
        if (c != 34 && c != 39) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf((char)c)));
            return false;
        }
        this.state = State.DOCTYPE_PUBLIC_ID;
        this.statePos = c;
        return true;
    }

    private boolean readDocTypePublicId(int c, Async<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        if (c == this.statePos) {
            this.state = State.DOCTYPE_SYSTEM_SPACE;
            return true;
        }
        if (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 32 || c == 13 || c == 10 || c == 45 || c == 39 || c == 40 || c == 41 || c == 43 || c == 44 || c == 46 || c == 47 || c == 58 || c == 61 || c == 63 || c == 59 || c == 33 || c == 42 || c == 35 || c == 64 || c == 36 || c == 95 || c == 37) {
            this.event.publicId.append((char)c);
            return true;
        }
        sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf((char)c)));
        return false;
    }

    private boolean readDocTypeSystemName(int c, Async<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        if (this.statePos < 6) {
            if (c != "SYSTEM".charAt(this.statePos)) {
                sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf((char)c)));
                return false;
            }
            ++this.statePos;
            return true;
        }
        if (this.event.system == null) {
            this.event.system = new CharArrayStringBuffer();
        }
        if (this.event.system.length() > 0) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, (Object)this.event.context, (ILocalizableString)new LocalizableString("lc.xml.error", "Invalid XML", new Serializable[0])));
            return false;
        }
        if (!XMLStreamReaderAsync.isSpaceChar((char)c)) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf((char)c)));
            return false;
        }
        this.state = State.DOCTYPE_SYSTEM_SPACE;
        return true;
    }

    private boolean readDocTypeSystemSpace(int c, Async<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        if (XMLStreamReaderAsync.isSpaceChar((char)c)) {
            return true;
        }
        if (c != 34 && c != 39) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf((char)c)));
            return false;
        }
        this.state = State.DOCTYPE_SYSTEM_VALUE;
        this.statePos = c;
        return true;
    }

    private boolean readDocTypeSystemValue(int c, Async<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        if (c == this.statePos) {
            this.state = State.DOCTYPE_SPACE;
            return true;
        }
        if (this.event.system == null) {
            this.event.system = new CharArrayStringBuffer();
        }
        this.event.system.append((char)c);
        return true;
    }

    private boolean readComment(int c, Async<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "inside comment", new Serializable[0])));
            return false;
        }
        if (this.maxTextSize > 0 && this.event.text.length() >= this.maxTextSize) {
            if (this.event.text.charAt(this.event.text.length() - 1) == '-') {
                if (this.event.text.charAt(this.event.text.length() - 2) == '-') {
                    if (c == 62) {
                        this.event.text.removeEndChars(2);
                        sp.unblock();
                        return false;
                    }
                    this.event.text.setCharAt(this.event.text.length() - 1, (char)c);
                    return true;
                }
                if (c != 45) {
                    this.event.text.setCharAt(this.event.text.length() - 1, (char)c);
                    return true;
                }
                this.event.text.setCharAt(this.event.text.length() - 2, (char)c);
                return true;
            }
            this.event.text.setCharAt(this.event.text.length() - 1, (char)c);
            return true;
        }
        this.event.text.append((char)c);
        if (this.event.text.endsWith("-->")) {
            this.event.text.removeEndChars(3);
            sp.unblock();
            return false;
        }
        return true;
    }

    private boolean readCData(int c, Async<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "inside CDATA", new Serializable[0])));
            return false;
        }
        if (this.maxCDataSize > 0 && this.event.text.length() >= this.maxCDataSize + 2) {
            if (this.event.text.charAt(this.event.text.length() - 1) == ']') {
                if (this.event.text.charAt(this.event.text.length() - 2) == ']') {
                    if (c == 62) {
                        this.event.text.removeEndChars(2);
                        sp.unblock();
                        return false;
                    }
                    this.event.text.setCharAt(this.event.text.length() - 1, (char)c);
                    return true;
                }
                if (c != 93) {
                    this.event.text.setCharAt(this.event.text.length() - 1, (char)c);
                    return true;
                }
                this.event.text.setCharAt(this.event.text.length() - 2, (char)c);
                return true;
            }
            this.event.text.setCharAt(this.event.text.length() - 1, (char)c);
            return true;
        }
        this.event.text.append((char)c);
        if (this.event.text.endsWith("]]>")) {
            this.event.text.removeEndChars(3);
            sp.unblock();
            return false;
        }
        return true;
    }

    private boolean readStartElementName(int i, Async<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        char c = (char)i;
        if (XMLStreamEvents.isNameChar(c)) {
            if (this.maxTextSize <= 0 || this.event.text.length() < this.maxTextSize) {
                this.event.text.append(c);
            }
            return true;
        }
        if (XMLStreamReaderAsync.isSpaceChar(c)) {
            this.state = State.START_ELEMENT_SPACE;
            return true;
        }
        if (c == '>') {
            this.onStartElement(this.event.text.indexOf(':'));
            sp.unblock();
            return false;
        }
        if (c == '/') {
            this.state = State.START_ELEMENT_CLOSED;
            return true;
        }
        sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c)));
        return false;
    }

    private boolean readStartElementClosed(int c, Async<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        if (c != 62) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf((char)c)));
            return false;
        }
        this.event.isClosed = true;
        this.onStartElement(this.event.text.indexOf(':'));
        sp.unblock();
        return false;
    }

    private boolean readStartElementSpace(int i, Async<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        char c = (char)i;
        if (XMLStreamReaderAsync.isSpaceChar(c)) {
            return true;
        }
        if (XMLStreamEvents.isNameStartChar(c)) {
            XMLStreamEvents.Attribute a = new XMLStreamEvents.Attribute();
            a.text = new CharArrayStringBuffer();
            a.text.append(c);
            this.event.attributes.add(a);
            this.state = State.ATTRIBUTE_NAME;
            return true;
        }
        if (!XMLStreamEvents.Event.Type.PROCESSING_INSTRUCTION.equals((Object)this.event.type)) {
            if (c == '>') {
                this.onStartElement(this.event.text.indexOf(':'));
                sp.unblock();
                return false;
            }
            if (c == '/') {
                this.state = State.START_ELEMENT_CLOSED;
                return true;
            }
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c)));
            return false;
        }
        if (c == '?') {
            this.state = State.PROCESSING_INSTRUCTION_CLOSED;
            return true;
        }
        return true;
    }

    private boolean readAttributeName(int i, Async<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        char c = (char)i;
        XMLStreamEvents.Attribute a = this.event.attributes.getLast();
        if (XMLStreamEvents.isNameChar(c)) {
            if (this.maxTextSize <= 0 || a.text.length() < this.maxTextSize) {
                a.text.append(c);
            }
            return true;
        }
        i = a.text.indexOf(':');
        if (i < 0) {
            a.namespacePrefix = new CharArrayStringBuffer();
            a.localName = a.text;
        } else {
            a.namespacePrefix = a.text.substring(0, i);
            a.localName = a.text.substring(i + 1);
        }
        this.state = State.ATTRIBUTE_NAME_SPACE;
        return this.readAttributeNameSpace(c, sp);
    }

    private boolean readAttributeNameSpace(int i, Async<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        char c = (char)i;
        if (XMLStreamReaderAsync.isSpaceChar(c)) {
            return true;
        }
        if (c == '=') {
            this.state = State.ATTRIBUTE_VALUE_SPACE;
            return true;
        }
        this.state = State.START_ELEMENT_SPACE;
        this.stream.back(c);
        return true;
    }

    private boolean readAttributeValueSpace(int i, Async<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        char c = (char)i;
        if (XMLStreamReaderAsync.isSpaceChar(c)) {
            return true;
        }
        if (c == '\"') {
            this.state = State.ATTRIBUTE_VALUE;
            this.statePos = 1;
            XMLStreamEvents.Attribute a = this.event.attributes.getLast();
            a.value = new CharArrayStringBuffer();
            return true;
        }
        if (c == '\'') {
            this.state = State.ATTRIBUTE_VALUE;
            this.statePos = 2;
            XMLStreamEvents.Attribute a = this.event.attributes.getLast();
            a.value = new CharArrayStringBuffer();
            return true;
        }
        sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c)));
        return false;
    }

    private boolean readAttributeValue(int i, Async<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        char c = (char)i;
        XMLStreamEvents.Attribute a = this.event.attributes.getLast();
        if (c == '\"' && this.statePos == 1) {
            XMLStreamReaderAsync.resolveReferences(a.value);
            this.state = State.START_ELEMENT_SPACE;
            return true;
        }
        if (c == '\'' && this.statePos == 2) {
            XMLStreamReaderAsync.resolveReferences(a.value);
            this.state = State.START_ELEMENT_SPACE;
            return true;
        }
        if (c == '<') {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected character", Character.valueOf(c)), new LocalizableString("lc.xml.error", "in attribute value", new Serializable[0])));
            return false;
        }
        if (c == '\n') {
            if (this.maxTextSize <= 0 || a.value.length() < this.maxTextSize) {
                a.value.append(' ');
            }
        } else {
            if (c == '\r') {
                return true;
            }
            if (this.maxTextSize <= 0 || a.value.length() < this.maxTextSize) {
                a.value.append(c);
            }
        }
        return true;
    }

    private boolean readProcessingInstruction(int i, Async<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        char c = (char)i;
        if (this.event.text.isEmpty()) {
            if (!XMLStreamEvents.isNameStartChar(c)) {
                sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c)));
                return false;
            }
            this.event.text.append(c);
            return true;
        }
        if (XMLStreamEvents.isNameChar(c)) {
            if (this.maxTextSize <= 0 || this.event.text.length() < this.maxTextSize) {
                this.event.text.append(c);
            }
            return true;
        }
        this.state = State.START_ELEMENT_SPACE;
        return this.readStartElementSpace(i, sp);
    }

    private boolean readProcessingInstructionClosed(int c, Async<Exception> sp) {
        if (c == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        if (c != 62) {
            this.stream.back((char)c);
            this.state = State.START_ELEMENT_SPACE;
            return true;
        }
        sp.unblock();
        return false;
    }

    private boolean readChars(int i, Async<Exception> sp) {
        if (i == -1) {
            this.event.text.replace((CharSequence)"\r\n", (CharSequence)"\n");
            XMLStreamReaderAsync.resolveReferences(this.event.text);
            sp.unblock();
            return false;
        }
        char c = (char)i;
        if (c == '<') {
            this.stream.back(c);
            this.event.text.replace((CharSequence)"\r\n", (CharSequence)"\n");
            XMLStreamReaderAsync.resolveReferences(this.event.text);
            sp.unblock();
            return false;
        }
        this.event.text.append(c);
        if (this.maxTextSize > 0 && this.event.text.length() >= this.maxTextSize) {
            this.event.text.replace((CharSequence)"\r\n", (CharSequence)"\n");
            XMLStreamReaderAsync.resolveReferences(this.event.text);
            if (this.event.text.length() < this.maxTextSize) {
                return true;
            }
            sp.unblock();
            return false;
        }
        return true;
    }

    private boolean readEndElementName(int i, Async<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in XML document", new Serializable[0])));
            return false;
        }
        char c = (char)i;
        if (this.event.text.isEmpty()) {
            if (!XMLStreamEvents.isNameStartChar(c)) {
                sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c)));
                return false;
            }
            this.event.text.append(c);
            this.statePos = 0;
            return true;
        }
        if (c == '>') {
            XMLStreamEvents.ElementContext ctx = this.event.context.peekFirst();
            if (ctx == null) {
                sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected end element", new Serializable[]{this.event.text.asString()}));
                return false;
            }
            if (!ctx.text.equals(this.event.text)) {
                sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected end element expected is", new Serializable[]{this.event.text.asString(), ctx.text.asString()}));
                return false;
            }
            i = this.event.text.indexOf(':');
            if (i < 0) {
                this.event.namespacePrefix = new CharArrayStringBuffer();
                this.event.localName = this.event.text;
            } else {
                this.event.namespacePrefix = this.event.text.substring(0, i);
                this.event.localName = this.event.text.substring(i + 1);
            }
            this.event.namespaceURI = this.getNamespaceURI(this.event.namespacePrefix);
            sp.unblock();
            return false;
        }
        if (XMLStreamReaderAsync.isSpaceChar(c)) {
            this.statePos = 1;
            return true;
        }
        if (this.statePos != 0 || !XMLStreamEvents.isNameChar(c)) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c)));
            return false;
        }
        if (this.maxTextSize <= 0 || this.event.text.length() < this.maxTextSize) {
            this.event.text.append(c);
        }
        return true;
    }

    private static void resolveReferences(IString s) {
        int j;
        int i;
        int pos = 0;
        while ((i = s.indexOf('&', pos)) != -1 && (j = s.indexOf(';', i + 1)) >= 0) {
            int c;
            if (s.charAt(i + 1) == '#') {
                NumberEncoding n;
                pos = i;
                if (s.charAt(i + 2) == 'x') {
                    n = new HexadecimalNumber();
                    i += 3;
                } else {
                    n = new DecimalNumber();
                    i += 2;
                }
                while (i < j) {
                    n.addChar(s.charAt(i++));
                }
                char[] chars = Character.toChars((int)n.getNumber());
                s.replace(pos, j, new CharArrayString(chars));
                pos += chars.length;
                continue;
            }
            IString name = s.substring(i + 1, j);
            if (name.equals("amp")) {
                c = 38;
            } else if (name.equals("apos")) {
                c = 39;
            } else if (name.equals("lt")) {
                c = 60;
            } else if (name.equals("gt")) {
                c = 62;
            } else if (name.equals("quot")) {
                c = 34;
            } else {
                pos = i + 1;
                continue;
            }
            s.replace(i, j, new CharArrayString((char)c));
            pos = i + 1;
        }
    }

    private boolean readInternalSubset(int i, Async<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in internal subset declaration", new Serializable[0])));
            return false;
        }
        char c = (char)i;
        if (XMLStreamReaderAsync.isSpaceChar(c)) {
            return true;
        }
        if (c == ']') {
            this.state = State.DOCTYPE_SPACE;
            return true;
        }
        if (c == '%') {
            this.state = State.DOCTYPE_INTERNAL_SUBSET_PEREFERENCE;
            this.statePos = 0;
            return true;
        }
        if (c != '<') {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c)));
            return false;
        }
        this.state = State.DOCTYPE_INTERNAL_SUBSET_TAG;
        this.statePos = 0;
        return true;
    }

    private boolean readInternalSubsetPEReference(int i, Async<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in internal subset declaration", new Serializable[0])));
            return false;
        }
        char c = (char)i;
        if (this.statePos == 0) {
            if (!XMLStreamEvents.isNameStartChar(c)) {
                sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c)));
                return false;
            }
            this.statePos = 1;
            return true;
        }
        if (this.statePos == 1) {
            if (XMLStreamEvents.isNameChar(c)) {
                return true;
            }
            if (XMLStreamReaderAsync.isSpaceChar(c)) {
                this.statePos = 2;
                return true;
            }
            if (c == ';') {
                this.state = State.DOCTYPE_INTERNAL_SUBSET;
                return true;
            }
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c)));
            return false;
        }
        if (XMLStreamReaderAsync.isSpaceChar(c)) {
            return true;
        }
        if (c == ';') {
            this.state = State.DOCTYPE_INTERNAL_SUBSET;
            return true;
        }
        sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c)));
        return false;
    }

    private boolean readInternalSubsetTag(int i, Async<Exception> sp) {
        if (i == -1) {
            sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, new LocalizableString("lc.xml.error", "Unexpected end", new Serializable[0]), new LocalizableString("lc.xml.error", "in internal subset declaration", new Serializable[0])));
            return false;
        }
        char c = (char)i;
        switch (this.statePos) {
            case 0: {
                if (c == '!') {
                    this.statePos = 1;
                    return true;
                }
                if (c == '?') {
                    this.statePos = 10;
                    return true;
                }
                sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c)));
                return false;
            }
            case 1: {
                if (c == '-') {
                    this.statePos = 2;
                    return true;
                }
                this.statePos = 10;
                return true;
            }
            case 2: {
                this.statePos = c == '-' ? 3 : 10;
                return true;
            }
            case 3: {
                if (c == '-') {
                    this.statePos = 4;
                }
                return true;
            }
            case 4: {
                this.statePos = c == '-' ? 5 : 3;
                return true;
            }
            case 5: {
                if (c == '>') {
                    this.state = State.DOCTYPE_INTERNAL_SUBSET;
                    return true;
                }
                if (c != '-') {
                    this.statePos = 3;
                }
                return true;
            }
            case 10: {
                if (c == '>') {
                    this.state = State.DOCTYPE_INTERNAL_SUBSET;
                    return true;
                }
                if (c == '\"') {
                    this.statePos = 11;
                }
                return true;
            }
            case 11: {
                if (c == '\"') {
                    this.statePos = 10;
                }
                return true;
            }
        }
        sp.error(new XMLException((ICharacterStream.Readable)this.stream, this.event.context, "Unexpected character", Character.valueOf(c)));
        return false;
    }

    private static enum State {
        START,
        TAG,
        TAG_EXCLAMATION,
        PROCESSING_INSTRUCTION,
        PROCESSING_INSTRUCTION_CLOSED,
        END_ELEMENT_NAME,
        START_ELEMENT_NAME,
        START_ELEMENT_SPACE,
        START_ELEMENT_CLOSED,
        ATTRIBUTE_NAME,
        ATTRIBUTE_NAME_SPACE,
        ATTRIBUTE_VALUE_SPACE,
        ATTRIBUTE_VALUE,
        COMMENT,
        CDATA,
        DOCTYPE,
        DOCTYPE_NAME,
        DOCTYPE_SPACE,
        DOCTYPE_PUBLIC_NAME,
        DOCTYPE_PUBLIC_SPACE,
        DOCTYPE_PUBLIC_ID,
        DOCTYPE_SYSTEM_NAME,
        DOCTYPE_SYSTEM_SPACE,
        DOCTYPE_SYSTEM_VALUE,
        DOCTYPE_INTERNAL_SUBSET,
        DOCTYPE_INTERNAL_SUBSET_PEREFERENCE,
        DOCTYPE_INTERNAL_SUBSET_TAG,
        CHARS;

    }
}

