/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.BufferedWritableCharacterStream;
import net.lecousin.framework.io.text.CharacterStreamWritePool;
import net.lecousin.framework.io.text.ICharacterStream;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLWriter {
    private ICharacterStream.Writable.Buffered output;
    private CharacterStreamWritePool writer;
    private boolean includeXMLDeclaration;
    private boolean pretty;
    private int indent = 0;
    private LinkedList<Context> context = new LinkedList();
    private short lastNodeType = 0;
    private static final char[] XML_DECLARATION_START = new char[]{'<', '?', 'x', 'm', 'l', ' ', 'v', 'e', 'r', 's', 'i', 'o', 'n', '=', '\"', '1', '.', '1', '\"', ' ', 'e', 'n', 'c', 'o', 'd', 'i', 'n', 'g', '=', '\"'};
    private static final char[] XML_DECLARATION_END = new char[]{'\"', '?', '>', '\n'};
    private static final char[] XMLNS = new char[]{' ', 'x', 'm', 'l', 'n', 's'};
    private static final char[] ATTRIBUTE_EQUALS = new char[]{'=', '\"'};
    private static final char[] CLOSE_EMPTY_TAG = new char[]{'/', '>'};
    private static final char[] START_CLOSE = new char[]{'<', '/'};
    private static final char[] START_CDATA = new char[]{'<', '!', '[', 'C', 'D', 'A', 'T', 'A', '['};
    private static final char[] END_CDATA = new char[]{']', ']', '>'};
    private static final char[] START_COMMENT = new char[]{'<', '!', '-', '-'};
    private static final char[] END_COMMENT = new char[]{'-', '-', '>'};
    private static final char[] PRETTY_END_TAG = new char[]{'>', '\n'};
    private static final String ALREADY_CLOSED_ERROR_MESSAGE = "XML document already closed";
    private static final String DOM_TASK_DESCRIPTION = "Write DOM";

    public XMLWriter(IO.Writable.Buffered output, Charset encoding, boolean includeXMLDeclaration, boolean pretty) {
        this(new BufferedWritableCharacterStream((IO.Writable)output, encoding != null ? encoding : StandardCharsets.UTF_8, 4096), includeXMLDeclaration, pretty);
    }

    public XMLWriter(ICharacterStream.Writable.Buffered output, boolean includeXMLDeclaration, boolean pretty) {
        this.output = output;
        this.writer = new CharacterStreamWritePool(output);
        this.includeXMLDeclaration = includeXMLDeclaration;
        this.pretty = pretty;
    }

    private String getNamespace(String uri) {
        for (Context ctx : this.context) {
            String ns;
            if (ctx.namespaces == null || (ns = (String)ctx.namespaces.get(uri)) == null) continue;
            return ns;
        }
        return null;
    }

    public static String escape(CharSequence s) {
        StringBuilder str = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '&') {
                str.append("&amp;");
                continue;
            }
            if (c == '\"') {
                str.append("&quot;");
                continue;
            }
            if (c == '\'') {
                str.append("&apos;");
                continue;
            }
            if (c == '>') {
                str.append("&gt;");
                continue;
            }
            if (c == '<') {
                str.append("&lt;");
                continue;
            }
            if (c < ' ') {
                str.append("&#").append((int)c).append(';');
                continue;
            }
            str.append(c);
        }
        return str.toString();
    }

    public IAsync<IOException> start(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces) {
        String ns;
        if (this.includeXMLDeclaration) {
            this.writer.write(XML_DECLARATION_START);
            this.writer.write(this.output.getEncoding().name());
            this.writer.write(XML_DECLARATION_END);
        }
        this.writer.write('<');
        if (rootNamespaceURI != null && (ns = namespaces.get(rootNamespaceURI)) != null && ns.length() > 0) {
            this.writer.write(ns);
            this.writer.write(':');
        }
        IAsync<IOException> result = this.writer.write(rootLocalName);
        if (namespaces != null && !namespaces.isEmpty()) {
            for (Map.Entry<String, String> ns2 : namespaces.entrySet()) {
                this.writer.write(XMLNS);
                if (ns2.getValue().length() > 0) {
                    this.writer.write(':');
                    this.writer.write(ns2.getValue());
                }
                this.writer.write(ATTRIBUTE_EQUALS);
                this.writer.write(XMLWriter.escape(ns2.getKey()));
                result = this.writer.write('\"');
            }
        }
        Context ctx = new Context();
        ctx.namespaces = new HashMap();
        if (namespaces != null) {
            ctx.namespaces.putAll(namespaces);
        }
        ctx.namespaceURI = rootNamespaceURI;
        ctx.localName = rootLocalName;
        ctx.open = true;
        this.context.addFirst(ctx);
        return result;
    }

    public IAsync<IOException> end() {
        while (!this.context.isEmpty()) {
            this.closeElement();
        }
        IAsync<IOException> write = this.writer.flush();
        if (!write.isDone()) {
            Async<IOException> sp = new Async<IOException>();
            write.onDone(() -> this.output.flush().onDone(sp), sp);
            return sp;
        }
        if (write.hasError()) {
            return write;
        }
        return this.output.flush();
    }

    protected void indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.writer.write('\t');
        }
    }

    public IAsync<IOException> addAttribute(CharSequence name, CharSequence value) {
        Context ctx = this.context.peekFirst();
        if (ctx == null) {
            return new Async<IOException>(new IOException(ALREADY_CLOSED_ERROR_MESSAGE));
        }
        if (!ctx.open) {
            return new Async<IOException>(new IOException("Cannot add attribute to XML element when the opening tag is closed"));
        }
        this.writer.write(' ');
        this.writer.write(name);
        this.writer.write(ATTRIBUTE_EQUALS);
        this.writer.write(XMLWriter.escape(value));
        return this.writer.write('\"');
    }

    public IAsync<IOException> endOfAttributes() {
        Context ctx = this.context.peekFirst();
        if (ctx == null) {
            return new Async<IOException>(new IOException(ALREADY_CLOSED_ERROR_MESSAGE));
        }
        if (!ctx.open) {
            return new Async<IOException>(new IOException("Opening tag already closed"));
        }
        return this.endOfAttributes(ctx);
    }

    protected IAsync<IOException> endOfAttributes(Context ctx) {
        ctx.open = false;
        if (!this.pretty) {
            return this.writer.write('>');
        }
        ++this.indent;
        return this.writer.write(PRETTY_END_TAG);
    }

    public IAsync<IOException> openElement(String namespaceURI, String localName, Map<String, String> namespaces) {
        if (this.lastNodeType == 3) {
            this.writer.write('\n');
        }
        this.lastNodeType = 1;
        Context ctx = this.context.peekFirst();
        if (ctx == null) {
            return new Async<IOException>(new IOException(ALREADY_CLOSED_ERROR_MESSAGE));
        }
        if (ctx.open) {
            this.endOfAttributes(ctx);
        }
        ctx = new Context();
        ctx.namespaces = namespaces != null && !namespaces.isEmpty() ? new HashMap<String, String>(namespaces) : null;
        ctx.namespaceURI = namespaceURI;
        ctx.localName = localName;
        ctx.open = true;
        this.context.addFirst(ctx);
        String ns = this.getNamespace(namespaceURI);
        this.indent();
        this.writer.write('<');
        if (ns != null && ns.length() > 0) {
            this.writer.write(ns);
            this.writer.write(':');
        }
        if (namespaces == null || namespaces.isEmpty()) {
            return this.writer.write(localName);
        }
        this.writer.write(localName);
        Iterator<Map.Entry<String, String>> it = namespaces.entrySet().iterator();
        while (true) {
            Map.Entry<String, String> e = it.next();
            String name = "xmlns";
            if (!e.getValue().isEmpty()) {
                name = name + ':' + e.getValue();
            }
            if (!it.hasNext()) {
                return this.addAttribute(name, e.getKey());
            }
            this.addAttribute(name, e.getKey());
        }
    }

    public IAsync<IOException> closeElement() {
        if (this.lastNodeType == 3) {
            this.writer.write('\n');
        }
        this.lastNodeType = 1;
        Context ctx = this.context.peekFirst();
        if (ctx == null) {
            return new Async<IOException>(new IOException(ALREADY_CLOSED_ERROR_MESSAGE));
        }
        if (ctx.open) {
            this.context.removeFirst();
            if (!this.pretty) {
                return this.writer.write(CLOSE_EMPTY_TAG);
            }
            this.writer.write(CLOSE_EMPTY_TAG);
            return this.writer.write('\n');
        }
        String ns = this.getNamespace(ctx.namespaceURI);
        this.context.removeFirst();
        if (this.pretty) {
            --this.indent;
            this.indent();
        }
        this.writer.write(START_CLOSE);
        if (ns != null && ns.length() > 0) {
            this.writer.write(ns);
            this.writer.write(':');
        }
        this.writer.write(ctx.localName);
        if (!this.pretty) {
            return this.writer.write('>');
        }
        return this.writer.write(PRETTY_END_TAG);
    }

    public IAsync<IOException> addText(CharSequence text) {
        return this.addEscapedText(XMLWriter.escape(text));
    }

    public IAsync<IOException> addEscapedText(CharSequence text) {
        Context ctx = this.context.peekFirst();
        if (ctx == null) {
            return new Async<IOException>(new IOException(ALREADY_CLOSED_ERROR_MESSAGE));
        }
        if (ctx.open) {
            this.endOfAttributes(ctx);
        }
        if (!this.pretty || this.lastNodeType == 3) {
            return this.writer.write(text);
        }
        this.indent();
        this.lastNodeType = (short)3;
        return this.writer.write(text);
    }

    public IAsync<IOException> addCData(CharSequence data) {
        Context ctx = this.context.peekFirst();
        if (ctx == null) {
            return new Async<IOException>(new IOException(ALREADY_CLOSED_ERROR_MESSAGE));
        }
        if (ctx.open) {
            this.endOfAttributes(ctx);
        }
        if (this.pretty) {
            if (this.lastNodeType != 1 && this.lastNodeType != 8 && this.lastNodeType != 4) {
                this.writer.write('\n');
            }
            this.indent();
        }
        this.writer.write(START_CDATA);
        this.writer.write(data);
        if (!this.pretty) {
            return this.writer.write(END_CDATA);
        }
        this.lastNodeType = (short)4;
        this.writer.write(END_CDATA);
        return this.writer.write('\n');
    }

    public IAsync<IOException> addComment(CharSequence comment) {
        Context ctx = this.context.peekFirst();
        if (ctx != null && ctx.open) {
            this.endOfAttributes(ctx);
        }
        if (this.pretty) {
            if (this.lastNodeType != 1 && this.lastNodeType != 8 && this.lastNodeType != 4) {
                this.writer.write('\n');
            }
            this.indent();
        }
        this.writer.write(START_COMMENT);
        this.writer.write(comment);
        if (!this.pretty) {
            return this.writer.write(END_COMMENT);
        }
        this.lastNodeType = (short)8;
        this.writer.write(END_COMMENT);
        return this.writer.write('\n');
    }

    public IAsync<IOException> write(Element element) {
        IAsync<IOException> open;
        String name = element.getLocalName();
        if (name == null) {
            name = element.getNodeName();
        }
        String uri = element.getNamespaceURI();
        String prefix = element.getPrefix();
        HashMap<String, String> namespaces = null;
        if (uri != null) {
            namespaces = new HashMap<String, String>(5);
            namespaces.put(uri, prefix);
        }
        if ((open = this.openElement(uri, name, namespaces)).isDone()) {
            return this.writeAttributes(element);
        }
        Async<IOException> sp = new Async<IOException>();
        open.thenStart(new Task.Cpu.FromRunnable(DOM_TASK_DESCRIPTION, this.output.getPriority(), () -> this.writeAttributes(element).onDone(sp)), sp);
        return sp;
    }

    private IAsync<IOException> writeAttributes(Element element) {
        NamedNodeMap attrs = element.getAttributes();
        if (attrs != null && attrs.getLength() > 0) {
            return this.writeAttribute(element, attrs, 0);
        }
        return this.writeChildren(element);
    }

    private IAsync<IOException> writeAttribute(Element element, NamedNodeMap attrs, int attrIndex) {
        Node a;
        IAsync<IOException> sp;
        while ((sp = this.addAttribute((a = attrs.item(attrIndex)).getNodeName(), a.getNodeValue())).isDone()) {
            if (sp.hasError()) {
                return sp;
            }
            if (++attrIndex != attrs.getLength()) continue;
            return this.writeChildren(element);
        }
        Async<IOException> result = new Async<IOException>();
        int nextIndex = attrIndex + 1;
        sp.thenStart(new Task.Cpu.FromRunnable(DOM_TASK_DESCRIPTION, this.output.getPriority(), () -> {
            if (nextIndex == attrs.getLength()) {
                this.writeChildren(element).onDone(result);
                return;
            }
            this.writeAttribute(element, attrs, nextIndex).onDone(result);
        }), result);
        return result;
    }

    private IAsync<IOException> writeChildren(Element element) {
        NodeList children = element.getChildNodes();
        if (children.getLength() == 0) {
            return this.closeElement();
        }
        IAsync<IOException> open = this.endOfAttributes();
        if (open.isDone()) {
            if (open.hasError()) {
                return open;
            }
            return this.writeChild(children, 0);
        }
        Async<IOException> sp = new Async<IOException>();
        open.thenStart(new Task.Cpu.FromRunnable(DOM_TASK_DESCRIPTION, this.output.getPriority(), () -> this.writeChild(children, 0).onDone(sp)), sp);
        return sp;
    }

    private IAsync<IOException> writeChild(NodeList children, int childIndex) {
        Node child;
        IAsync<Object> sp;
        while ((sp = (child = children.item(childIndex)) instanceof Element ? this.write((Element)child) : (child instanceof Comment ? this.addComment(((Comment)child).getData()) : (child instanceof CDATASection ? this.addCData(((CDATASection)child).getData()) : (child instanceof Text ? this.addText(((Text)child).getData()) : new Async<boolean>(true))))).isDone()) {
            if (sp.hasError()) {
                return sp;
            }
            if (++childIndex != children.getLength()) continue;
            return this.closeElement();
        }
        Async<IOException> result = new Async<IOException>();
        int nextIndex = childIndex + 1;
        sp.thenStart(new Task.Cpu.FromRunnable(DOM_TASK_DESCRIPTION, this.output.getPriority(), () -> {
            if (nextIndex == children.getLength()) {
                this.closeElement().onDone(result);
                return;
            }
            this.writeChild(children, nextIndex).onDone(result);
        }), result);
        return result;
    }

    private static final class Context {
        private String namespaceURI = null;
        private String localName;
        private Map<String, String> namespaces = null;
        private boolean open = true;

        private Context() {
        }
    }
}

