/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml.dom;

import net.lecousin.framework.xml.dom.XMLDocument;
import net.lecousin.framework.xml.dom.XMLElement;
import net.lecousin.framework.xml.dom.XMLNode;
import org.w3c.dom.Attr;
import org.w3c.dom.TypeInfo;

public class XMLAttribute
extends XMLNode
implements Attr {
    protected String prefix;
    protected String localName;
    protected String value;
    protected boolean isId = false;

    public XMLAttribute(XMLDocument doc, String prefix, String localName, String value) {
        super(doc);
        this.prefix = prefix;
        this.localName = localName;
        this.value = value;
    }

    @Override
    public XMLAttribute cloneNode(boolean deep) {
        XMLAttribute clone = new XMLAttribute(this.doc, this.prefix, this.localName, this.value);
        clone.isId = this.isId;
        this.cloned(clone);
        return clone;
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public String getPrefix() {
        return this.prefix == null || this.prefix.isEmpty() ? null : this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        XMLElement p = (XMLElement)this.parent;
        if (p != null) {
            String uri = p.lookupNamespaceURI(prefix);
            String uri2 = this.getNamespaceURI();
            if (uri == null && uri2 != null) {
                p.declareNamespace(uri2, prefix);
            }
        }
        this.prefix = prefix;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getNodeName() {
        if (this.prefix != null && this.prefix.length() > 0) {
            return this.prefix + ':' + this.localName;
        }
        return this.localName;
    }

    @Override
    public String getNodeValue() {
        return this.value;
    }

    @Override
    public void setNodeValue(String nodeValue) {
        this.value = nodeValue;
    }

    @Override
    public String getName() {
        return this.prefix.length() > 0 ? this.prefix + ':' + this.localName : this.localName;
    }

    @Override
    public XMLElement getOwnerElement() {
        return this.parent == null ? null : (XMLElement)this.parent;
    }

    @Override
    public boolean getSpecified() {
        return this.value != null;
    }

    @Override
    public boolean isId() {
        return this.isId;
    }

    @Override
    public String getNamespaceURI() {
        if (this.parent == null) {
            return null;
        }
        if (((XMLElement)this.parent).prefixToURI == null) {
            return null;
        }
        return ((XMLElement)this.parent).prefixToURI.get(this.prefix);
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public String getTextContent() {
        return this.value != null ? this.value : "";
    }

    @Override
    public void setTextContent(String textContent) {
    }
}

