/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml.dom;

import net.lecousin.framework.xml.dom.XMLDocument;
import net.lecousin.framework.xml.dom.XMLDocumentType;
import net.lecousin.framework.xml.dom.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;

public class XMLDomImplementation
implements DOMImplementation {
    private static XMLDomImplementation instance = new XMLDomImplementation();

    private XMLDomImplementation() {
    }

    public static XMLDomImplementation getInstance() {
        return instance;
    }

    @Override
    public XMLDocumentType createDocumentType(String qualifiedName, String publicId, String systemId) {
        return new XMLDocumentType(null, qualifiedName, publicId, systemId);
    }

    @Override
    public XMLDocument createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) {
        String localName;
        String prefix;
        int i;
        XMLDocument doc = new XMLDocument();
        if (doctype != null) {
            if (!(doctype instanceof XMLDocumentType)) {
                throw new DOMException(4, "doctype must be a XMLDocumentType");
            }
            doc.setDocumentType((XMLDocumentType)doctype);
        }
        if ((i = qualifiedName.indexOf(58)) < 0) {
            prefix = "";
            localName = qualifiedName;
        } else {
            prefix = qualifiedName.substring(0, i);
            localName = qualifiedName.substring(i + 1);
        }
        XMLElement root = new XMLElement(doc, prefix, localName);
        if (namespaceURI != null) {
            root.declareNamespace(namespaceURI, prefix);
        }
        doc.setDocumentElement(root);
        return doc;
    }

    @Override
    public boolean hasFeature(String feature, String version) {
        return false;
    }

    @Override
    public Object getFeature(String feature, String version) {
        return null;
    }
}

