/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml.dom;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.text.IString;
import net.lecousin.framework.util.ObjectUtil;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.xml.XMLException;
import net.lecousin.framework.xml.XMLStreamEvents;
import net.lecousin.framework.xml.XMLStreamEventsAsync;
import net.lecousin.framework.xml.XMLStreamEventsSync;
import net.lecousin.framework.xml.dom.DOMErrors;
import net.lecousin.framework.xml.dom.XMLAttribute;
import net.lecousin.framework.xml.dom.XMLCData;
import net.lecousin.framework.xml.dom.XMLComment;
import net.lecousin.framework.xml.dom.XMLDocument;
import net.lecousin.framework.xml.dom.XMLNamedNodeMap;
import net.lecousin.framework.xml.dom.XMLNode;
import net.lecousin.framework.xml.dom.XMLNodeList;
import net.lecousin.framework.xml.dom.XMLText;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class XMLElement
extends XMLNode
implements Element {
    protected String prefix;
    protected String localName;
    protected Map<String, String> prefixToURI = null;
    protected LinkedList<XMLAttribute> attributes = new LinkedList();
    protected LinkedList<XMLNode> children = new LinkedList();

    public XMLElement(XMLDocument doc, String prefix, String localName) {
        super(doc);
        this.prefix = prefix;
        this.localName = localName;
    }

    public XMLElement(XMLDocument doc, XMLStreamEvents.ElementContext context) {
        this(doc, context.namespacePrefix.asString(), context.localName.asString());
        for (Pair<IString, IString> ns : context.namespaces) {
            this.declareNamespace(ns.getValue2().asString(), ns.getValue1().asString());
        }
        if (context.defaultNamespace != null && !context.defaultNamespace.isEmpty()) {
            this.declareNamespace(context.defaultNamespace.asString(), "");
        }
    }

    @Override
    public XMLElement cloneNode(boolean deep) {
        XMLElement clone = new XMLElement(this.doc, this.prefix, this.localName);
        if (this.prefixToURI != null) {
            clone.prefixToURI = new HashMap<String, String>(this.prefixToURI);
        }
        for (XMLAttribute a : this.attributes) {
            clone.addAttribute(a.cloneNode(false));
        }
        if (deep) {
            for (XMLNode child : this.children) {
                clone.appendChild(child.cloneNode(true));
            }
        }
        this.cloned(clone);
        return clone;
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public String getNodeName() {
        if (this.prefix != null && this.prefix.length() > 0) {
            return this.prefix + ':' + this.localName;
        }
        return this.localName;
    }

    @Override
    public String getTagName() {
        return this.getNodeName();
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getPrefix() {
        return this.prefix == null || this.prefix.isEmpty() ? null : this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String getNamespaceURI() {
        return this.lookupNamespaceURI(this.prefix);
    }

    @Override
    public XMLNode appendChild(Node newChild) {
        if (!(newChild instanceof XMLNode)) {
            throw DOMErrors.invalidChildType(newChild);
        }
        if (newChild == this) {
            throw DOMErrors.cannotBeAChildOfItself();
        }
        XMLNode child = (XMLNode)newChild;
        if (this.isAncestor(child)) {
            throw DOMErrors.cannotAddAnAncestor();
        }
        child.setParent(this);
        this.children.add(child);
        return child;
    }

    @Override
    public XMLNode insertBefore(Node newChild, Node refChild) {
        if (!(newChild instanceof XMLNode)) {
            throw DOMErrors.invalidChildType(newChild);
        }
        if (newChild == this) {
            throw DOMErrors.cannotBeAChildOfItself();
        }
        XMLNode child = (XMLNode)newChild;
        if (this.isAncestor(child)) {
            throw DOMErrors.cannotAddAnAncestor();
        }
        if (refChild == null) {
            child.setParent(this);
            this.children.add(child);
            return child;
        }
        int i = this.children.indexOf(refChild);
        if (i < 0) {
            throw new DOMException(3, "refChild is not a child of this element");
        }
        child.setParent(this);
        this.children.add(i, child);
        return child;
    }

    @Override
    public XMLNode removeChild(Node oldChild) {
        if (!(oldChild instanceof XMLNode)) {
            throw new DOMException(3, "oldChild must implement XMLNode");
        }
        XMLNode child = (XMLNode)oldChild;
        if (child.parent != this) {
            throw new DOMException(3, "The given child is not a child of this Element");
        }
        child.parent = null;
        this.children.remove(child);
        return child;
    }

    @Override
    public XMLNode replaceChild(Node newChild, Node oldChild) {
        if (!(newChild instanceof XMLNode)) {
            throw DOMErrors.invalidChildType(newChild);
        }
        if (newChild == this) {
            throw DOMErrors.cannotBeAChildOfItself();
        }
        if (!(oldChild instanceof XMLNode)) {
            throw DOMErrors.invalidChildType(oldChild);
        }
        XMLNode neChild = (XMLNode)newChild;
        XMLNode olChild = (XMLNode)oldChild;
        if (olChild.parent != this) {
            throw new DOMException(3, "The given oldChild is not a child of this Element");
        }
        if (this.isAncestor(neChild)) {
            throw DOMErrors.cannotAddAnAncestor();
        }
        int i = this.children.indexOf(olChild);
        olChild.parent = null;
        neChild.setParent(this);
        this.children.set(i, neChild);
        return olChild;
    }

    @Override
    public Node getFirstChild() {
        return this.children.peekFirst();
    }

    @Override
    public Node getLastChild() {
        return this.children.peekLast();
    }

    @Override
    public boolean hasChildNodes() {
        return !this.children.isEmpty();
    }

    @Override
    public NodeList getChildNodes() {
        return new XMLNodeList(this.children);
    }

    @Override
    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    @Override
    public boolean hasAttribute(String name) {
        for (XMLAttribute a : this.attributes) {
            if (!a.getNodeName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return new XMLNamedNodeMap(this.attributes);
    }

    @Override
    public String getAttribute(String name) {
        for (XMLAttribute a : this.attributes) {
            if (!a.getNodeName().equals(name)) continue;
            return a.getNodeValue();
        }
        return "";
    }

    @Override
    public void setAttribute(String name, String value) {
        for (XMLAttribute a : this.attributes) {
            if (!a.getNodeName().equals(name)) continue;
            a.setNodeValue(value);
            return;
        }
        this.addAttribute(new XMLAttribute(this.doc, "", name, value));
    }

    @Override
    public void removeAttribute(String name) {
        Iterator it = this.attributes.iterator();
        while (it.hasNext()) {
            XMLAttribute a = (XMLAttribute)it.next();
            if (!a.getNodeName().equals(name)) continue;
            a.parent = null;
            it.remove();
            return;
        }
    }

    @Override
    public XMLAttribute getAttributeNode(String name) {
        for (XMLAttribute a : this.attributes) {
            if (!a.getNodeName().equals(name)) continue;
            return a;
        }
        return null;
    }

    @Override
    public XMLAttribute setAttributeNode(Attr newAttr) {
        if (!(newAttr instanceof XMLAttribute)) {
            throw new DOMException(4, "newAttr must be a XMLAttribute");
        }
        XMLAttribute na = (XMLAttribute)newAttr;
        ListIterator<XMLAttribute> it = this.attributes.listIterator();
        while (it.hasNext()) {
            XMLAttribute a = (XMLAttribute)it.next();
            if (!a.isEqualNode(na)) continue;
            it.set(na);
            a.parent = null;
            na.setParent(this);
            return na;
        }
        this.addAttribute(na);
        return na;
    }

    @Override
    public XMLAttribute removeAttributeNode(Attr oldAttr) {
        if (!(oldAttr instanceof XMLAttribute)) {
            throw new DOMException(4, "oldAttr must be a XMLAttribute");
        }
        XMLAttribute na = (XMLAttribute)oldAttr;
        Iterator it = this.attributes.iterator();
        while (it.hasNext()) {
            XMLAttribute a = (XMLAttribute)it.next();
            if (!a.isEqualNode(na)) continue;
            it.remove();
            a.parent = null;
            return a;
        }
        throw new DOMException(8, "Attribute not found in this element");
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        String prefx = this.getPrefixForNamespaceURI(namespaceURI);
        if (prefx == null) {
            return false;
        }
        for (XMLAttribute a : this.attributes) {
            if (!prefx.equals(a.prefix) || !localName.equals(a.localName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        String prefx = this.getPrefixForNamespaceURI(namespaceURI);
        if (prefx == null) {
            return "";
        }
        for (XMLAttribute a : this.attributes) {
            if (!prefx.equals(a.prefix) || !localName.equals(a.localName)) continue;
            return a.value == null ? "" : a.value;
        }
        return "";
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        String local;
        String pref;
        int i = qualifiedName.indexOf(58);
        if (i < 0) {
            pref = "";
            local = qualifiedName;
        } else {
            pref = qualifiedName.substring(0, i);
            local = qualifiedName.substring(i + 1);
        }
        if (this.prefixToURI != null) {
            String uri = this.prefixToURI.get(pref);
            if (uri != null && !uri.equals(namespaceURI)) {
                throw new DOMException(14, "Prefix " + pref + " is already used for namespace " + uri);
            }
            if (uri == null) {
                this.prefixToURI.put(pref, namespaceURI);
            }
        } else if (namespaceURI != null || !pref.isEmpty()) {
            this.declareNamespace(namespaceURI, pref);
        }
        XMLAttribute a = new XMLAttribute(this.doc, pref, local, value);
        this.setAttributeNode(a);
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) {
        Iterator it = this.attributes.iterator();
        while (it.hasNext()) {
            XMLAttribute a = (XMLAttribute)it.next();
            if (!a.localName.equals(localName) || !namespaceURI.equals(a.getNamespaceURI())) continue;
            it.remove();
            a.parent = null;
            return;
        }
    }

    @Override
    public XMLAttribute getAttributeNodeNS(String namespaceURI, String localName) {
        for (XMLAttribute a : this.attributes) {
            if (!a.localName.equals(localName) || !namespaceURI.equals(a.getNamespaceURI())) continue;
            return a;
        }
        return null;
    }

    @Override
    public XMLAttribute setAttributeNodeNS(Attr newAttr) {
        if (!(newAttr instanceof XMLAttribute)) {
            throw new DOMException(4, "newAttr must be a XMLAttribute");
        }
        XMLAttribute na = (XMLAttribute)newAttr;
        ListIterator<XMLAttribute> it = this.attributes.listIterator();
        while (it.hasNext()) {
            XMLAttribute a = (XMLAttribute)it.next();
            if (!a.getName().equals(na.getName())) continue;
            it.set(na);
            a.parent = null;
            na.setParent(this);
            return na;
        }
        this.addAttribute(na);
        return na;
    }

    @Override
    public void setIdAttribute(String name, boolean isId) {
        XMLAttribute a = this.getAttributeNode(name);
        if (a == null) {
            throw DOMErrors.attributeDoesNotExist(name);
        }
        a.isId = isId;
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) {
        XMLAttribute a = this.getAttributeNodeNS(namespaceURI, localName);
        if (a == null) {
            throw DOMErrors.attributeDoesNotExist(localName);
        }
        a.isId = isId;
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) {
        if (!this.attributes.contains(idAttr)) {
            throw DOMErrors.attributeDoesNotExist(this.localName);
        }
        XMLAttribute a = (XMLAttribute)idAttr;
        a.isId = isId;
    }

    public void addAttribute(XMLAttribute a) {
        a.setParent(this);
        this.attributes.add(a);
    }

    public String getPrefixForNamespaceURI(String namespaceURI) {
        if (namespaceURI == null) {
            return "";
        }
        if (this.prefixToURI != null) {
            for (Map.Entry<String, String> e : this.prefixToURI.entrySet()) {
                if (!e.getValue().equals(namespaceURI)) continue;
                return e.getKey();
            }
        }
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof XMLElement) {
            return ((XMLElement)this.parent).getPrefixForNamespaceURI(namespaceURI);
        }
        return this.parent.lookupPrefix(namespaceURI);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        if (this.prefixToURI != null) {
            for (Map.Entry<String, String> e : this.prefixToURI.entrySet()) {
                if (!e.getValue().equals(namespaceURI) || e.getKey().length() <= 0) continue;
                return e.getKey();
            }
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.lookupPrefix(namespaceURI);
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        if (this.prefixToURI != null) {
            for (Map.Entry<String, String> e : this.prefixToURI.entrySet()) {
                if (!e.getKey().isEmpty()) continue;
                return e.getValue().equals(namespaceURI);
            }
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.isDefaultNamespace(namespaceURI);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        String uri;
        if (this.prefixToURI != null && (uri = this.prefixToURI.get(prefix)) != null) {
            return uri;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.lookupNamespaceURI(prefix);
    }

    public void declareNamespace(String uri, String prefix) {
        if (this.prefixToURI == null) {
            this.prefixToURI = new HashMap<String, String>(5);
        }
        this.prefixToURI.put(prefix, uri);
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        LinkedList<XMLNode> elements = new LinkedList<XMLNode>();
        if ("*".equals(name)) {
            name = null;
        }
        this.getElementsByTagName(name, elements);
        return new XMLNodeList(elements);
    }

    protected void getElementsByTagName(String name, List<XMLNode> result) {
        for (XMLNode child : this.children) {
            if (!(child instanceof XMLElement)) continue;
            XMLElement e = (XMLElement)child;
            if (name == null || e.getNodeName().equals(name)) {
                result.add(e);
            }
            e.getElementsByTagName(name, result);
        }
    }

    protected void getElementsByTagName(String namespaceURI, String localName, List<XMLNode> result) {
        for (XMLNode child : this.children) {
            if (!(child instanceof XMLElement)) continue;
            XMLElement e = (XMLElement)child;
            if (("*".equals(localName) || e.getLocalName().equals(localName)) && ("*".equals(namespaceURI) || ObjectUtil.equalsOrNull(namespaceURI, e.getNamespaceURI()))) {
                result.add(e);
            }
            e.getElementsByTagName(namespaceURI, localName, result);
        }
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        LinkedList<XMLNode> elements = new LinkedList<XMLNode>();
        this.getElementsByTagName(namespaceURI, localName, elements);
        return new XMLNodeList(elements);
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public String getTextContent() {
        if (this.children.isEmpty()) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (XMLNode child : this.children) {
            if (child instanceof XMLComment || child instanceof XMLText && ((XMLText)child).isElementContentWhitespace()) continue;
            s.append(child.getTextContent());
        }
        return s.toString();
    }

    @Override
    public void setTextContent(String textContent) {
        while (!this.children.isEmpty()) {
            this.removeChild(this.children.getFirst());
        }
        this.appendChild(new XMLText(this.doc, textContent));
    }

    @Override
    public void normalize() {
        for (int pos = 1; pos < this.children.size(); ++pos) {
            XMLNode prev;
            XMLNode child = this.children.get(pos);
            if (!(child instanceof XMLText) || !((prev = this.children.get(pos - 1)) instanceof XMLText)) continue;
            prev.setTextContent(prev.getTextContent() + child.getTextContent());
            this.removeChild(child);
            --pos;
        }
    }

    public static XMLElement create(XMLDocument doc, XMLStreamEventsSync stream) throws XMLException, IOException {
        if (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)stream.event.type)) {
            throw new IllegalStateException("Method XMLElement.create must be called with a stream being on a START_ELEMENT event");
        }
        XMLElement element = new XMLElement(doc, stream.event.context.getFirst());
        for (XMLStreamEvents.Attribute a : stream.event.attributes) {
            element.addAttribute(new XMLAttribute(doc, a.namespacePrefix.asString(), a.localName.asString(), a.value != null ? a.value.asString() : null));
        }
        element.parseContent(stream);
        return element;
    }

    public static AsyncSupplier<XMLElement, Exception> create(XMLDocument doc, XMLStreamEventsAsync stream) {
        if (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)stream.event.type)) {
            throw new IllegalStateException("Method XMLElement.create must be called with a stream being on a START_ELEMENT event");
        }
        XMLElement element = new XMLElement(doc, stream.event.context.getFirst());
        for (XMLStreamEvents.Attribute a : stream.event.attributes) {
            element.addAttribute(new XMLAttribute(doc, a.namespacePrefix.asString(), a.localName.asString(), a.value != null ? a.value.asString() : null));
        }
        IAsync<Exception> parse = element.parseContent(stream);
        AsyncSupplier<XMLElement, Exception> result = new AsyncSupplier<XMLElement, Exception>();
        if (parse.isDone()) {
            if (parse.hasError()) {
                result.error(parse.getError());
            } else {
                result.unblockSuccess(element);
            }
            return result;
        }
        parse.onDone(() -> result.unblockSuccess(element), result);
        return result;
    }

    public void parseContent(XMLStreamEventsSync stream) throws XMLException, IOException {
        if (stream.event.isClosed) {
            return;
        }
        block8: while (true) {
            stream.next();
            switch (stream.event.type) {
                case START_ELEMENT: {
                    this.appendChild(XMLElement.create(this.doc, stream));
                    continue block8;
                }
                case END_ELEMENT: {
                    return;
                }
                case TEXT: {
                    this.appendChild(new XMLText(this.doc, stream.event.text.asString()));
                    continue block8;
                }
                case CDATA: {
                    this.appendChild(new XMLCData(this.doc, stream.event.text.asString()));
                    continue block8;
                }
                case COMMENT: {
                    this.appendChild(new XMLComment(this.doc, stream.event.text.asString()));
                    continue block8;
                }
                case PROCESSING_INSTRUCTION: {
                    continue block8;
                }
            }
            break;
        }
        throw new IOException("Unexpected XML event " + (Object)((Object)stream.event.type) + " in an element");
    }

    public IAsync<Exception> parseContent(XMLStreamEventsAsync stream) {
        if (stream.event.isClosed) {
            return new Async<boolean>(true);
        }
        return this.parseContent(stream, null);
    }

    private IAsync<Exception> parseContent(final XMLStreamEventsAsync stream, IAsync<Exception> s) {
        IAsync<Exception> next;
        while (true) {
            IAsync<Exception> iAsync = next = s != null ? s : stream.next();
            if (!next.isDone()) break;
            if (next.hasError()) {
                return next;
            }
            switch (stream.event.type) {
                case START_ELEMENT: {
                    final AsyncSupplier<XMLElement, Exception> child = XMLElement.create(this.doc, stream);
                    if (child.isDone()) {
                        if (child.hasError()) {
                            return child;
                        }
                        this.appendChild(child.getResult());
                        break;
                    }
                    final Async<Exception> sp = new Async<Exception>();
                    child.thenStart(new Task.Cpu<Void, NoException>("Parsing XML to DOM", stream.getPriority()){

                        @Override
                        public Void run() {
                            XMLElement.this.appendChild((Node)child.getResult());
                            XMLElement.this.parseContent(stream, null).onDone(sp);
                            return null;
                        }
                    }, sp);
                    return sp;
                }
                case END_ELEMENT: {
                    return next;
                }
                case TEXT: {
                    this.appendChild(new XMLText(this.doc, stream.event.text.asString()));
                    break;
                }
                case CDATA: {
                    this.appendChild(new XMLCData(this.doc, stream.event.text.asString()));
                    break;
                }
                case COMMENT: {
                    this.appendChild(new XMLComment(this.doc, stream.event.text.asString()));
                    break;
                }
                case PROCESSING_INSTRUCTION: {
                    break;
                }
                default: {
                    return new Async<Exception>(new IOException("Unexpected XML event " + (Object)((Object)stream.event.type) + " in an element"));
                }
            }
            s = null;
        }
        final Async<Exception> sp = new Async<Exception>();
        next.thenStart(new Task.Cpu<Void, NoException>("Parsing XML to DOM", stream.getPriority()){

            @Override
            public Void run() {
                XMLElement.this.parseContent(stream, next).onDone(sp);
                return null;
            }
        }, sp);
        return sp;
    }
}

