/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml.serialization;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.encoding.Base64Encoding;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.IOInMemoryOrFile;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.io.data.BytesFromIso8859CharArray;
import net.lecousin.framework.io.data.CharArray;
import net.lecousin.framework.io.serialization.AbstractDeserializer;
import net.lecousin.framework.io.serialization.Deserializer;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationException;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.math.IntegerUnit;
import net.lecousin.framework.text.CharArrayStringBuffer;
import net.lecousin.framework.text.IString;
import net.lecousin.framework.util.ClassUtil;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.xml.XMLStreamEvents;
import net.lecousin.framework.xml.XMLStreamEventsAsync;
import net.lecousin.framework.xml.XMLStreamReaderAsync;
import net.lecousin.framework.xml.serialization.XMLCustomSerialization;
import net.lecousin.framework.xml.serialization.XMLCustomSerializer;

public class XMLDeserializer
extends AbstractDeserializer {
    protected String expectedRootNamespaceURI;
    protected String expectedRootLocalName;
    protected Charset forceEncoding;
    protected XMLStreamEventsAsync input;
    protected static final Function<Exception, SerializationException> xmlErrorConverter = err -> new SerializationException("Error reading XML", (Throwable)err);
    private LinkedList<CollectionValueContext> colValueContext = new LinkedList();
    private LinkedList<XMLObjectContext> objects = new LinkedList();

    public XMLDeserializer(String expectedRootNamespaceURI, String expectedRootLocalName) {
        this(expectedRootNamespaceURI, expectedRootLocalName, null);
    }

    public XMLDeserializer(String expectedRootNamespaceURI, String expectedRootLocalName, Charset encoding) {
        this.expectedRootNamespaceURI = expectedRootNamespaceURI;
        this.expectedRootLocalName = expectedRootLocalName;
        this.forceEncoding = encoding;
    }

    public XMLDeserializer(XMLStreamEventsAsync input, String expectedRootNamespaceURI, String expectedRootLocalName) {
        this.input = input;
        this.expectedRootNamespaceURI = expectedRootNamespaceURI;
        this.expectedRootLocalName = expectedRootLocalName;
    }

    public static <T> AsyncSupplier<T, SerializationException> deserializeResource(String resourcePath, Class<T> type, List<SerializationRule> rules, byte priority) {
        IO.Readable io = LCCore.getApplication().getResource(resourcePath, priority);
        if (io == null) {
            return new AsyncSupplier<Object, SerializationException>(null, new SerializationException("Resource not found: " + resourcePath));
        }
        AsyncSupplier<T, SerializationException> result = XMLDeserializer.deserialize(io, type, rules);
        io.closeAfter(result);
        return result;
    }

    public static <T> AsyncSupplier<T, SerializationException> deserializeFile(File file, Class<T> type, List<SerializationRule> rules, byte priority) {
        FileIO.ReadOnly io = new FileIO.ReadOnly(file, priority);
        AsyncSupplier<T, SerializationException> result = XMLDeserializer.deserialize(io, type, rules);
        io.closeAfter(result);
        return result;
    }

    public static <T> AsyncSupplier<T, SerializationException> deserialize(IO.Readable input, Class<T> type, List<SerializationRule> rules) {
        XMLDeserializer deserializer = new XMLDeserializer(null, type.getSimpleName());
        AsyncSupplier<Object, SerializationException> res = deserializer.deserialize(new TypeDefinition(type, new TypeDefinition[0]), input, rules == null ? new ArrayList(0) : rules);
        AsyncSupplier result = new AsyncSupplier();
        res.onDone(obj -> result.unblockSuccess(obj), result);
        return result;
    }

    protected IAsync<Exception> createAndStartReader(IO.Readable input) {
        XMLStreamReaderAsync reader = new XMLStreamReaderAsync(input, this.forceEncoding, 8192, 4);
        this.input = reader;
        reader.setMaximumTextSize(this.maxTextSize);
        reader.setMaximumCDataSize(this.maxTextSize);
        return reader.startRootElement();
    }

    @Override
    public void setMaximumTextSize(int max) {
        super.setMaximumTextSize(max);
        if (this.input != null) {
            this.input.setMaximumTextSize(this.maxTextSize);
            this.input.setMaximumCDataSize(this.maxTextSize);
        }
    }

    @Override
    protected IAsync<SerializationException> initializeDeserialization(IO.Readable input) {
        IAsync<Exception> start = this.createAndStartReader(input);
        Async<SerializationException> sp = new Async<SerializationException>();
        start.onDone(() -> {
            if (this.expectedRootLocalName != null && !this.input.event.localName.equals(this.expectedRootLocalName)) {
                sp.error(new SerializationException("Expected root XML element is " + this.expectedRootLocalName + ", found is " + this.input.event.localName.asString()));
            } else if (this.expectedRootNamespaceURI != null && !this.input.getNamespaceURI(this.input.event.namespacePrefix).equals(this.expectedRootNamespaceURI)) {
                sp.error(new SerializationException("Expected root XML element namespace is " + this.expectedRootNamespaceURI + ", found is " + this.input.getNamespaceURI(this.input.event.namespacePrefix)));
            } else {
                sp.unblock();
            }
        }, sp, xmlErrorConverter);
        return sp;
    }

    @Override
    protected IAsync<SerializationException> finalizeDeserialization() {
        return new Async<boolean>(true);
    }

    @Override
    protected AsyncSupplier<Boolean, SerializationException> deserializeBooleanValue(boolean nullable) {
        XMLStreamEvents.Attribute a = this.input.getAttributeWithNamespaceURI("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (a != null && a.value.equals("true")) {
            if (nullable) {
                return new AsyncSupplier<Object, Object>(null, null);
            }
            return new AsyncSupplier<Object, SerializationException>(null, new SerializationException("null value found but boolean expected"));
        }
        AsyncSupplier<CharArrayStringBuffer, Exception> read = this.input.readInnerText();
        AsyncSupplier<Boolean, SerializationException> result = new AsyncSupplier<Boolean, SerializationException>();
        read.onDone(text -> {
            text.toLowerCase();
            if (text.equals("true") || text.equals("yes") || text.equals("1")) {
                result.unblockSuccess(Boolean.TRUE);
            } else if (text.equals("false") || text.equals("no") || text.equals("0")) {
                result.unblockSuccess(Boolean.FALSE);
            } else {
                result.error(new SerializationException("Invalid boolean value: " + text.asString()));
            }
        }, result, xmlErrorConverter);
        return result;
    }

    @Override
    protected AsyncSupplier<? extends Number, SerializationException> deserializeNumericValue(Class<?> type, boolean nullable, Class<? extends IntegerUnit> targetUnit) {
        XMLStreamEvents.Attribute a = this.input.getAttributeWithNamespaceURI("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (a != null && a.value.equals("true")) {
            if (nullable) {
                return new AsyncSupplier<Object, Object>(null, null);
            }
            return new AsyncSupplier<Object, SerializationException>(null, new SerializationException("null value found but number expected"));
        }
        AsyncSupplier<CharArrayStringBuffer, Exception> read = this.input.readInnerText();
        AsyncSupplier result = new AsyncSupplier();
        read.onDone(text -> {
            try {
                if (targetUnit != null) {
                    result.unblockSuccess(XMLDeserializer.convertStringToInteger(type, text.asString(), targetUnit));
                } else {
                    XMLDeserializer.convertBigDecimalValue(new BigDecimal(text.asString()), type, result);
                }
            }
            catch (Exception e) {
                result.error(new SerializationException("Error deserializing numeric value", e));
            }
        }, result, xmlErrorConverter);
        return result;
    }

    @Override
    protected AsyncSupplier<? extends CharSequence, SerializationException> deserializeStringValue() {
        XMLStreamEvents.Attribute a = this.input.getAttributeWithNamespaceURI("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (a != null && a.value.equals("true")) {
            return new AsyncSupplier<Object, Object>(null, null);
        }
        if (this.input.event.isClosed) {
            return new AsyncSupplier<Object, Object>(null, null);
        }
        final AsyncSupplier result = new AsyncSupplier();
        final StringBuilder s = new StringBuilder();
        Runnable onNext = new Runnable(){

            @Override
            public void run() {
                if (XMLStreamEvents.Event.Type.TEXT.equals((Object)XMLDeserializer.this.input.event.type)) {
                    s.append(XMLDeserializer.this.input.event.text);
                    XMLDeserializer.this.input.next().onDone((Runnable)this, result, xmlErrorConverter);
                    return;
                }
                if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)XMLDeserializer.this.input.event.type)) {
                    result.error(new SerializationException("Unexpected XML element, text was expected"));
                    return;
                }
                if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)XMLDeserializer.this.input.event.type)) {
                    result.unblockSuccess(s.toString());
                    return;
                }
                XMLDeserializer.this.input.next().onDone((Runnable)this, result, xmlErrorConverter);
            }
        };
        this.input.next().onDone(onNext, result, xmlErrorConverter);
        return result;
    }

    @Override
    protected AsyncSupplier<Boolean, SerializationException> startCollectionValue() {
        XMLStreamEvents.Attribute a = this.input.getAttributeWithNamespaceURI("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (a != null && a.value.equals("true")) {
            return new AsyncSupplier<Boolean, Object>(Boolean.FALSE, null);
        }
        CollectionValueContext ctx = new CollectionValueContext();
        ctx.parent = this.input.event.context.getFirst();
        this.colValueContext.addFirst(ctx);
        return new AsyncSupplier<Boolean, Object>(Boolean.TRUE, null);
    }

    @Override
    protected AsyncSupplier<Pair<Object, Boolean>, SerializationException> deserializeCollectionValueElement(SerializationContext.CollectionContext context, int elementIndex, String colPath, List<SerializationRule> rules) {
        CollectionValueContext ctx = this.colValueContext.getFirst();
        AsyncSupplier<Boolean, Exception> read = this.nextInnerElement(ctx.parent);
        if (read.isDone()) {
            if (read.hasError()) {
                return new AsyncSupplier<Object, Exception>(null, xmlErrorConverter.apply(read.getError()));
            }
            if (!read.getResult().booleanValue()) {
                this.colValueContext.removeFirst();
                return new AsyncSupplier<Pair<Object, Boolean>, Object>(new Pair<Object, Boolean>(null, Boolean.FALSE), null);
            }
            if (!this.input.event.localName.equals("element")) {
                return new AsyncSupplier<Object, SerializationException>(null, new SerializationException("Unexpected element with name '" + this.input.event.localName + "', name 'element' expected for a collection"));
            }
            AsyncSupplier element = this.deserializeValue(context, context.getElementType(), colPath + '[' + elementIndex + ']', rules);
            if (element.isDone()) {
                if (element.hasError()) {
                    return new AsyncSupplier<Object, SerializationException>(null, element.getError());
                }
                return new AsyncSupplier(new Pair(element.getResult(), Boolean.TRUE), null);
            }
            AsyncSupplier<Pair<Object, Boolean>, SerializationException> result = new AsyncSupplier<Pair<Object, Boolean>, SerializationException>();
            element.onDone(() -> result.unblockSuccess(new Pair(element.getResult(), Boolean.TRUE)), result);
            return result;
        }
        AsyncSupplier<Pair<Object, Boolean>, SerializationException> result = new AsyncSupplier<Pair<Object, Boolean>, SerializationException>();
        read.thenStart(new AbstractDeserializer.DeserializationTask(() -> {
            if (!((Boolean)read.getResult()).booleanValue()) {
                this.colValueContext.removeFirst();
                result.unblockSuccess(new Pair<Object, Boolean>(null, Boolean.FALSE));
                return;
            }
            AsyncSupplier element = this.deserializeValue(context, context.getElementType(), colPath + '[' + elementIndex + ']', rules);
            if (element.isDone()) {
                if (element.hasError()) {
                    result.error(element.getError());
                } else {
                    result.unblockSuccess(new Pair(element.getResult(), Boolean.TRUE));
                }
                return;
            }
            element.onDone(() -> result.unblockSuccess(new Pair(element.getResult(), Boolean.TRUE)), (IAsync<SerializationException>)result);
        }), result, xmlErrorConverter);
        return result;
    }

    @Override
    protected AsyncSupplier<Object, SerializationException> startObjectValue(SerializationContext context, TypeDefinition type, List<SerializationRule> rules) {
        XMLStreamEvents.Attribute a = this.input.getAttributeWithNamespaceURI("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (a != null && a.value.equals("true")) {
            IAsync<Exception> close = this.input.closeElement();
            if (close.isDone()) {
                return new AsyncSupplier<Object, Object>(null, (close.hasError() ? xmlErrorConverter.apply(close.getError()) : null));
            }
            AsyncSupplier<Object, SerializationException> res = new AsyncSupplier<Object, SerializationException>();
            close.onDone(() -> res.unblockSuccess(null), res, xmlErrorConverter);
            return res;
        }
        XMLObjectContext ctx = new XMLObjectContext();
        ctx.element = this.input.event.context.getFirst();
        ctx.attributes = this.input.event.attributes;
        ctx.endOfAttributes = this.input.event.isClosed;
        this.objects.addFirst(ctx);
        String attrName = "class";
        while (XMLDeserializer.hasAttribute(type.getBase(), attrName)) {
            attrName = "_" + attrName;
        }
        a = this.input.removeAttributeByLocalName(attrName);
        if (a != null) {
            String className = a.value.asString();
            try {
                Class<?> cl = Class.forName(className);
                return new AsyncSupplier<Object, Object>(SerializationClass.instantiate(new TypeDefinition(cl, new TypeDefinition[0]), context, rules, true), null);
            }
            catch (SerializationException e) {
                return new AsyncSupplier<Object, SerializationException>(null, e);
            }
            catch (Exception e) {
                return new AsyncSupplier<Object, SerializationException>(null, new SerializationException("Error instantiating type " + className, e));
            }
        }
        try {
            return new AsyncSupplier<Object, Object>(SerializationClass.instantiate(type, context, rules, false), null);
        }
        catch (SerializationException e) {
            return new AsyncSupplier<Object, SerializationException>(null, e);
        }
        catch (Exception e) {
            return new AsyncSupplier<Object, SerializationException>(null, new SerializationException("Error instantiating type " + type, e));
        }
    }

    public static boolean hasAttribute(Class<?> type, String name) {
        if (type.equals(Object.class)) {
            return false;
        }
        for (Field f : type.getDeclaredFields()) {
            if (!f.getName().equals(name)) continue;
            return true;
        }
        Method m = ClassUtil.getGetter(type, name);
        if (m != null && !m.getDeclaringClass().equals(Object.class)) {
            return true;
        }
        m = ClassUtil.getSetter(type, name);
        if (m != null && !m.getDeclaringClass().equals(Object.class)) {
            return true;
        }
        if (type.getSuperclass() != null) {
            return XMLDeserializer.hasAttribute(type.getSuperclass(), name);
        }
        return false;
    }

    @Override
    protected AsyncSupplier<String, SerializationException> deserializeObjectAttributeName(SerializationContext.ObjectContext context) {
        AsyncSupplier<Boolean, Exception> next;
        XMLObjectContext ctx = this.objects.getFirst();
        if (ctx.attributeIndex < ctx.attributes.size()) {
            return new AsyncSupplier<String, Object>(((XMLStreamEvents.Attribute)((XMLObjectContext)ctx).attributes.get((int)((XMLObjectContext)ctx).attributeIndex)).localName.asString(), null);
        }
        if (ctx.endOfAttributes) {
            try {
                XMLDeserializer.endOfAttributes(ctx, context);
            }
            catch (SerializationException e) {
                return new AsyncSupplier<Object, SerializationException>(null, e);
            }
            this.objects.removeFirst();
            return new AsyncSupplier<Object, Object>(null, null);
        }
        if (ctx.onNextAttribute) {
            next = new AsyncSupplier<Boolean, Object>(Boolean.TRUE, null);
            ctx.onNextAttribute = false;
        } else {
            next = this.nextInnerElement(ctx.element);
        }
        AsyncSupplier<String, SerializationException> result = new AsyncSupplier<String, SerializationException>();
        next.onDone(() -> {
            if (next.hasError()) {
                if (next.getError() instanceof EOFException) {
                    this.objects.removeFirst();
                    result.unblockSuccess(null);
                    return;
                }
                result.error((SerializationException)((Exception)xmlErrorConverter.apply((Exception)next.getError())));
                return;
            }
            if (((Boolean)next.getResult()).booleanValue()) {
                String name = this.input.event.text.asString();
                ctx.attributesDone.add(name);
                result.unblockSuccess(name);
            } else {
                try {
                    XMLDeserializer.endOfAttributes(ctx, context);
                }
                catch (SerializationException e) {
                    result.error(e);
                    return;
                }
                this.objects.removeFirst();
                result.unblockSuccess(null);
            }
        });
        return result;
    }

    private static void endOfAttributes(XMLObjectContext ctx, SerializationContext.ObjectContext context) throws SerializationException {
        for (SerializationClass.Attribute a : context.getSerializationClass().getAttributes()) {
            String name = a.getName();
            if (!a.canSet() || a.ignore() || ctx.attributesDone.contains(name)) continue;
            boolean found = false;
            for (XMLStreamEvents.Attribute xmlAttr : ctx.attributes) {
                if (!xmlAttr.localName.equals(name)) continue;
                found = true;
                break;
            }
            if (found || a.getType().getBase().isPrimitive() || Collection.class.isAssignableFrom(a.getType().getBase())) continue;
            a.setValue(context.getInstance(), null);
        }
    }

    @Override
    protected AsyncSupplier<Boolean, SerializationException> deserializeBooleanAttributeValue(SerializationContext.AttributeContext context, boolean nullable) {
        XMLObjectContext ctx = this.objects.getFirst();
        if (ctx.attributeIndex < ctx.attributes.size()) {
            XMLStreamEvents.Attribute attr = (XMLStreamEvents.Attribute)ctx.attributes.get(ctx.attributeIndex++);
            attr.value.toLowerCase();
            if (attr.value.equals("true") || attr.value.equals("yes") || attr.value.equals("1")) {
                return new AsyncSupplier<Boolean, Object>(Boolean.TRUE, null);
            }
            if (attr.value.equals("false") || attr.value.equals("no") || attr.value.equals("0")) {
                return new AsyncSupplier<Boolean, Object>(Boolean.FALSE, null);
            }
            return new AsyncSupplier<Object, SerializationException>(null, new SerializationException("Invalid boolean value: " + attr.value.asString()));
        }
        return this.deserializeBooleanValue(nullable);
    }

    @Override
    protected AsyncSupplier<? extends Number, SerializationException> deserializeNumericAttributeValue(SerializationContext.AttributeContext context, boolean nullable) {
        XMLObjectContext ctx = this.objects.getFirst();
        IntegerUnit.Unit unit = context.getAttribute().getAnnotation(false, IntegerUnit.Unit.class);
        if (ctx.attributeIndex < ctx.attributes.size()) {
            XMLStreamEvents.Attribute attr = (XMLStreamEvents.Attribute)ctx.attributes.get(ctx.attributeIndex++);
            if (unit != null) {
                try {
                    return new AsyncSupplier<Number, Object>(XMLDeserializer.convertStringToInteger(context.getAttribute().getType().getBase(), attr.value.asString(), unit.value()), null);
                }
                catch (Exception e) {
                    return new AsyncSupplier<Object, SerializationException>(null, new SerializationException("Error reading numeric value", e));
                }
            }
            AsyncSupplier<Number, SerializationException> result = new AsyncSupplier<Number, SerializationException>();
            try {
                BigDecimal n = new BigDecimal(attr.value.asString());
                XMLDeserializer.convertBigDecimalValue(n, context.getAttribute().getType().getBase(), result);
            }
            catch (Exception e) {
                result.error(new SerializationException("Error reading numeric value", e));
            }
            return result;
        }
        return this.deserializeNumericValue(context.getAttribute().getType().getBase(), nullable, unit != null ? unit.value() : null);
    }

    @Override
    protected AsyncSupplier<? extends CharSequence, SerializationException> deserializeStringAttributeValue(SerializationContext.AttributeContext context) {
        XMLObjectContext ctx = this.objects.getFirst();
        if (ctx.attributeIndex < ctx.attributes.size()) {
            XMLStreamEvents.Attribute attr = (XMLStreamEvents.Attribute)ctx.attributes.get(ctx.attributeIndex++);
            return new AsyncSupplier<IString, Object>(attr.value, null);
        }
        return this.deserializeStringValue();
    }

    @Override
    protected AsyncSupplier<Pair<Object, Boolean>, SerializationException> deserializeCollectionAttributeValueElement(SerializationContext.CollectionContext context, int elementIndex, String colPath, List<SerializationRule> rules) {
        XMLObjectContext ctx = this.objects.getFirst();
        SerializationClass.Attribute colAttr = ((SerializationContext.AttributeContext)context.getParent()).getAttribute();
        AsyncSupplier<Pair<Object, Boolean>, SerializationException> result = new AsyncSupplier<Pair<Object, Boolean>, SerializationException>();
        if (elementIndex > 0) {
            AsyncSupplier<Boolean, Exception> next = this.nextInnerElement(ctx.element);
            if (next.isDone()) {
                if (next.hasError()) {
                    result.error((SerializationException)((Exception)xmlErrorConverter.apply(next.getError())));
                    return result;
                }
                if (!next.getResult().booleanValue()) {
                    ctx.endOfAttributes = true;
                    result.unblockSuccess(new Pair<Object, Boolean>(null, Boolean.FALSE));
                    return result;
                }
                if (!this.input.event.text.equals(colAttr.getName())) {
                    ctx.onNextAttribute = true;
                    result.unblockSuccess(new Pair<Object, Boolean>(null, Boolean.FALSE));
                    return result;
                }
            } else {
                next.thenStart(new AbstractDeserializer.DeserializationTask(() -> {
                    if (!((Boolean)next.getResult()).booleanValue()) {
                        ctx.endOfAttributes = true;
                        result.unblockSuccess(new Pair<Object, Boolean>(null, Boolean.FALSE));
                        return;
                    }
                    if (!this.input.event.text.equals(colAttr.getName())) {
                        ctx.onNextAttribute = true;
                        result.unblockSuccess(new Pair<Object, Boolean>(null, Boolean.FALSE));
                        return;
                    }
                    this.readColElement(context, colPath + '[' + elementIndex + ']', rules, result);
                }), result, xmlErrorConverter);
                return result;
            }
        }
        this.readColElement(context, colPath + '[' + elementIndex + ']', rules, result);
        return result;
    }

    private void readColElement(SerializationContext.CollectionContext context, String elementPath, List<SerializationRule> rules, AsyncSupplier<Pair<Object, Boolean>, SerializationException> result) {
        SerializationClass.Attribute a = null;
        for (SerializationContext c = context.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof SerializationContext.AttributeContext)) continue;
            a = ((SerializationContext.AttributeContext)c).getAttribute();
            break;
        }
        XMLCustomSerialization custom = a != null ? a.getAnnotation(false, XMLCustomSerialization.class) : null;
        AsyncSupplier<Object, SerializationException> value = null;
        if (custom != null) {
            try {
                XMLCustomSerializer s = custom.value().newInstance();
                if (s.type().equals(context.getElementType())) {
                    value = s.deserialize(this, this.input, rules);
                }
            }
            catch (Exception e) {
                result.error(new SerializationException("Error instantiating custom type", e));
                return;
            }
        }
        if (value == null) {
            value = this.deserializeValue(context, context.getElementType(), elementPath, rules);
        }
        if (value.isDone()) {
            if (value.hasError()) {
                result.error(value.getError());
            } else {
                result.unblockSuccess(new Pair(value.getResult(), Boolean.TRUE));
            }
        } else {
            value.onDone(obj -> result.unblockSuccess(new Pair<Object, Boolean>(obj, Boolean.TRUE)), result);
        }
    }

    @Override
    protected AsyncSupplier<IO.Readable, SerializationException> deserializeIOReadableValue(SerializationContext context, List<SerializationRule> rules) {
        XMLStreamEvents.Attribute a = this.input.getAttributeWithNamespaceURI("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (a != null && a.value.equals("true")) {
            return new AsyncSupplier<Object, Object>(null, null);
        }
        Async<Exception> next = this.input.next();
        AsyncSupplier<IO.Readable, SerializationException> result = new AsyncSupplier<IO.Readable, SerializationException>();
        next.thenStart(new AbstractDeserializer.DeserializationTask(() -> {
            if (XMLStreamEvents.Event.Type.TEXT.equals((Object)this.input.event.type)) {
                String ref = this.input.event.text.asString();
                for (Deserializer.StreamReferenceHandler h : this.streamReferenceHandlers) {
                    if (!h.isReference(ref)) continue;
                    h.getStreamFromReference(ref).forward(result);
                    return;
                }
            }
            IOInMemoryOrFile io = new IOInMemoryOrFile(131072, this.priority, "base 64 encoded from XML");
            AsyncConsumer<Bytes.Readable, IOException> decoder = Base64Encoding.instance.createDecoderConsumer(io.createConsumer(() -> io.seekAsync(IO.Seekable.SeekType.FROM_BEGINNING, 0L).onDone(() -> result.unblockSuccess(io), result, xmlErrorConverter::apply), err -> result.error((SerializationException)((Exception)xmlErrorConverter.apply((Exception)err)))).convert(Bytes::toByteBuffer), err -> new IOException("Base 64 encoding error in XML", (Throwable)err));
            this.readBase64(decoder, io, result);
        }), result, xmlErrorConverter);
        return result;
    }

    private void readNextBase64(AsyncConsumer<Bytes.Readable, IOException> decoder, IOInMemoryOrFile io, AsyncSupplier<IO.Readable, SerializationException> result) {
        Async<Exception> next = this.input.next();
        if (next.isDone()) {
            if (next.hasError()) {
                result.error((SerializationException)((Exception)xmlErrorConverter.apply((Exception)next.getError())));
            } else {
                this.readBase64(decoder, io, result);
            }
            return;
        }
        next.thenStart(new AbstractDeserializer.DeserializationTask(() -> this.readBase64(decoder, io, result)), result, xmlErrorConverter);
    }

    private void readBase64(AsyncConsumer<Bytes.Readable, IOException> decoder, IOInMemoryOrFile io, AsyncSupplier<IO.Readable, SerializationException> result) {
        if (XMLStreamEvents.Event.Type.TEXT.equals((Object)this.input.event.type)) {
            this.input.event.text.trim();
            if (this.input.event.text.isEmpty()) {
                this.readNextBase64(decoder, io, result);
                return;
            }
            CharArray[] buffers = this.input.event.text.asCharBuffers();
            this.decodeBase64(decoder, io, result, buffers, 0);
            return;
        }
        if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.input.event.type)) {
            this.input.closeElement().thenStart(new AbstractDeserializer.DeserializationTask(() -> this.readNextBase64(decoder, io, result)), result, xmlErrorConverter);
            return;
        }
        if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.input.event.type)) {
            decoder.end();
            return;
        }
        this.readNextBase64(decoder, io, result);
    }

    private void decodeBase64(AsyncConsumer<Bytes.Readable, IOException> decoder, IOInMemoryOrFile io, AsyncSupplier<IO.Readable, SerializationException> result, CharArray[] buffers, int index) {
        IAsync<IOException> decode = decoder.consume(new BytesFromIso8859CharArray(buffers[index], true));
        decode.thenStart(new AbstractDeserializer.DeserializationTask(() -> {
            if (decode.hasError()) {
                result.error(new SerializationException("Error decoding base 64", (Throwable)decode.getError()));
            } else if (index == buffers.length - 1) {
                this.readNextBase64(decoder, io, result);
            } else {
                this.decodeBase64(decoder, io, result, buffers, index + 1);
            }
        }), true);
    }

    @Override
    protected AsyncSupplier<IO.Readable, SerializationException> deserializeIOReadableAttributeValue(SerializationContext.AttributeContext context, List<SerializationRule> rules) {
        return this.deserializeIOReadableValue(context, rules);
    }

    @Override
    protected AsyncSupplier<?, SerializationException> deserializeObjectAttributeValue(SerializationContext.AttributeContext context, String path, List<SerializationRule> rules) {
        XMLCustomSerialization custom = context.getAttribute().getAnnotation(false, XMLCustomSerialization.class);
        if (custom != null) {
            try {
                XMLCustomSerializer s = custom.value().newInstance();
                if (s.type().equals(context.getAttribute().getType())) {
                    return s.deserialize(this, this.input, rules);
                }
            }
            catch (Exception e) {
                return new AsyncSupplier<Object, SerializationException>(null, new SerializationException("Error instantiating custom type", e));
            }
        }
        return super.deserializeObjectAttributeValue(context, path, rules);
    }

    private AsyncSupplier<Boolean, Exception> nextInnerElement(XMLStreamEvents.ElementContext parent) {
        if (this.input.event.context.isEmpty() || XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.input.event.type) && this.input.event.context.getFirst() == parent && this.input.event.isClosed || XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.input.event.type) && this.input.event.context.getFirst() == parent) {
            return new AsyncSupplier<Boolean, Object>(Boolean.FALSE, null);
        }
        Async<Exception> next = this.input.next();
        while (next.isDone()) {
            if (next.hasError()) {
                return new AsyncSupplier(null, next.getError());
            }
            if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.input.event.type)) {
                if (this.input.event.context.getFirst() == parent) {
                    return new AsyncSupplier<Boolean, Object>(Boolean.FALSE, null);
                }
            } else {
                if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.input.event.type) && this.input.event.context.size() > 1 && this.input.event.context.get(1) == parent) {
                    return new AsyncSupplier<Boolean, Object>(Boolean.TRUE, null);
                }
                if (XMLStreamEvents.Event.Type.TEXT.equals((Object)this.input.event.type)) {
                    if (!this.input.event.text.trim().isEmpty()) {
                        return new AsyncSupplier<Object, SerializationException>(null, new SerializationException("Unexpected text: " + this.input.event.text));
                    }
                } else if (!XMLStreamEvents.Event.Type.COMMENT.equals((Object)this.input.event.type)) {
                    return new AsyncSupplier<Object, SerializationException>(null, new SerializationException("Unexpected XML " + (Object)((Object)this.input.event.type)));
                }
            }
            next = this.input.next();
        }
        AsyncSupplier<Boolean, Exception> result = new AsyncSupplier<Boolean, Exception>();
        Async<Exception> n = next;
        next.onDone(() -> {
            if (n.hasError()) {
                result.error((Exception)n.getError());
            } else if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.input.event.type) && this.input.event.context.getFirst() == parent) {
                result.unblockSuccess(Boolean.FALSE);
            } else if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.input.event.type) && this.input.event.context.size() > 1 && this.input.event.context.get(1) == parent) {
                result.unblockSuccess(Boolean.TRUE);
            } else if (XMLStreamEvents.Event.Type.TEXT.equals((Object)this.input.event.type)) {
                if (!this.input.event.text.trim().isEmpty()) {
                    result.error(new SerializationException("Unexpected text: " + this.input.event.text));
                } else {
                    new AbstractDeserializer.DeserializationTask(() -> this.nextInnerElement(parent).forward(result)).start();
                }
            } else if (XMLStreamEvents.Event.Type.COMMENT.equals((Object)this.input.event.type)) {
                new AbstractDeserializer.DeserializationTask(() -> this.nextInnerElement(parent).forward(result)).start();
            } else {
                result.error(new SerializationException("Unexpected XML " + (Object)((Object)this.input.event.type)));
            }
        }, result);
        return result;
    }

    private static class XMLObjectContext {
        private XMLStreamEvents.ElementContext element;
        private int attributeIndex = 0;
        private List<XMLStreamEvents.Attribute> attributes;
        private boolean endOfAttributes = false;
        private boolean onNextAttribute = false;
        private List<String> attributesDone = new LinkedList<String>();

        private XMLObjectContext() {
        }
    }

    private static class CollectionValueContext {
        private XMLStreamEvents.ElementContext parent;

        private CollectionValueContext() {
        }
    }
}

