/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml.serialization;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.encoding.Base64Encoding;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.SimpleBufferedWritable;
import net.lecousin.framework.io.data.ByteArray;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.io.serialization.AbstractSerializer;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationException;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.text.ByteArrayStringIso8859;
import net.lecousin.framework.text.CharArrayString;
import net.lecousin.framework.xml.XMLWriter;
import net.lecousin.framework.xml.serialization.XMLCustomSerialization;
import net.lecousin.framework.xml.serialization.XMLDeserializer;

public class XMLSerializer
extends AbstractSerializer {
    protected String rootNamespaceURI;
    protected String rootLocalName;
    protected Map<String, String> namespaces;
    protected Charset encoding;
    protected int bufferSize;
    protected boolean includeXMLDeclaration;
    protected IO.Writable.Buffered bout;
    protected XMLWriter output;
    protected boolean pretty = false;
    private static Function<IOException, SerializationException> ioErrorConverter = e -> new SerializationException("Error writing XML", (Throwable)e);
    protected static final Comparator<SerializationClass.Attribute> attributesComparator = (o1, o2) -> {
        Class<?> c = o1.getType().getBase();
        if (c.isPrimitive()) {
            return -1;
        }
        if (Boolean.class.equals(c)) {
            return -1;
        }
        if (Number.class.isAssignableFrom(c)) {
            return -1;
        }
        if (CharSequence.class.isAssignableFrom(c)) {
            return -1;
        }
        if (Character.class.equals(c)) {
            return -1;
        }
        if (c.isEnum()) {
            return -1;
        }
        c = o2.getType().getBase();
        if (c.isPrimitive()) {
            return 1;
        }
        if (Boolean.class.equals(c)) {
            return 1;
        }
        if (Number.class.isAssignableFrom(c)) {
            return 1;
        }
        if (CharSequence.class.isAssignableFrom(c)) {
            return 1;
        }
        if (Character.class.equals(c)) {
            return 1;
        }
        if (c.isEnum()) {
            return 1;
        }
        return 0;
    };

    public XMLSerializer(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces) {
        this(rootNamespaceURI, rootLocalName, namespaces, null);
    }

    public XMLSerializer(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, boolean includeXMLDeclaration) {
        this(rootNamespaceURI, rootLocalName, namespaces, null, includeXMLDeclaration);
    }

    public XMLSerializer(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, Charset encoding) {
        this(rootNamespaceURI, rootLocalName, namespaces, encoding, 4096);
    }

    public XMLSerializer(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, Charset encoding, boolean includeXMLDeclaration) {
        this(rootNamespaceURI, rootLocalName, namespaces, encoding, 4096, includeXMLDeclaration);
    }

    public XMLSerializer(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, Charset encoding, int bufferSize) {
        this(rootNamespaceURI, rootLocalName, namespaces, encoding, bufferSize, true);
    }

    public XMLSerializer(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, Charset encoding, int bufferSize, boolean includeXMLDeclaration) {
        this.rootNamespaceURI = rootNamespaceURI;
        this.rootLocalName = rootLocalName;
        this.namespaces = namespaces;
        this.encoding = encoding;
        this.bufferSize = bufferSize;
        this.includeXMLDeclaration = includeXMLDeclaration;
    }

    public XMLSerializer(XMLWriter writer) {
        this.output = writer;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    @Override
    protected IAsync<SerializationException> initializeSerialization(IO.Writable output) {
        this.bout = output instanceof IO.Writable.Buffered ? (IO.Writable.Buffered)output : new SimpleBufferedWritable(output, this.bufferSize);
        this.output = new XMLWriter(this.bout, this.encoding, this.includeXMLDeclaration, this.pretty);
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, String>();
        }
        if (!this.namespaces.containsKey("http://www.w3.org/2001/XMLSchema-instance")) {
            this.namespaces.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        }
        return new Async<SerializationException>(this.output.start(this.rootNamespaceURI, this.rootLocalName, this.namespaces), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> finalizeSerialization() {
        Async<SerializationException> sp = new Async<SerializationException>();
        this.output.end().onDone(() -> this.bout.flush().onDone(sp, ioErrorConverter), sp, ioErrorConverter);
        return sp;
    }

    @Override
    protected IAsync<SerializationException> serializeBooleanValue(boolean value) {
        return new Async<SerializationException>(this.output.addText(Boolean.toString(value)), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> serializeNullValue() {
        return new Async<SerializationException>(this.output.addAttribute("xsi:nil", "true"), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> serializeCharacterValue(char value) {
        return new Async<SerializationException>(this.output.addText(new String(new char[]{value})), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> serializeNumericValue(Number value) {
        return new Async<SerializationException>(this.output.addText(value.toString()), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> serializeStringValue(CharSequence value) {
        return new Async<SerializationException>(this.output.addText(value), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> startCollectionValue(SerializationContext.CollectionContext context, String path, List<SerializationRule> rules) {
        return new Async<SerializationException>(this.output.endOfAttributes(), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> startCollectionValueElement(SerializationContext.CollectionContext context, Object element, int elementIndex, String elementPath, List<SerializationRule> rules) {
        return new Async<SerializationException>(this.output.openElement(null, "element", null), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> endCollectionValueElement(SerializationContext.CollectionContext context, Object element, int elementIndex, String elementPath, List<SerializationRule> rules) {
        return new Async<SerializationException>(this.output.closeElement(), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> endCollectionValue(SerializationContext.CollectionContext context, String path, List<SerializationRule> rules) {
        return new Async<boolean>(true);
    }

    @Override
    protected List<SerializationClass.Attribute> sortAttributes(List<SerializationClass.Attribute> attributes) {
        attributes.sort(attributesComparator);
        return attributes;
    }

    @Override
    protected IAsync<SerializationException> startObjectValue(SerializationContext.ObjectContext context, String path, List<SerializationRule> rules) {
        Object instance = context.getInstance();
        if (instance != null) {
            Class<?> type;
            boolean customInstantiator = false;
            for (SerializationRule rule : rules) {
                if (!rule.canInstantiate(context.getOriginalType(), context)) continue;
                customInstantiator = true;
                break;
            }
            if (!(customInstantiator || context.getParent() instanceof SerializationContext.AttributeContext && ((SerializationContext.AttributeContext)context.getParent()).getAttribute().hasCustomInstantiation() || (type = context.getOriginalType().getBase()).equals(instance.getClass()))) {
                String attrName = "class";
                while (XMLDeserializer.hasAttribute(type, attrName)) {
                    attrName = "_" + attrName;
                }
                return new Async<SerializationException>(this.output.addAttribute(attrName, instance.getClass().getName()), ioErrorConverter);
            }
        }
        return new Async<boolean>(true);
    }

    @Override
    protected IAsync<SerializationException> endObjectValue(SerializationContext.ObjectContext context, String path, List<SerializationRule> rules) {
        return new Async<boolean>(true);
    }

    @Override
    protected IAsync<SerializationException> serializeNullAttribute(SerializationContext.AttributeContext context, String path) {
        Class<?> c = context.getAttribute().getType().getBase();
        if (c.isPrimitive() || Boolean.class.equals(c) || Number.class.isAssignableFrom(c) || CharSequence.class.isAssignableFrom(c) || Character.class.equals(c) || c.isEnum()) {
            return new Async<boolean>(true);
        }
        this.output.openElement(null, context.getAttribute().getName(), null);
        this.output.addAttribute("xsi:nil", "true");
        return new Async<SerializationException>(this.output.closeElement(), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> serializeBooleanAttribute(SerializationContext.AttributeContext context, boolean value, String path) {
        return new Async<SerializationException>(this.output.addAttribute(context.getAttribute().getName(), Boolean.toString(value)), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> serializeNumericAttribute(SerializationContext.AttributeContext context, Number value, String path) {
        return new Async<SerializationException>(this.output.addAttribute(context.getAttribute().getName(), value.toString()), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> serializeCharacterAttribute(SerializationContext.AttributeContext context, char value, String path) {
        return new Async<SerializationException>(this.output.addAttribute(context.getAttribute().getName(), new CharArrayString(value)), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> serializeStringAttribute(SerializationContext.AttributeContext context, CharSequence value, String path) {
        return new Async<SerializationException>(this.output.addAttribute(context.getAttribute().getName(), value), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> serializeObjectAttribute(SerializationContext.AttributeContext context, Object value, String path, List<SerializationRule> rules) {
        this.output.openElement(null, context.getAttribute().getName(), null);
        IAsync<SerializationException> s = this.serializeObjectValue(context, value, context.getAttribute().getType(), path + '.' + context.getAttribute().getName(), rules);
        if (s.isDone()) {
            if (s.hasError()) {
                return s;
            }
            return new Async<SerializationException>(this.output.closeElement(), ioErrorConverter);
        }
        Async<SerializationException> sp = new Async<SerializationException>();
        s.thenStart(new AbstractSerializer.SerializationTask(this, () -> this.output.closeElement().onDone(sp, ioErrorConverter)), sp);
        return sp;
    }

    @Override
    protected IAsync<SerializationException> serializeCollectionAttribute(SerializationContext.CollectionContext context, String path, List<SerializationRule> rules) {
        Async<SerializationException> result = new Async<SerializationException>();
        this.serializeCollectionAttributeElement(context, context.getIterator(), 0, path + '.' + ((SerializationContext.AttributeContext)context.getParent()).getAttribute().getName(), rules, result);
        return result;
    }

    protected void serializeCollectionAttributeElement(SerializationContext.CollectionContext context, Iterator<?> it, int elementIndex, String colPath, List<SerializationRule> rules, Async<SerializationException> result) {
        if (!it.hasNext()) {
            result.unblock();
            return;
        }
        Object element = it.next();
        String elementPath = colPath + '[' + elementIndex + ']';
        SerializationClass.Attribute colAttr = ((SerializationContext.AttributeContext)context.getParent()).getAttribute();
        this.output.openElement(null, colAttr.getName(), null);
        IAsync<SerializationException> value = this.serializeValue(context, element, context.getElementType(), elementPath, rules);
        if (value.isDone()) {
            if (value.hasError()) {
                result.error(value.getError());
            } else {
                this.output.closeElement();
                this.serializeCollectionAttributeElement(context, it, elementIndex + 1, colPath, rules, result);
            }
            return;
        }
        value.thenStart(new AbstractSerializer.SerializationTask(this, () -> {
            this.output.closeElement();
            this.serializeCollectionAttributeElement(context, it, elementIndex + 1, colPath, rules, result);
        }), result);
    }

    @Override
    protected IAsync<SerializationException> serializeIOReadableValue(SerializationContext context, IO.Readable io, String path, List<SerializationRule> rules) {
        Async<IOException> encode = io.createProducer(false).toConsumer(Base64Encoding.instance.createEncoderConsumer(ByteArrayStringIso8859.bytesConsumer(str -> this.output.addEscapedText((CharSequence)str)).convert(Bytes::toByteBuffer)).convert(ByteArray::fromByteBuffer), "Serialize IO.Readable to XML", this.priority);
        if (encode.isDone()) {
            if (encode.hasError()) {
                return new Async<SerializationException>(encode, ioErrorConverter);
            }
            return new Async<SerializationException>(this.output.closeElement(), ioErrorConverter);
        }
        Async<SerializationException> sp = new Async<SerializationException>();
        encode.thenStart(new AbstractSerializer.SerializationTask(this, () -> this.output.closeElement().onDone(sp, ioErrorConverter)), sp, ioErrorConverter);
        return sp;
    }

    @Override
    protected IAsync<SerializationException> serializeIOReadableAttribute(SerializationContext.AttributeContext context, IO.Readable io, String path, List<SerializationRule> rules) {
        this.output.openElement(null, context.getAttribute().getName(), null);
        return this.serializeIOReadableValue(context, io, path, rules);
    }

    @Override
    protected IAsync<SerializationException> serializeAttribute(SerializationContext.AttributeContext context, String path, List<SerializationRule> rules) {
        Object value;
        XMLCustomSerialization custom = context.getAttribute().getAnnotation(false, XMLCustomSerialization.class);
        if (custom == null) {
            return super.serializeAttribute(context, path, rules);
        }
        try {
            value = context.getAttribute().getValue(context.getParent().getInstance());
        }
        catch (Exception e) {
            return new Async<SerializationException>(new SerializationException("Unable to get value of attribute " + context.getAttribute().getOriginalName() + " on " + context.getAttribute().getOriginalType().getClass().getName(), e));
        }
        if (value == null) {
            return this.serializeNullAttribute(context, path);
        }
        try {
            return custom.value().newInstance().serialize(value, this, this.output, rules);
        }
        catch (Exception e) {
            return new Async<SerializationException>(new SerializationException("Error instantiating type", e));
        }
    }
}

