/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml.serialization;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.SimpleBufferedWritable;
import net.lecousin.framework.io.serialization.AbstractSerializationSpecWriter;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationException;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.xml.XMLWriter;

public class XMLSpecWriter
extends AbstractSerializationSpecWriter {
    protected String rootNamespaceURI;
    protected String rootLocalName;
    protected Map<String, String> namespaces;
    protected Charset encoding;
    protected int bufferSize;
    protected boolean includeXMLDeclaration;
    protected IO.Writable.Buffered bout;
    protected XMLWriter output;
    protected boolean pretty;
    private static Function<IOException, SerializationException> ioErrorConverter = e -> new SerializationException("Error writing XSD", (Throwable)e);
    private static final String TYPE = "type";
    private static final String TYPE_BOOLEAN = "xsd:boolean";
    private static final String TYPE_BYTE = "xsd:byte";
    private static final String TYPE_INT = "xsd:int";
    private static final String TYPE_INTEGER = "xsd:integer";
    private static final String TYPE_LONG = "xsd:long";
    private static final String TYPE_FLOAT = "xsd:float";
    private static final String TYPE_DOUBLE = "xsd:double";
    private static final String TYPE_DECIMAL = "xsd:decimal";
    private static final String TYPE_STRING = "xsd:string";
    private static final String NILLABLE = "nillable";
    private static final String TRUE = "true";
    private static final String USE = "use";
    private static final String OPTIONAL = "optional";
    private static final String MIN_OCCURS = "minOccurs";
    private static final String MAX_OCCURS = "maxOccurs";
    private static final String UNBOUNDED = "unbounded";
    private static final String COMPLEX_TYPE = "complexType";
    private static final String SEQUENCE = "sequence";
    private static final String ELEMENT = "element";
    private static final String ATTRIBUTE = "attribute";
    private LinkedList<TypeContext> typesContext = new LinkedList();
    protected static final Comparator<SerializationClass.Attribute> attributesComparator = (o1, o2) -> {
        Class<?> c = o1.getType().getBase();
        if (XMLSpecWriter.isAttribute(c)) {
            return 1;
        }
        c = o2.getType().getBase();
        if (XMLSpecWriter.isAttribute(c)) {
            return -1;
        }
        return 0;
    };

    public XMLSpecWriter(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces) {
        this(rootNamespaceURI, rootLocalName, namespaces, StandardCharsets.UTF_8, true);
    }

    public XMLSpecWriter(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, boolean includeXMLDeclaration) {
        this(rootNamespaceURI, rootLocalName, namespaces, StandardCharsets.UTF_8, includeXMLDeclaration);
    }

    public XMLSpecWriter(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, Charset encoding) {
        this(rootNamespaceURI, rootLocalName, namespaces, encoding, 4096, true);
    }

    public XMLSpecWriter(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, Charset encoding, boolean includeXMLDeclaration) {
        this(rootNamespaceURI, rootLocalName, namespaces, encoding, 4096, includeXMLDeclaration);
    }

    public XMLSpecWriter(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, Charset encoding, int bufferSize) {
        this(rootNamespaceURI, rootLocalName, namespaces, encoding, bufferSize, true);
    }

    public XMLSpecWriter(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces, Charset encoding, int bufferSize, boolean includeXMLDeclaration) {
        this.rootNamespaceURI = rootNamespaceURI;
        this.rootLocalName = rootLocalName;
        this.namespaces = namespaces;
        this.encoding = encoding;
        this.bufferSize = bufferSize;
        this.includeXMLDeclaration = includeXMLDeclaration;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    @Override
    protected IAsync<SerializationException> initializeSpecWriter(IO.Writable output) {
        this.bout = output instanceof IO.Writable.Buffered ? (IO.Writable.Buffered)output : new SimpleBufferedWritable(output, this.bufferSize);
        this.output = new XMLWriter(this.bout, this.encoding, this.includeXMLDeclaration, this.pretty);
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, String>();
        }
        if (!this.namespaces.containsKey("http://www.w3.org/2001/XMLSchema-instance")) {
            this.namespaces.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        }
        if (!this.namespaces.containsKey("http://www.w3.org/2001/XMLSchema")) {
            this.namespaces.put("http://www.w3.org/2001/XMLSchema", "xsd");
        }
        this.output.start("http://www.w3.org/2001/XMLSchema", "schema", this.namespaces);
        if (this.rootNamespaceURI != null) {
            this.output.addAttribute("targetNamespace", this.rootNamespaceURI);
        }
        this.output.openElement("http://www.w3.org/2001/XMLSchema", ELEMENT, null);
        return new Async<SerializationException>(this.output.addAttribute("name", this.rootLocalName), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> finalizeSpecWriter() {
        Async<SerializationException> sp = new Async<SerializationException>();
        this.output.end().onDone(() -> this.bout.flush().onDone(sp, ioErrorConverter), sp, ioErrorConverter);
        return sp;
    }

    private void addNullable(SerializationContext context) {
        if (context instanceof SerializationContext.AttributeContext) {
            this.output.addAttribute(USE, OPTIONAL);
        } else {
            this.output.addAttribute(NILLABLE, TRUE);
        }
    }

    private void addMinMax(SerializationContext context) {
        if (context instanceof SerializationContext.CollectionContext) {
            this.output.addAttribute(MIN_OCCURS, "0");
            this.output.addAttribute(MAX_OCCURS, UNBOUNDED);
        }
    }

    @Override
    protected IAsync<SerializationException> specifyBooleanValue(SerializationContext context, boolean nullable) {
        this.output.addAttribute(TYPE, TYPE_BOOLEAN);
        if (nullable) {
            this.addNullable(context);
        }
        this.addMinMax(context);
        return new Async<SerializationException>(this.output.closeElement(), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> specifyNumericValue(SerializationContext context, Class<?> type, boolean nullable, Number min, Number max) {
        if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            this.output.addAttribute(TYPE, TYPE_BYTE);
        } else if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            this.output.addAttribute(TYPE, TYPE_INT);
        } else if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            this.output.addAttribute(TYPE, TYPE_LONG);
        } else if (Short.TYPE.equals(type) || Short.class.equals(type) || BigInteger.class.equals(type)) {
            this.output.addAttribute(TYPE, TYPE_INTEGER);
        } else if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            this.output.addAttribute(TYPE, TYPE_FLOAT);
        } else if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            this.output.addAttribute(TYPE, TYPE_DOUBLE);
        } else {
            this.output.addAttribute(TYPE, TYPE_DECIMAL);
        }
        if (nullable) {
            this.addNullable(context);
        }
        this.addMinMax(context);
        return new Async<SerializationException>(this.output.closeElement(), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> specifyStringValue(SerializationContext context, TypeDefinition type) {
        this.output.addAttribute(TYPE, TYPE_STRING);
        this.addNullable(context);
        this.addMinMax(context);
        return new Async<SerializationException>(this.output.closeElement(), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> specifyCharacterValue(SerializationContext context, boolean nullable) {
        if (nullable) {
            this.addNullable(context);
        }
        this.addMinMax(context);
        this.output.openElement("http://www.w3.org/2001/XMLSchema", "simpleType", null);
        this.output.openElement("http://www.w3.org/2001/XMLSchema", "restriction", null);
        this.output.addAttribute("base", TYPE_STRING);
        this.output.openElement("http://www.w3.org/2001/XMLSchema", "length", null);
        this.output.addAttribute("value", "1");
        this.output.closeElement();
        this.output.closeElement();
        this.output.closeElement();
        return new Async<SerializationException>(this.output.closeElement(), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> specifyEnumValue(SerializationContext context, TypeDefinition type) {
        this.addNullable(context);
        this.addMinMax(context);
        this.output.openElement("http://www.w3.org/2001/XMLSchema", "simpleType", null);
        this.output.openElement("http://www.w3.org/2001/XMLSchema", "restriction", null);
        this.output.addAttribute("base", TYPE_STRING);
        try {
            Enum[] values = (Enum[])type.getBase().getMethod("values", new Class[0]).invoke(null, new Object[0]);
            for (int i = 0; i < values.length; ++i) {
                this.output.openElement("http://www.w3.org/2001/XMLSchema", "enumeration", null);
                this.output.addAttribute("value", values[i].name());
                this.output.closeElement();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.output.closeElement();
        this.output.closeElement();
        return new Async<SerializationException>(this.output.closeElement(), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> specifyCollectionValue(SerializationContext.CollectionContext context, List<SerializationRule> rules) {
        if (context.getParent() instanceof SerializationContext.AttributeContext) {
            return this.specifyValue(context, context.getElementType(), rules);
        }
        this.output.addAttribute(NILLABLE, TRUE);
        this.addMinMax(context.getParent());
        this.output.endOfAttributes();
        this.output.openElement("http://www.w3.org/2001/XMLSchema", COMPLEX_TYPE, null);
        this.output.openElement("http://www.w3.org/2001/XMLSchema", SEQUENCE, null);
        this.output.openElement("http://www.w3.org/2001/XMLSchema", ELEMENT, null);
        this.output.addAttribute("name", ELEMENT);
        IAsync<SerializationException> val = this.specifyValue(context, context.getElementType(), rules);
        if (val.isDone()) {
            if (val.hasError()) {
                return val;
            }
            this.output.closeElement();
            this.output.closeElement();
            return new Async<SerializationException>(this.output.closeElement(), ioErrorConverter);
        }
        Async<SerializationException> sp = new Async<SerializationException>();
        val.thenStart(new AbstractSerializationSpecWriter.SpecTask(() -> {
            this.output.closeElement();
            this.output.closeElement();
            this.output.closeElement().onDone(sp, ioErrorConverter);
        }), sp);
        return sp;
    }

    @Override
    protected IAsync<SerializationException> specifyIOReadableValue(SerializationContext context, List<SerializationRule> rules) {
        this.output.addAttribute(TYPE, "xsd:base64Binary");
        this.output.addAttribute(NILLABLE, TRUE);
        return new Async<SerializationException>(this.output.closeElement(), ioErrorConverter);
    }

    public static String getTypeName(Class<?> type) {
        return type.getName().replace('$', '-');
    }

    @Override
    protected IAsync<SerializationException> specifyAnyValue(SerializationContext context) {
        this.addMinMax(context);
        this.output.endOfAttributes();
        this.output.openElement("http://www.w3.org/2001/XMLSchema", COMPLEX_TYPE, null);
        this.output.openElement("http://www.w3.org/2001/XMLSchema", SEQUENCE, null);
        this.output.openElement("http://www.w3.org/2001/XMLSchema", "any", null);
        this.output.addAttribute(MIN_OCCURS, "0");
        this.output.closeElement();
        this.output.closeElement();
        this.output.closeElement();
        return new Async<SerializationException>(this.output.closeElement(), ioErrorConverter);
    }

    @Override
    protected IAsync<SerializationException> specifyTypedValue(SerializationContext.ObjectContext context, List<SerializationRule> rules) {
        this.addMinMax(context.getParent());
        this.output.addAttribute(NILLABLE, TRUE);
        this.output.endOfAttributes();
        this.output.openElement("http://www.w3.org/2001/XMLSchema", COMPLEX_TYPE, null);
        TypeContext ctx = new TypeContext();
        this.typesContext.addFirst(ctx);
        IAsync<SerializationException> type = this.specifyTypeContent(context, rules);
        if (type.isDone()) {
            if (type.hasError()) {
                return type;
            }
            this.typesContext.removeFirst();
            if (ctx.sequenceStarted) {
                this.output.closeElement();
            }
            this.output.closeElement();
            return new Async<SerializationException>(this.output.closeElement(), ioErrorConverter);
        }
        Async<SerializationException> sp = new Async<SerializationException>();
        type.thenStart(new AbstractSerializationSpecWriter.SpecTask(() -> {
            this.typesContext.removeFirst();
            if (ctx.sequenceStarted) {
                this.output.closeElement();
            }
            this.output.closeElement();
            this.output.closeElement().onDone(sp, ioErrorConverter);
        }), sp);
        return sp;
    }

    protected static final boolean isAttribute(Class<?> c) {
        return c.isPrimitive() || Boolean.class.equals(c) || Number.class.isAssignableFrom(c) || CharSequence.class.isAssignableFrom(c) || Character.class.equals(c) || c.isEnum();
    }

    @Override
    protected List<SerializationClass.Attribute> sortAttributes(List<SerializationClass.Attribute> attributes) {
        attributes.sort(attributesComparator);
        return attributes;
    }

    @Override
    protected IAsync<SerializationException> specifyTypeAttribute(SerializationContext.AttributeContext context, List<SerializationRule> rules) {
        SerializationClass.Attribute a = context.getAttribute();
        Class<?> type = a.getType().getBase();
        TypeContext ctx = this.typesContext.getFirst();
        if (XMLSpecWriter.isAttribute(type)) {
            if (ctx.sequenceStarted) {
                this.output.closeElement();
                ctx.sequenceStarted = false;
            }
            this.output.openElement("http://www.w3.org/2001/XMLSchema", ATTRIBUTE, null);
            this.output.addAttribute("name", a.getName());
            return this.specifyValue(context, a.getType(), rules);
        }
        if (!ctx.sequenceStarted) {
            this.output.openElement("http://www.w3.org/2001/XMLSchema", SEQUENCE, null);
            ctx.sequenceStarted = true;
        }
        this.output.openElement("http://www.w3.org/2001/XMLSchema", ELEMENT, null);
        this.output.addAttribute("name", a.getName());
        return this.specifyValue(context, a.getType(), rules);
    }

    private static class TypeContext {
        private boolean sequenceStarted = false;

        private TypeContext() {
        }
    }
}

