/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.launcher;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Executors;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.ApplicationBootstrapException;
import net.lecousin.framework.application.ApplicationConfiguration;
import net.lecousin.framework.application.Artifact;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.application.SplashScreen;
import net.lecousin.framework.application.Version;
import net.lecousin.framework.application.launcher.DynamicLibrariesManager;
import net.lecousin.framework.application.launcher.LauncherService;
import net.lecousin.framework.application.libraries.LibrariesManager;
import net.lecousin.framework.application.libraries.artifacts.LibrariesRepository;
import net.lecousin.framework.application.libraries.artifacts.LibraryDescriptorLoader;
import net.lecousin.framework.collections.CollectionsUtil;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.util.CommandLine;
import net.lecousin.framework.util.Triple;

public class Launcher {
    private static SplashScreen createSplashScreen() {
        if (!GraphicsEnvironment.isHeadless() && !"true".equals(System.getProperty("nosplash"))) {
            return new SplashScreen(true);
        }
        return null;
    }

    private static boolean checkCommandLineContext(CommandLineContext context, List<LauncherService> services) {
        LinkedList<String> errors = new LinkedList<String>();
        Launcher.checkPresent(context.groupId, "groupId", errors);
        Launcher.checkPresent(context.artifactId, "artifactId", errors);
        Launcher.checkPresent(context.version, "version", errors);
        ArrayList<LauncherService> allServices = new ArrayList<LauncherService>(services);
        Iterator<LauncherService> it = services.iterator();
        while (it.hasNext()) {
            if (it.next().checkCommandLineContext(context, errors)) continue;
            it.remove();
        }
        if (errors.isEmpty()) {
            return true;
        }
        for (String e : errors) {
            System.err.println(e);
        }
        Launcher.printUsage(allServices);
        LCCore.stop(true);
        return false;
    }

    public static void checkPresent(String s, String optionName, List<String> errors) {
        if (s == null || s.trim().isEmpty()) {
            errors.add("Missing option " + optionName + " in command line");
        }
    }

    private static void printUsage(List<LauncherService> services) {
        System.out.println("Options:");
        System.out.println(" -groupId=<app groupId>            Mandatory: groupId of the application");
        System.out.println(" -artifactId=<app artifactId>      Mandatory: artifactId of the application");
        System.out.println(" -version=<app version>            Mandatory: application's artifact version");
        System.out.println("[-plugins=<plugins>]               Plug-in artifacts to load separated by a");
        System.out.println("                                   semi-colon in the following format:");
        System.out.println("                                   groupId[:artifactId[:version]]");
        System.out.println("[-config=<path>]                   Path to the project.xml file. If not");
        System.out.println("                                   specified it is searched automatically");
        for (LauncherService service : services) {
            service.printOptionsUsage();
        }
        System.out.println("[-parameters <...>]                all following parameters are passed to the");
        System.out.println("                                   application");
    }

    private static CommandLineContext parseCommandLine(String[] args, List<LauncherService> services) {
        try {
            CommandLineContext cmdContext = new CommandLineContext();
            LinkedList<CommandLine.ArgumentsConsumer<CommandLineContext>> consumers = new LinkedList<CommandLine.ArgumentsConsumer<CommandLineContext>>();
            consumers.add(new CommandLineContext.GroupIdConsumer());
            consumers.add(new CommandLineContext.ArtifactIdConsumer());
            consumers.add(new CommandLineContext.VersionConsumer());
            consumers.add(new CommandLineContext.PluginsConsumer());
            consumers.add(new CommandLineContext.ConfigConsumer());
            for (LauncherService service : services) {
                service.addCommandLineArgumentsConsumers(consumers);
            }
            CommandLine.parse(args, cmdContext, new CommandLine.ArgumentsConsumer[][]{consumers.toArray(new CommandLine.ArgumentsConsumer[consumers.size()]), {new CommandLineContext.AppParametersConsumer()}});
            return cmdContext;
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            Launcher.printUsage(services);
            LCCore.stop(true);
            return null;
        }
    }

    private static File getConfigurationFile(CommandLineContext cmdContext) {
        File cfgFile = null;
        if (cmdContext.config != null) {
            cfgFile = new File(cmdContext.config);
            if (!cfgFile.exists() || !cfgFile.isFile()) {
                System.err.println("Configuration file does not exist");
                LCCore.stop(true);
                return null;
            }
        } else {
            LibrariesRepository repo;
            Iterator<LibrariesRepository> iterator = cmdContext.repositories.iterator();
            while (iterator.hasNext() && (cfgFile = (repo = iterator.next()).loadFileSync(cmdContext.groupId, cmdContext.artifactId, cmdContext.version, "lc-project", "xml")) == null) {
            }
            if (cfgFile == null) {
                System.err.println("Configuration file not found");
                LCCore.stop(true);
                return null;
            }
        }
        return cfgFile;
    }

    private static ApplicationConfiguration loadConfiguration(File cfgFile) {
        ApplicationConfiguration cfg;
        try {
            cfg = ApplicationConfiguration.load(cfgFile);
        }
        catch (Exception e) {
            System.err.println("Error reading configuration file " + cfgFile.getAbsolutePath());
            e.printStackTrace(System.err);
            LCCore.stop(true);
            return null;
        }
        return cfg;
    }

    private static void setupProperties(CommandLineContext cmdContext, ApplicationConfiguration cfg) {
        if (cfg.getProperties().get("net.lecousin.application.config.directory") == null && System.getProperty("net.lecousin.application.config.directory") == null) {
            cfg.getProperties().put("net.lecousin.application.config.directory", System.getProperty("user.home") + "/.lc.apps/" + cmdContext.groupId + "/" + cmdContext.artifactId + "/cfg");
        }
        if (cfg.getProperties().get("net.lecousin.application.log.directory") == null && System.getProperty("net.lecousin.application.log.directory") == null) {
            cfg.getProperties().put("net.lecousin.application.log.directory", System.getProperty("user.home") + "/.lc.apps/" + cmdContext.groupId + "/" + cmdContext.artifactId + "/log");
        }
    }

    private static List<Triple<String, String, String>> parsePlugins(String plugins) {
        LinkedList<Triple<String, String, String>> addPlugins = new LinkedList<Triple<String, String, String>>();
        if (plugins != null) {
            String[] list;
            for (String plugin : list = plugins.split(";")) {
                if ((plugin = plugin.trim()).isEmpty()) continue;
                int i = plugin.indexOf(58);
                if (i < 0) {
                    addPlugins.add(new Triple<String, Object, Object>(plugin, null, null));
                    continue;
                }
                String pluginGroupId = plugin.substring(0, i);
                if ((i = (plugin = plugin.substring(i + 1)).indexOf(58)) < 0) {
                    addPlugins.add(new Triple<String, String, Object>(pluginGroupId, plugin, null));
                    continue;
                }
                addPlugins.add(new Triple<String, String, String>(pluginGroupId, plugin.substring(0, i), plugin.substring(i + 1)));
            }
        }
        return addPlugins;
    }

    private static boolean startApplication(CommandLineContext cmdContext, ApplicationConfiguration cfg, boolean debugMode, LibrariesManager librariesManager) {
        IAsync<ApplicationBootstrapException> start = Application.start(new Artifact(cmdContext.groupId, cmdContext.artifactId, new Version(cmdContext.version)), cmdContext.appParameters, cfg.getProperties(), debugMode, Executors.defaultThreadFactory(), librariesManager, null);
        start.block(0L);
        if (start.hasError()) {
            start.getError().printStackTrace(System.err);
            LCCore.stop(true);
            return false;
        }
        if (start.isCancelled()) {
            start.getCancelEvent().printStackTrace(System.err);
            LCCore.stop(true);
            return false;
        }
        return true;
    }

    private static IAsync<Exception> launchApplication(DynamicLibrariesManager librariesManager) {
        Task<IAsync<Exception>, ApplicationBootstrapException> startApp = librariesManager.startApp();
        startApp.getOutput().block(0L);
        if (!startApp.isSuccessful()) {
            if (startApp.isCancelled()) {
                System.err.println("Application cancelled:");
                startApp.getCancelEvent().printStackTrace(System.err);
            } else {
                System.err.println("Error while starting application:");
                startApp.getOutput().getError().printStackTrace(System.err);
            }
            return null;
        }
        return startApp.getOutput().getResult();
    }

    private static void start(SplashScreen splash, String[] args) {
        DynamicLibrariesManager librariesManager;
        ApplicationConfiguration cfg;
        LinkedList<LauncherService> services = new LinkedList<LauncherService>();
        CollectionsUtil.addAll(services, ServiceLoader.load(LauncherService.class).iterator());
        CommandLineContext cmdContext = Launcher.parseCommandLine(args, services);
        if (cmdContext == null) {
            return;
        }
        if (!Launcher.checkCommandLineContext(cmdContext, services)) {
            return;
        }
        for (LauncherService service : services) {
            System.out.println("Activated launcher service: " + service.getClass().getSimpleName());
        }
        File cfgFile = Launcher.getConfigurationFile(cmdContext);
        if (cfgFile == null) {
            return;
        }
        if (splash != null) {
            splash.setText("Reading application configuration");
        }
        if ((cfg = Launcher.loadConfiguration(cfgFile)) == null) {
            return;
        }
        if (splash != null && cfg.getName() != null) {
            splash.setApplicationName(cfg.getName());
        }
        File appDir = cfgFile.getParentFile();
        if (splash != null) {
            splash.endInit();
        }
        Launcher.setupProperties(cmdContext, cfg);
        List<Triple<String, String, String>> addPlugins = Launcher.parsePlugins(cmdContext.plugins);
        LinkedList<File> searchProjectsPaths = new LinkedList<File>();
        boolean debugMode = false;
        for (LauncherService service : services) {
            service.getSearchProjectsPaths(cmdContext, searchProjectsPaths);
            debugMode |= service.activeDebugMode(cmdContext);
        }
        if (searchProjectsPaths.isEmpty()) {
            searchProjectsPaths = null;
        }
        if (!Launcher.startApplication(cmdContext, cfg, debugMode, librariesManager = new DynamicLibrariesManager(searchProjectsPaths, splash, cmdContext.loaders, appDir, cfg, addPlugins))) {
            return;
        }
        IAsync<Exception> appClosed = Launcher.launchApplication(librariesManager);
        if (appClosed != null) {
            appClosed.block(0L);
            if (appClosed.isCancelled()) {
                System.err.println("Application cancelled:");
                appClosed.getCancelEvent().printStackTrace(System.err);
            } else if (appClosed.hasError()) {
                System.err.println("Error while running application:");
                appClosed.getError().printStackTrace(System.err);
            }
        }
        LCCore.stop(true);
    }

    public static void main(String[] args) {
        SplashScreen splash = Launcher.createSplashScreen();
        LCCore.keepMainThread(() -> Launcher.start(splash, args));
    }

    public static class CommandLineContext {
        public String groupId;
        public String artifactId;
        public String version;
        public String plugins;
        public String config;
        public String[] appParameters = new String[0];
        public List<LibraryDescriptorLoader> loaders = new LinkedList<LibraryDescriptorLoader>();
        public List<LibrariesRepository> repositories = new LinkedList<LibrariesRepository>();
        public Map<String, Object> extensions = new HashMap<String, Object>();

        public static class AppParametersConsumer
        implements CommandLine.ArgumentsConsumer<CommandLineContext> {
            @Override
            public boolean matches(String arg, CommandLineContext context) {
                return arg.equals("-parameters");
            }

            @Override
            public int consume(String[] args, int index, CommandLineContext context) {
                context.appParameters = new String[args.length - index - 1];
                for (int j = 0; j < context.appParameters.length; ++j) {
                    context.appParameters[j] = args[index + 1 + j];
                }
                return args.length - index;
            }
        }

        public static class ConfigConsumer
        implements CommandLine.ArgumentsConsumer<CommandLineContext> {
            @Override
            public boolean matches(String arg, CommandLineContext context) {
                return arg.startsWith("-config=");
            }

            @Override
            public int consume(String[] args, int index, CommandLineContext context) {
                if (context.config != null) {
                    throw new IllegalArgumentException("Option -config cannot be specified several times");
                }
                context.config = args[index].substring(8);
                return 1;
            }
        }

        public static class PluginsConsumer
        implements CommandLine.ArgumentsConsumer<CommandLineContext> {
            @Override
            public boolean matches(String arg, CommandLineContext context) {
                return arg.startsWith("-plugins=");
            }

            @Override
            public int consume(String[] args, int index, CommandLineContext context) {
                if (context.plugins != null) {
                    throw new IllegalArgumentException("Option -plugins cannot be specified several times");
                }
                context.plugins = args[index].substring(9);
                return 1;
            }
        }

        public static class VersionConsumer
        implements CommandLine.ArgumentsConsumer<CommandLineContext> {
            @Override
            public boolean matches(String arg, CommandLineContext context) {
                return arg.startsWith("-version=");
            }

            @Override
            public int consume(String[] args, int index, CommandLineContext context) {
                if (context.version != null) {
                    throw new IllegalArgumentException("Option -version cannot be specified several times");
                }
                context.version = args[index].substring(9);
                return 1;
            }
        }

        public static class ArtifactIdConsumer
        implements CommandLine.ArgumentsConsumer<CommandLineContext> {
            @Override
            public boolean matches(String arg, CommandLineContext context) {
                return arg.startsWith("-artifactId=");
            }

            @Override
            public int consume(String[] args, int index, CommandLineContext context) {
                if (context.artifactId != null) {
                    throw new IllegalArgumentException("Option -artifactId cannot be specified several times");
                }
                context.artifactId = args[index].substring(12);
                return 1;
            }
        }

        public static class GroupIdConsumer
        implements CommandLine.ArgumentsConsumer<CommandLineContext> {
            @Override
            public boolean matches(String arg, CommandLineContext context) {
                return arg.startsWith("-groupId=");
            }

            @Override
            public int consume(String[] args, int index, CommandLineContext context) {
                if (context.groupId != null) {
                    throw new IllegalArgumentException("Option -groupId cannot be specified several times");
                }
                context.groupId = args[index].substring(9);
                return 1;
            }
        }
    }
}

