/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections.sort;

import java.util.Iterator;
import net.lecousin.framework.collections.sort.RedBlackTreeLong;
import net.lecousin.framework.collections.sort.Sorted;

public class RedBlackTreeLongByRange<T>
implements Sorted.AssociatedWithLong<T> {
    private long rangeSize;
    private int size = 0;
    private RedBlackTreeLong<RedBlackTreeLong<T>> ranges = new RedBlackTreeLong();

    public RedBlackTreeLongByRange(long rangeSize) {
        this.rangeSize = rangeSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.ranges.clear();
    }

    @Override
    public void add(long value, T element) {
        long r = value / this.rangeSize;
        RedBlackTreeLong.Node<RedBlackTreeLong<T>> e = this.ranges.get(r);
        if (e == null) {
            RedBlackTreeLong<T> rbt = new RedBlackTreeLong<T>();
            rbt.add(value, element);
            this.ranges.add(r, rbt);
        } else {
            e.getElement().add(value, element);
        }
        ++this.size;
    }

    @Override
    public boolean contains(long value, T element) {
        long r = value / this.rangeSize;
        RedBlackTreeLong.Node<RedBlackTreeLong<T>> e = this.ranges.get(r);
        if (e == null) {
            return false;
        }
        return e.getElement().contains(value, element);
    }

    @Override
    public boolean containsInstance(long value, T element) {
        long r = value / this.rangeSize;
        RedBlackTreeLong.Node<RedBlackTreeLong<T>> e = this.ranges.get(r);
        if (e == null) {
            return false;
        }
        return e.getElement().containsInstance(value, element);
    }

    @Override
    public void remove(long value, T element) {
        long r = value / this.rangeSize;
        RedBlackTreeLong.Node<RedBlackTreeLong<T>> e = this.ranges.get(r);
        e.getElement().remove(value, element);
        --this.size;
        if (e.getElement().isEmpty()) {
            this.ranges.removeInstance(r, e.getElement());
        }
    }

    @Override
    public void removeInstance(long value, T element) {
        long r = value / this.rangeSize;
        RedBlackTreeLong.Node<RedBlackTreeLong<T>> e = this.ranges.get(r);
        e.getElement().removeInstance(value, element);
        --this.size;
        if (e.getElement().isEmpty()) {
            this.ranges.removeInstance(r, e.getElement());
        }
    }

    public RedBlackTreeLong.Node<T> getMin() {
        if (this.size == 0) {
            return null;
        }
        RedBlackTreeLong.Node<RedBlackTreeLong<T>> e = this.ranges.getMin();
        return e.getElement().getMin();
    }

    public RedBlackTreeLong.Node<T> getMax() {
        if (this.size == 0) {
            return null;
        }
        RedBlackTreeLong.Node<RedBlackTreeLong<T>> e = this.ranges.getMax();
        return e.getElement().getMax();
    }

    public void removeMin() {
        RedBlackTreeLong.Node<RedBlackTreeLong<T>> e = this.ranges.getMin();
        e.getElement().removeMin();
        if (e.getElement().isEmpty()) {
            this.ranges.removeInstance(e.getValue(), e.getElement());
        }
        --this.size;
    }

    public void removeMax() {
        RedBlackTreeLong.Node<RedBlackTreeLong<T>> e = this.ranges.getMax();
        e.getElement().removeMax();
        if (e.getElement().isEmpty()) {
            this.ranges.removeInstance(e.getValue(), e.getElement());
        }
        --this.size;
    }

    @Override
    public Iterator<T> iterator() {
        return new It();
    }

    @Override
    public Iterator<T> orderedIterator() {
        return new OrderedIt();
    }

    @Override
    public Iterator<T> reverseOrderIterator() {
        return new ReverseOrderIt();
    }

    private class ReverseOrderIt
    implements Iterator<T> {
        private Iterator<RedBlackTreeLong<T>> itRange;
        private Iterator<T> subIt;

        public ReverseOrderIt() {
            this.itRange = RedBlackTreeLongByRange.this.ranges.reverseOrderIterator();
            this.subIt = null;
            this.forward();
        }

        private void forward() {
            while (true) {
                if (this.subIt != null) {
                    if (this.subIt.hasNext()) {
                        return;
                    }
                    this.subIt = null;
                }
                if (!this.itRange.hasNext()) break;
                RedBlackTreeLong rbt = this.itRange.next();
                this.subIt = rbt.reverseOrderIterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.subIt != null;
        }

        @Override
        public T next() {
            Object e = this.subIt.next();
            if (!this.subIt.hasNext()) {
                this.forward();
            }
            return e;
        }
    }

    private class OrderedIt
    implements Iterator<T> {
        private Iterator<RedBlackTreeLong<T>> itRange;
        private Iterator<T> subIt;

        public OrderedIt() {
            this.itRange = RedBlackTreeLongByRange.this.ranges.orderedIterator();
            this.subIt = null;
            this.forward();
        }

        private void forward() {
            while (true) {
                if (this.subIt != null) {
                    if (this.subIt.hasNext()) {
                        return;
                    }
                    this.subIt = null;
                }
                if (!this.itRange.hasNext()) break;
                RedBlackTreeLong rbt = this.itRange.next();
                this.subIt = rbt.orderedIterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.subIt != null;
        }

        @Override
        public T next() {
            Object e = this.subIt.next();
            if (!this.subIt.hasNext()) {
                this.forward();
            }
            return e;
        }
    }

    private class It
    implements Iterator<T> {
        private Iterator<RedBlackTreeLong<T>> itRange;
        private Iterator<T> subIt;

        public It() {
            this.itRange = RedBlackTreeLongByRange.this.ranges.iterator();
            this.subIt = null;
            this.forward();
        }

        private void forward() {
            while (true) {
                if (this.subIt != null) {
                    if (this.subIt.hasNext()) {
                        return;
                    }
                    this.subIt = null;
                }
                if (!this.itRange.hasNext()) break;
                RedBlackTreeLong rbt = this.itRange.next();
                this.subIt = rbt.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.subIt != null;
        }

        @Override
        public T next() {
            Object e = this.subIt.next();
            if (!this.subIt.hasNext()) {
                this.forward();
            }
            return e;
        }
    }
}

