/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.util.Runnables;

public interface Executable<T, E extends Exception> {
    public T execute(Task<T, E> var1) throws E, CancelException;

    public static class FromSupplierThrows<T, E extends Exception>
    implements Executable<T, E> {
        private Runnables.SupplierThrows<T, E> supplier;

        public FromSupplierThrows(Runnables.SupplierThrows<T, E> supplier) {
            this.supplier = supplier;
        }

        @Override
        public T execute(Task<T, E> t) throws E, CancelException {
            return this.supplier.get();
        }
    }

    public static class FromSupplier<T>
    implements Executable<T, NoException> {
        private Supplier<T> supplier;

        public FromSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        public T execute(Task<T, NoException> t) throws CancelException {
            return this.supplier.get();
        }
    }

    public static class FromFunctionThrows<IN, OUT, E extends Exception>
    implements Executable<OUT, E> {
        private Runnables.FunctionThrows<IN, OUT, E> fct;
        private IN input;

        public FromFunctionThrows(Runnables.FunctionThrows<IN, OUT, E> fct) {
            this.fct = fct;
        }

        public void setInput(IN input) {
            this.input = input;
        }

        @Override
        public OUT execute(Task<OUT, E> t) throws E, CancelException {
            return this.fct.apply(this.input);
        }
    }

    public static class FromFunction<IN, OUT>
    implements Executable<OUT, NoException> {
        private Function<IN, OUT> fct;
        private IN input;

        public FromFunction(Function<IN, OUT> fct) {
            this.fct = fct;
        }

        public void setInput(IN input) {
            this.input = input;
        }

        @Override
        public OUT execute(Task<OUT, NoException> t) throws CancelException {
            return this.fct.apply(this.input);
        }
    }

    public static class FromConsumerThrows<T, E extends Exception>
    implements Executable<Void, E> {
        private Runnables.ConsumerThrows<T, E> consumer;
        private T input;

        public FromConsumerThrows(Runnables.ConsumerThrows<T, E> consumer) {
            this.consumer = consumer;
        }

        public void setInput(T input) {
            this.input = input;
        }

        @Override
        public Void execute(Task<Void, E> t) throws E, CancelException {
            this.consumer.accept(this.input);
            return null;
        }
    }

    public static class FromConsumer<T>
    implements Executable<Void, NoException> {
        private Consumer<T> consumer;
        private T input;

        public FromConsumer(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        public void setInput(T input) {
            this.input = input;
        }

        @Override
        public Void execute(Task<Void, NoException> t) throws CancelException {
            this.consumer.accept(this.input);
            return null;
        }
    }

    public static class FromRunnable
    implements Executable<Void, NoException> {
        private Runnable run;

        public FromRunnable(Runnable run) {
            this.run = run;
        }

        @Override
        public Void execute(Task<Void, NoException> t) {
            this.run.run();
            return null;
        }
    }
}

