/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.async;

import java.util.LinkedList;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.exception.NoException;

public class ReadWriteLockPoint {
    private int readers = 0;
    private boolean writer = false;
    private Async<NoException> readerWaiting = null;
    private LinkedList<Async<NoException>> writersWaiting = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRead() {
        Async<NoException> sp;
        ReadWriteLockPoint readWriteLockPoint = this;
        synchronized (readWriteLockPoint) {
            if (!this.writer) {
                ++this.readers;
                return;
            }
            if (this.readerWaiting == null) {
                this.readerWaiting = new Async();
            }
            sp = this.readerWaiting;
            ++this.readers;
        }
        sp.block(0L);
    }

    public Async<NoException> startReadAsync() {
        return this.startReadAsync(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Async<NoException> startReadAsync(boolean returnNullIfReady) {
        Async<NoException> sp;
        ReadWriteLockPoint readWriteLockPoint = this;
        synchronized (readWriteLockPoint) {
            if (!this.writer) {
                ++this.readers;
                return returnNullIfReady ? null : new Async<boolean>(true);
            }
            if (this.readerWaiting == null) {
                this.readerWaiting = new Async();
            }
            sp = this.readerWaiting;
            ++this.readers;
        }
        return sp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRead() {
        Async<NoException> sp;
        ReadWriteLockPoint readWriteLockPoint = this;
        synchronized (readWriteLockPoint) {
            if (--this.readers > 0) {
                return;
            }
            if (this.writersWaiting == null) {
                return;
            }
            sp = this.writersWaiting.removeFirst();
            if (this.writersWaiting.isEmpty()) {
                this.writersWaiting = null;
            }
            this.writer = true;
        }
        sp.unblock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWrite() {
        Async sp;
        ReadWriteLockPoint readWriteLockPoint = this;
        synchronized (readWriteLockPoint) {
            if (this.readers == 0 && !this.writer) {
                this.writer = true;
                return;
            }
            sp = new Async();
            if (this.writersWaiting == null) {
                this.writersWaiting = new LinkedList();
            }
            this.writersWaiting.add(sp);
        }
        sp.block(0L);
    }

    public Async<NoException> startWriteAsync() {
        return this.startWriteAsync(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Async<NoException> startWriteAsync(boolean returnNullIfReady) {
        Async<NoException> sp;
        ReadWriteLockPoint readWriteLockPoint = this;
        synchronized (readWriteLockPoint) {
            if (this.readers == 0 && !this.writer) {
                this.writer = true;
                return returnNullIfReady ? null : new Async<boolean>(true);
            }
            sp = new Async<NoException>();
            if (this.writersWaiting == null) {
                this.writersWaiting = new LinkedList();
            }
            this.writersWaiting.add(sp);
        }
        return sp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endWrite() {
        Async<NoException> sp;
        ReadWriteLockPoint readWriteLockPoint = this;
        synchronized (readWriteLockPoint) {
            if (this.readerWaiting != null) {
                sp = this.readerWaiting;
                this.readerWaiting = null;
                this.writer = false;
            } else if (this.writersWaiting != null) {
                sp = this.writersWaiting.removeFirst();
                if (this.writersWaiting.isEmpty()) {
                    this.writersWaiting = null;
                }
            } else {
                this.writer = false;
                return;
            }
        }
        sp.unblock();
    }

    public boolean isUsed() {
        return this.readers > 0 || this.writer;
    }
}

