/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.BufferedWritableCharacterStream;
import net.lecousin.framework.io.text.ICharacterStream;

public class PropertiesFileSaver
implements Executable<Void, IOException> {
    private Properties properties;
    private ICharacterStream.Writable.Buffered output;
    private boolean closeStreamAtEnd;

    public static IAsync<IOException> savePropertiesFile(Properties properties, File file, Charset charset, Task.Priority priority) {
        FileIO.ReadWrite io = new FileIO.ReadWrite(file, priority);
        IAsync resize = io.setSizeAsync(0L);
        Async<IOException> result = new Async<IOException>();
        resize.onDone(() -> {
            if (resize.hasError()) {
                result.error((IOException)resize.getError());
                io.closeAsync();
                return;
            }
            PropertiesFileSaver.savePropertiesFile(properties, io, charset, priority, true).onDone(result);
        });
        return result;
    }

    public static IAsync<IOException> savePropertiesFile(Properties properties, IO.Writable output, Charset charset, Task.Priority priority, boolean closeIOAtEnd) {
        BufferedWritableCharacterStream stream = new BufferedWritableCharacterStream(output, charset, 4096);
        return PropertiesFileSaver.savePropertiesFile(properties, stream, priority, closeIOAtEnd);
    }

    public static IAsync<IOException> savePropertiesFile(Properties properties, ICharacterStream.Writable.Buffered output, Task.Priority priority, boolean closeStreamAtEnd) {
        PropertiesFileSaver saver = new PropertiesFileSaver(properties, output, closeStreamAtEnd);
        Task<Void, IOException> task = Task.cpu("Save properties file", priority, saver);
        task.start();
        return task.getOutput();
    }

    public PropertiesFileSaver(Properties properties, ICharacterStream.Writable.Buffered output, boolean closeStreamAtEnd) {
        this.properties = properties;
        this.output = output;
        this.closeStreamAtEnd = closeStreamAtEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void execute(Task<Void, IOException> taskContext) throws IOException, CancelException {
        try {
            for (Map.Entry<Object, Object> p : this.properties.entrySet()) {
                this.output.writeSync(p.getKey().toString());
                this.output.writeSync('=');
                this.output.writeSync(p.getValue().toString());
                this.output.writeSync('\n');
            }
            this.output.flush().blockThrow(0L);
            Iterator<Map.Entry<Object, Object>> iterator = null;
            return iterator;
        }
        finally {
            if (this.closeStreamAtEnd) {
                try {
                    this.output.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

