/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.File;
import java.io.IOException;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.threads.Task;

public class CreateDirectory
implements Executable<Void, IOException> {
    private File dir;
    private boolean recursive;
    private boolean failIfExists;

    public static Task<Void, IOException> task(File dir, boolean recursive, boolean failIfExists, Task.Priority priority) {
        return Task.file(dir, "Create directory", priority, new CreateDirectory(dir, recursive, failIfExists));
    }

    public CreateDirectory(File dir, boolean recursive, boolean failIfExists) {
        this.dir = dir;
        this.recursive = recursive;
        this.failIfExists = failIfExists;
    }

    @Override
    public Void execute(Task<Void, IOException> taskContext) throws IOException {
        boolean created = this.recursive ? this.dir.mkdirs() : this.dir.mkdir();
        if (!this.dir.exists()) {
            throw new IOException("Directory not created");
        }
        if (!created && this.failIfExists) {
            throw new IOException("Directory already exists");
        }
        return null;
    }
}

