/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.io.util.FileInfo;

public class GetFileInfo
implements Executable<FileInfo, IOException> {
    private File file;

    public static Task<FileInfo, IOException> task(File file, Task.Priority priority) {
        return Task.file(file, "Get FileInfo on " + file.getAbsolutePath(), priority, new GetFileInfo(file), null);
    }

    public GetFileInfo(File file) {
        this.file = file;
    }

    @Override
    public FileInfo execute(Task<FileInfo, IOException> task) throws IOException {
        FileInfo f = new FileInfo();
        f.file = this.file;
        f.path = this.file.toPath();
        BasicFileAttributes attr = Files.readAttributes(f.path, BasicFileAttributes.class, new LinkOption[0]);
        f.isDirectory = attr.isDirectory();
        f.isSymbolicLink = attr.isSymbolicLink();
        f.lastModified = attr.lastModifiedTime().toMillis();
        f.lastAccess = attr.lastAccessTime().toMillis();
        f.creation = attr.creationTime().toMillis();
        f.size = attr.size();
        return f;
    }
}

