/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.memory.ByteArrayCache;

public class ReadFullFile
implements Executable<byte[], IOException> {
    private File file;

    public static Task<byte[], IOException> create(File file, Task.Priority priority) {
        return Task.file(file, "Read full content of " + file.getAbsolutePath(), priority, new ReadFullFile(file), null);
    }

    public ReadFullFile(File file) {
        this.file = file;
    }

    @Override
    public byte[] execute(Task<byte[], IOException> taskContext) throws IOException, CancelException {
        try (RandomAccessFile f = new RandomAccessFile(this.file, "r");){
            int nb;
            byte[] content = (byte[])ByteArrayCache.getInstance().get((int)this.file.length(), false);
            int pos = 0;
            do {
                if (!taskContext.isCancelling()) continue;
                throw taskContext.getCancelEvent();
            } while ((nb = f.read(content, pos, content.length - pos)) > 0 && (pos += nb) < content.length);
            byte[] byArray = content;
            return byArray;
        }
    }
}

