/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.progress.WorkProgress;

public class RemoveDirectoryContent
implements Executable<Long, IOException> {
    private File dir;
    private WorkProgress progress;
    private long work;
    private boolean calculateSize;

    public static Task<Long, IOException> task(File dir, WorkProgress progress, long work, Task.Priority priority, boolean calculateSize) {
        return Task.file(dir, "Remove content of directory " + dir.getAbsolutePath(), priority, new RemoveDirectoryContent(dir, progress, work, calculateSize), null);
    }

    public RemoveDirectoryContent(File dir, WorkProgress progress, long work, boolean calculateSize) {
        this.dir = dir;
        this.progress = progress;
        this.work = work;
        this.calculateSize = calculateSize;
    }

    @Override
    public Long execute(Task<Long, IOException> taskContext) throws IOException, CancelException {
        return RemoveDirectoryContent.removeDirectoryContent(this.dir, this.progress, this.work, this.calculateSize, taskContext);
    }

    static long removeDirectoryContent(File dir, WorkProgress progress, long work, boolean calculateSize, Task<?, ?> taskContext) throws IOException, CancelException {
        return RemoveDirectoryContent.remove(dir, progress, work, calculateSize, false, taskContext);
    }

    static long deleteDirectory(File dir, WorkProgress progress, long work, boolean calculateSize, Task<?, ?> taskContext) throws IOException, CancelException {
        return RemoveDirectoryContent.remove(dir, progress, work, calculateSize, true, taskContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long remove(File dir, WorkProgress progress, long work, boolean calculateSize, boolean deleteDir, Task<?, ?> taskContext) throws IOException, CancelException {
        try {
            if (!dir.exists()) {
                long l = 0L;
                return l;
            }
            File[] files = dir.listFiles();
            if (files == null) {
                throw new AccessDeniedException(dir.getAbsolutePath());
            }
            long size = 0L;
            int nb = files.length;
            if (deleteDir) {
                ++nb;
            }
            for (File f : files) {
                if (taskContext.isCancelling()) {
                    throw taskContext.getCancelEvent();
                }
                long step = work / (long)nb--;
                work -= step;
                if (f.isDirectory()) {
                    size += RemoveDirectoryContent.remove(f, progress, step, calculateSize, true, taskContext);
                    continue;
                }
                if (calculateSize) {
                    size += f.length();
                }
                try {
                    Files.delete(f.toPath());
                }
                finally {
                    if (progress != null) {
                        progress.progress(step);
                    }
                }
                if (progress == null || step <= 0L) continue;
                progress.progress(step);
            }
            if (deleteDir) {
                Files.delete(dir.toPath());
            }
            long l = size;
            return l;
        }
        finally {
            if (progress != null && work > 0L) {
                progress.progress(work);
            }
        }
    }
}

