/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.tasks.drives.FileAccess;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.util.Pair;

class SeekFile
implements Executable<Long, IOException> {
    private FileAccess file;
    private IO.Seekable.SeekType type;
    private long move;
    private boolean allowAfterEnd;
    private boolean returnNewPosition;

    public static Task<Long, IOException> launch(FileAccess file, IO.Seekable.SeekType type, long move, boolean allowAfterEnd, boolean returnNewPosition, Task.Priority priority, Consumer<Pair<Long, IOException>> ondone) {
        Task<Long, IOException> task = new Task<Long, IOException>(file.manager, "Seek in file", priority, new SeekFile(file, type, move, allowAfterEnd, returnNewPosition), ondone);
        file.openTask.ondone(task, false);
        return task;
    }

    public SeekFile(FileAccess file, IO.Seekable.SeekType type, long move, boolean allowAfterEnd, boolean returnNewPosition) {
        this.file = file;
        this.type = type;
        this.move = move;
        this.allowAfterEnd = allowAfterEnd;
        this.returnNewPosition = returnNewPosition;
    }

    @Override
    public Long execute(Task<Long, IOException> taskContext) throws IOException, CancelException {
        try {
            long initialPos = -1L;
            if (!this.returnNewPosition) {
                initialPos = this.file.channel.position();
            }
            long size = -1L;
            if (!this.allowAfterEnd) {
                size = this.file.getSize();
            }
            switch (this.type) {
                case FROM_BEGINNING: {
                    if (this.move < 0L) {
                        this.move = 0L;
                    }
                    if (!this.allowAfterEnd && this.move > size) {
                        this.move = size;
                    }
                    this.file.channel.position(this.move);
                    break;
                }
                case FROM_CURRENT: {
                    long pos = this.file.channel.position();
                    if (pos + this.move < 0L) {
                        this.move = -pos;
                    }
                    if (!this.allowAfterEnd && pos + this.move > size) {
                        this.move = size - pos;
                    }
                    this.file.channel.position(pos + this.move);
                    break;
                }
                default: {
                    if (this.move < 0L) {
                        this.move = 0L;
                    }
                    if (size == -1L) {
                        size = this.file.getSize();
                    }
                    if (size - this.move < 0L) {
                        this.move = size;
                    }
                    this.file.channel.position(size - this.move);
                }
            }
            if (this.returnNewPosition) {
                return this.file.channel.position();
            }
            return this.file.channel.position() - initialPos;
        }
        catch (ClosedChannelException e) {
            throw new CancelException("File has been closed");
        }
    }
}

