/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.IOException;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.tasks.drives.FileAccess;
import net.lecousin.framework.concurrent.threads.Task;

class SetFileSize
implements Executable<Void, IOException> {
    private FileAccess file;
    private long newSize;

    public static Task<Void, IOException> launch(FileAccess file, long newSize, Task.Priority priority) {
        Task<Void, IOException> task = new Task<Void, IOException>(file.manager, "Change file size", priority, new SetFileSize(file, newSize), null);
        file.openTask.ondone(task, false);
        return task;
    }

    public SetFileSize(FileAccess file, long newSize) {
        this.file = file;
        this.newSize = newSize;
    }

    @Override
    public Void execute(Task<Void, IOException> taskContext) throws IOException {
        this.file.f.setLength(this.newSize);
        this.file.size = this.newSize;
        return null;
    }
}

