/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.threads;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import net.lecousin.framework.collections.map.MapUtil;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.TaskManagerMonitor;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.concurrent.threads.fixed.FixedThreadTaskManager;
import net.lecousin.framework.concurrent.threads.fixed.MonoThreadTaskManager;
import net.lecousin.framework.concurrent.threads.fixed.MultiThreadTaskManager;
import net.lecousin.framework.concurrent.threads.priority.SimpleTaskPriorityManager;
import net.lecousin.framework.concurrent.threads.priority.TaskPriorityManager;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.Triple;

public class DrivesThreadingManager {
    private static final String DRIVE = "Drive ";
    private ThreadFactory threadFactory;
    private Class<? extends TaskPriorityManager> taskPriorityManagerClass;
    private Map<String, Object> rootResources;
    private Map<String, TaskManager> rootManagers;
    private Map<Object, TaskManager> managers;
    private TaskManagerMonitor.Configuration driveMonitoring;
    private DrivesProvider drivesProvider = null;

    DrivesThreadingManager(ThreadFactory threadFactory, Class<? extends TaskPriorityManager> taskPriorityManagerClass, DrivesProvider drivesProvider, TaskManagerMonitor.Configuration driveMonitoring) {
        this.threadFactory = threadFactory;
        this.taskPriorityManagerClass = taskPriorityManagerClass;
        this.driveMonitoring = driveMonitoring;
        this.rootResources = new HashMap<String, Object>();
        this.rootManagers = new HashMap<String, TaskManager>();
        this.managers = new HashMap<Object, TaskManager>();
        if (drivesProvider == null) {
            for (File root : File.listRoots()) {
                TaskPriorityManager prio;
                String path = root.getAbsolutePath();
                if (path.charAt(path.length() - 1) != File.separatorChar) {
                    path = path + File.separatorChar;
                }
                File resource = root;
                try {
                    prio = taskPriorityManagerClass.newInstance();
                }
                catch (Exception e) {
                    Threading.getLogger().error("Unable to instantiate " + taskPriorityManagerClass.getName());
                    prio = new SimpleTaskPriorityManager();
                }
                MonoThreadTaskManager tm = new MonoThreadTaskManager(DRIVE + path, resource, threadFactory, prio, driveMonitoring);
                tm.start();
                this.rootResources.put(path, resource);
                this.rootManagers.put(path, tm);
                this.managers.put(resource, tm);
                Threading.registerResource(resource, tm);
            }
        } else {
            this.setDrivesProvider(drivesProvider);
        }
    }

    public Object getResource(File file) {
        return this.getResource(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResource(String path) {
        Map.Entry<String, Object> bestMatch = null;
        Map<String, TaskManager> map = this.rootManagers;
        synchronized (map) {
            for (Map.Entry<String, Object> e : this.rootResources.entrySet()) {
                if (!path.startsWith(e.getKey()) || bestMatch != null && ((String)bestMatch.getKey()).length() >= e.getKey().length()) continue;
                bestMatch = e;
            }
            if (bestMatch != null) {
                return bestMatch.getValue();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getResources() {
        Map<Object, TaskManager> map = this.managers;
        synchronized (map) {
            return new ArrayList<Object>(this.managers.keySet());
        }
    }

    public TaskManager getTaskManager(File file) {
        return this.getTaskManager(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskManager getTaskManager(String path) {
        Map.Entry<String, TaskManager> bestMatch = null;
        Map<String, TaskManager> map = this.rootManagers;
        synchronized (map) {
            for (Map.Entry<String, TaskManager> e : this.rootManagers.entrySet()) {
                if (!path.startsWith(e.getKey()) || bestMatch != null && ((String)bestMatch.getKey()).length() >= e.getKey().length()) continue;
                bestMatch = e;
            }
            if (bestMatch != null) {
                return (TaskManager)bestMatch.getValue();
            }
        }
        return null;
    }

    public String getPartitionPath(File file) {
        return this.getPartitionPath(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPartitionPath(String path) {
        Map.Entry<String, TaskManager> bestMatch = null;
        Map<String, TaskManager> map = this.rootManagers;
        synchronized (map) {
            for (Map.Entry<String, TaskManager> e : this.rootManagers.entrySet()) {
                if (!path.startsWith(e.getKey()) || bestMatch != null && ((String)bestMatch.getKey()).length() >= e.getKey().length()) continue;
                bestMatch = e;
            }
            if (bestMatch != null) {
                return (String)bestMatch.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMonitoringConfiguration(TaskManagerMonitor.Configuration config) {
        Map<String, TaskManager> map = this.rootManagers;
        synchronized (map) {
            this.driveMonitoring = config;
            for (TaskManager tm : this.rootManagers.values()) {
                tm.getMonitor().setConfiguration(config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDrivesProvider(DrivesProvider provider) {
        DrivesThreadingManager drivesThreadingManager = this;
        synchronized (drivesThreadingManager) {
            if (this.drivesProvider != null) {
                throw new IllegalStateException();
            }
            this.drivesProvider = provider;
        }
        this.drivesProvider.provide(this::newDrive, this::driveRemoved, this::newPartition, this::partitionRemoved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newDrive(Triple<Object, List<File>, Boolean> driveAndPartitions) {
        TaskPriorityManager prio;
        Object drive = driveAndPartitions.getValue1();
        boolean multiThread = driveAndPartitions.getValue3() != null && driveAndPartitions.getValue3() != false;
        try {
            prio = this.taskPriorityManagerClass.newInstance();
        }
        catch (Exception e) {
            Threading.getLogger().error("Unable to instantiate " + this.taskPriorityManagerClass.getName());
            prio = new SimpleTaskPriorityManager();
        }
        FixedThreadTaskManager tm = multiThread ? new MultiThreadTaskManager(DRIVE + drive.toString(), drive, 2, this.threadFactory, prio, this.driveMonitoring) : new MonoThreadTaskManager(DRIVE + drive.toString(), drive, this.threadFactory, prio, this.driveMonitoring);
        tm.start();
        Map<Object, TaskManager> map = this.managers;
        synchronized (map) {
            this.managers.put(drive, tm);
        }
        Threading.registerResource(drive, tm);
        List<File> partitions = driveAndPartitions.getValue2();
        if (partitions == null || partitions.isEmpty()) {
            return;
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (File mount : partitions) {
            TaskManager previous;
            String path = mount.getAbsolutePath();
            if (path.charAt(path.length() - 1) != File.separatorChar) {
                path = path + File.separatorChar;
            }
            paths.add(path);
            Map<String, TaskManager> map2 = this.rootManagers;
            synchronized (map2) {
                previous = this.rootManagers.get(path);
                if (previous != null) {
                    Threading.unregisterResource(this.rootResources.get(path));
                    this.rootManagers.remove(path);
                    this.rootResources.remove(path);
                    this.rootManagers.put(path, tm);
                    this.rootResources.put(path, drive);
                } else {
                    this.rootManagers.put(path, tm);
                    this.rootResources.put(path, drive);
                }
            }
            if (previous == null) continue;
            previous.transferAndClose(tm);
        }
        StringBuilder name = new StringBuilder();
        name.append(tm.getName()).append(" (");
        for (int i = 0; i < paths.size(); ++i) {
            if (i > 0) {
                name.append(" + ");
            }
            name.append((String)paths.get(i));
        }
        name.append(')');
        tm.setName(name.toString());
        Threading.getLogger().info("Task manager added: " + name.toString());
        tm.started();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void driveRemoved(Object drive) {
        TaskManager tm;
        Map<Object, TaskManager> map = this.managers;
        synchronized (map) {
            tm = this.managers.remove(drive);
        }
        if (tm != null) {
            Threading.unregisterResource(drive);
            map = this.rootManagers;
            synchronized (map) {
                MapUtil.removeValue(this.rootManagers, tm);
                MapUtil.removeValue(this.rootResources, drive);
            }
            tm.cancelAndStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newPartition(Pair<Object, File> driveAndPartition) {
        TaskManager previous;
        TaskManager tm;
        Object drive = driveAndPartition.getValue1();
        File mount = driveAndPartition.getValue2();
        String path = mount.getAbsolutePath();
        if (path.charAt(path.length() - 1) != File.separatorChar) {
            path = path + File.separatorChar;
        }
        Map<Object, TaskManager> map = this.managers;
        synchronized (map) {
            tm = this.managers.get(drive);
        }
        if (tm == null) {
            Threading.getLogger().error("Cannot handle partition " + mount.getAbsolutePath() + " because drive is unknown: " + drive);
            return;
        }
        Map<String, TaskManager> map2 = this.rootManagers;
        synchronized (map2) {
            previous = this.rootManagers.get(path);
            if (previous != null) {
                this.rootManagers.remove(path);
                this.rootResources.remove(path);
                this.rootManagers.put(path, tm);
                Object prevResource = this.rootResources.put(path, drive);
                if (!this.rootResources.containsValue(prevResource)) {
                    Threading.unregisterResource(prevResource);
                }
            } else {
                this.rootManagers.put(path, tm);
                this.rootResources.put(path, drive);
            }
        }
        if (previous != null && previous != tm) {
            previous.transferAndClose(tm);
        }
        Threading.getLogger().info("New partition added to DrivesTaskManager: " + mount.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void partitionRemoved(Pair<Object, File> driveAndPartition) {
        String path = driveAndPartition.getValue2().getAbsolutePath();
        if (path.charAt(path.length() - 1) != File.separatorChar) {
            path = path + File.separatorChar;
        }
        Map<String, TaskManager> map = this.rootManagers;
        synchronized (map) {
            Threading.unregisterResource(this.rootResources.get(path));
            this.rootManagers.remove(path);
            this.rootResources.remove(path);
        }
    }

    public static interface DrivesProvider {
        public void provide(Consumer<Triple<Object, List<File>, Boolean>> var1, Consumer<Object> var2, Consumer<Pair<Object, File>> var3, Consumer<Pair<Object, File>> var4);
    }
}

