/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.threads;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Cancellable;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.async.JoinPoint;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.TaskScheduler;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.util.Pair;

public final class Task<T, TError extends Exception>
implements Cancellable {
    public static final int BACKGROUND_VALUE = 100;
    private Application app;
    private TaskManager manager;
    byte status;
    static final byte STATUS_NOT_STARTED = 0;
    static final byte STATUS_STARTED_WAITING = 1;
    static final byte STATUS_STARTED_READY = 2;
    static final byte STATUS_RUNNING = 3;
    static final byte STATUS_BLOCKED = 4;
    static final byte STATUS_EXECUTED = 5;
    static final byte STATUS_DONE = 6;
    private Executable<T, TError> executable;
    private Output result = new Output();
    private CancelException cancelling = null;
    private Consumer<Pair<T, TError>> ondone = null;
    private String description;
    private Priority priority;
    private long executeEvery;
    long nextExecution;
    private long maxBlockingTimeInNanoBeforeToLog = 100000000L;
    private List<IAsync<?>> holdSP = null;

    public static Priority getCurrentPriority() {
        Task<?, ?> current = Threading.currentTask();
        return current != null ? current.getPriority() : Priority.NORMAL;
    }

    public Task(TaskManager manager, String description, Priority priority, Executable<T, TError> executable, Consumer<Pair<T, TError>> ondone) {
        if (manager == null) {
            manager = Threading.getUnmanagedTaskManager();
        }
        this.app = LCCore.getApplication();
        this.manager = manager;
        this.description = description;
        if (priority == null) {
            priority = Task.getCurrentPriority();
        }
        this.priority = priority;
        this.executable = executable;
        this.ondone = ondone;
        this.result.onDone(() -> {
            if (this.result.isCancelled() && this.status < 3) {
                Logger logger = this.app.getDefaultLogger();
                if (logger.debug()) {
                    CancelException reason = this.result.getCancelEvent();
                    logger.debug("Task cancelled: " + description + " => " + (reason != null ? reason.getMessage() : "No reason given"));
                }
                this.cancel(this.result.getCancelEvent());
            }
            this.status = (byte)6;
        });
    }

    public String getDescription() {
        return this.description;
    }

    public Application getApplication() {
        return this.app;
    }

    public TaskManager getTaskManager() {
        return this.manager;
    }

    public long getMaxBlockingTimeInNanoBeforeToLog() {
        return this.maxBlockingTimeInNanoBeforeToLog;
    }

    public Task<T, TError> setMaxBlockingTimeInNanoBeforeToLog(long nano) {
        this.maxBlockingTimeInNanoBeforeToLog = nano;
        return this;
    }

    public boolean isDone() {
        return this.status == 6 && this.result.isDone();
    }

    public boolean isSuccessful() {
        return this.status == 6 && this.result.isSuccessful();
    }

    public boolean isCancelling() {
        return this.cancelling != null || this.result.isCancelled();
    }

    @Override
    public boolean isCancelled() {
        return this.result.isCancelled();
    }

    public boolean isStarted() {
        return this.status > 0;
    }

    public boolean isRunning() {
        return this.status >= 3 && this.status < 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelIfExecutionNotStarted(CancelException reason) {
        Task task = this;
        synchronized (task) {
            if (this.status < 3) {
                this.cancel(reason);
                return true;
            }
        }
        return false;
    }

    @Override
    public void cancel(CancelException reason) {
        if (this.cancelling != null) {
            return;
        }
        if (reason == null) {
            reason = new CancelException("No reason given");
        }
        this.cancelling = reason;
        if (TaskScheduler.cancel(this) || this.manager.remove(this) || this.status == 0) {
            this.status = (byte)6;
            this.result.cancelled(reason);
        }
    }

    @Override
    public CancelException getCancelEvent() {
        return this.cancelling != null ? this.cancelling : this.result.getCancelEvent();
    }

    public AsyncSupplier<T, TError> getOutput() {
        return this.result;
    }

    public void setDone(T result, TError error) {
        this.status = (byte)6;
        if (error == null) {
            this.result.unblockSuccess(result);
        } else {
            this.result.unblockError(error);
        }
    }

    public void ondone(Task<?, ?> todo, boolean evenIfErrorOrCancel) {
        if (this.result.isCancelled()) {
            todo.cancel(this.result.getCancelEvent());
        } else if (this.result.hasError()) {
            todo.cancel(new CancelException((Throwable)this.result.getError()));
        } else if (this.result.isDone()) {
            todo.start();
        } else {
            todo.startOn(this.result, evenIfErrorOrCancel);
        }
    }

    public Priority getPriority() {
        return this.priority;
    }

    public synchronized void setPriority(Priority priority) {
        if (this.priority == priority) {
            return;
        }
        if (this.status == 2 && this.manager.remove(this)) {
            this.priority = priority;
            while (this.manager.getTransferTarget() != null) {
                this.manager = this.manager.getTransferTarget();
            }
            this.manager.addReady(this);
            return;
        }
        this.priority = priority;
    }

    public Task<T, TError> ensureUnblocked(IAsync<?> ... sp) {
        if (this.status == 6) {
            for (int i = 0; i < sp.length; ++i) {
                if (sp[i].isDone()) continue;
                sp[i].cancel(new CancelException("Task " + this.description + " done without unblock this synchronization point"));
            }
            return this;
        }
        if (this.holdSP == null) {
            this.holdSP = new ArrayList(sp.length + 2);
        }
        Collections.addAll(this.holdSP, sp);
        return this;
    }

    public long getRepetitionDelay() {
        return this.executeEvery;
    }

    public Task<T, TError> executeAt(long time) {
        this.nextExecution = time;
        return this;
    }

    public Task<T, TError> executeIn(long delay) {
        return this.executeAt(System.currentTimeMillis() + delay);
    }

    public Task<T, TError> executeEvery(long delay, long initialDelay) {
        this.executeEvery = delay;
        return this.executeIn(initialDelay);
    }

    public void stopRepeat() {
        this.executeEvery = 0L;
    }

    public Task<T, TError> executeAgainIn(long delay) {
        return this.executeAgainAt(System.currentTimeMillis() + delay);
    }

    public Task<T, TError> executeAgainAt(long time) {
        return this.executeAt(time);
    }

    public synchronized void changeNextExecutionTime(long time) {
        if (this.status == 1) {
            TaskScheduler.changeNextExecutionTime(this, time);
        } else {
            this.nextExecution = time;
        }
    }

    public synchronized void executeNextOccurenceNow() {
        long now = System.currentTimeMillis();
        if (this.nextExecution > now) {
            this.changeNextExecutionTime(System.currentTimeMillis());
        }
    }

    public synchronized void executeNextOccurenceNow(Priority priority) {
        this.setPriority(priority);
        this.executeNextOccurenceNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<T, TError> start() {
        if (this.result.isDone()) {
            return this;
        }
        if (this.cancelling != null) {
            this.result.cancelled(this.cancelling);
        }
        Task task = this;
        synchronized (task) {
            long now;
            if (this.result.isDone()) {
                return this;
            }
            if (this.status != 0) {
                if (this.status >= 6) {
                    throw new RuntimeException("Task already done: " + this.description + " with " + (this.result.getError() != null ? "error " + ((Throwable)this.result.getError()).getMessage() : "success"));
                }
                throw new RuntimeException("Task already started (" + this.status + "): " + this.description);
            }
            if (this.nextExecution > 0L && this.nextExecution > (now = System.currentTimeMillis())) {
                TaskScheduler.schedule(this);
                return this;
            }
            this.sendToTaskManager();
            return this;
        }
    }

    public void startOn(IAsync<? extends Exception> sp, boolean evenOnErrorOrCancel) {
        sp.onDone(() -> {
            if (evenOnErrorOrCancel) {
                this.start();
                return;
            }
            if (sp.isCancelled()) {
                this.cancel(sp.getCancelEvent());
            } else if (sp.hasError()) {
                try {
                    Object err = sp.getError();
                    this.status = (byte)6;
                    this.result.unblockError(err);
                }
                catch (ClassCastException e) {
                    this.cancel(new CancelException("Error while waiting", (Throwable)sp.getError()));
                }
            } else {
                this.start();
            }
        });
    }

    public void startOn(boolean evenOnErrorOrCancel, IAsync<?> ... list) {
        JoinPoint jp = new JoinPoint();
        for (IAsync<?> sp : list) {
            if (sp == null) continue;
            jp.addToJoin(sp);
        }
        jp.start();
        jp.onDone(() -> {
            if (evenOnErrorOrCancel) {
                this.start();
                return;
            }
            if (jp.isCancelled()) {
                this.cancel(jp.getCancelEvent());
            } else if (jp.hasError()) {
                try {
                    Object err = jp.getError();
                    this.status = (byte)6;
                    this.result.unblockError(err);
                }
                catch (ClassCastException e) {
                    this.cancel(new CancelException("Error while waiting", (Throwable)jp.getError()));
                }
            } else {
                this.start();
            }
        });
    }

    public void startAfter(Task<?, ?> task) {
        if (task == null || task.isDone()) {
            this.start();
            return;
        }
        this.startOn(task.getOutput(), true);
    }

    void sendToTaskManager() {
        while (this.manager.getTransferTarget() != null) {
            this.manager = this.manager.getTransferTarget();
        }
        this.status = (byte)2;
        this.manager.addReady(this);
    }

    void transferTo(TaskManager newManager) {
        this.manager = newManager;
    }

    void cancelledBecauseExecutorDied(CancelException reason) {
        if (this.cancelling != null) {
            reason = this.cancelling;
        } else {
            this.cancelling = reason;
        }
        this.result.cancel(reason);
        this.status = (byte)6;
        this.result.cancelled(reason);
    }

    void execute() {
        T res;
        if (this.cancelling != null) {
            this.status = (byte)6;
            this.result.cancelled(this.cancelling);
            this.checkSP();
            return;
        }
        try {
            res = this.executable.execute(this);
        }
        catch (CancelException e) {
            this.status = (byte)6;
            this.cancelling = e;
            this.result.cancelled(e);
            this.checkSP();
            return;
        }
        catch (Exception t) {
            this.status = (byte)6;
            if (this.cancelling != null) {
                if (!this.result.isCancelled()) {
                    this.result.cancelled(this.cancelling);
                }
                if (this.app.isDebugMode()) {
                    this.app.getDefaultLogger().warn("Task " + this.description + " error while trying to cancel it: " + t.getMessage() + ", cancellation reason is " + this.result.getCancelEvent().getMessage(), t);
                }
            } else if (!this.result.isCancelled()) {
                if (this.app.isDebugMode()) {
                    this.app.getDefaultLogger().error("Task " + this.description + " error: " + t.getMessage(), t);
                }
                try {
                    Exception error = t;
                    if (this.ondone != null) {
                        this.ondone.accept(new Pair<Object, Exception>(null, error));
                    }
                    this.result.unblockError(error);
                }
                catch (ClassCastException e) {
                    this.cancelling = new CancelException("Unexpected exception thrown", t);
                    this.result.cancelled(this.cancelling);
                }
                catch (Exception e) {
                    this.cancelling = new CancelException("Unexpected exception thrown", e);
                    this.result.cancelled(this.cancelling);
                }
            } else if (this.app.isDebugMode()) {
                this.app.getDefaultLogger().warn("Task " + this.description + " error after being cancelled: " + t.getMessage() + ", cancellation reason is " + this.result.getCancelEvent().getMessage(), t);
            }
            this.checkSP();
            return;
        }
        this.status = (byte)6;
        try {
            if (this.ondone != null) {
                this.ondone.accept(new Pair<T, Object>(res, null));
            }
        }
        catch (Exception t) {
            this.app.getDefaultLogger().error("Error while calling ondone on task " + this.description, t);
        }
        this.result.unblockSuccess(res);
        this.checkSP();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rescheduleIfNeeded() {
        if (this.executeEvery > 0L && !TaskScheduler.stopping) {
            Task task = this;
            synchronized (task) {
                this.status = 0;
                this.executeIn(this.executeEvery);
            }
            TaskScheduler.schedule(this);
        } else if (this.nextExecution > 0L && !TaskScheduler.stopping) {
            Task task = this;
            synchronized (task) {
                this.status = 0;
            }
            TaskScheduler.schedule(this);
        }
    }

    private void checkSP() {
        if (this.holdSP == null) {
            return;
        }
        for (IAsync<?> sp : this.holdSP) {
            if (sp.isDone()) continue;
            sp.cancel(new CancelException("Task " + this.description + " done without unblocking this synchronization point"));
        }
        this.holdSP = null;
    }

    public String toString() {
        return "Task[" + this.description + "]";
    }

    public static <T, TError extends Exception> Task<T, TError> done(T result, TError error) {
        Task<T, TError> t = new Task<T, TError>(Threading.getCPUTaskManager(), "", Priority.NORMAL, null, null);
        t.setDone(result, error);
        return t;
    }

    public static <T, TError extends Exception> Task<T, TError> cpu(String description, Priority priority, Executable<T, TError> executable, Consumer<Pair<T, TError>> ondone) {
        return new Task<T, TError>(Threading.getCPUTaskManager(), description, priority, executable, ondone);
    }

    public static <T, TError extends Exception> Task<T, TError> cpu(String description, Priority priority, Executable<T, TError> executable) {
        return new Task<T, TError>(Threading.getCPUTaskManager(), description, priority, executable, null);
    }

    public static <T, TError extends Exception> Task<T, TError> cpu(String description, Executable<T, TError> executable, Consumer<Pair<T, TError>> ondone) {
        return new Task<T, TError>(Threading.getCPUTaskManager(), description, null, executable, ondone);
    }

    public static <T, TError extends Exception> Task<T, TError> cpu(String description, Executable<T, TError> executable) {
        return new Task<T, TError>(Threading.getCPUTaskManager(), description, null, executable, null);
    }

    public static <T, TError extends Exception> Task<T, TError> file(File file, String description, Priority priority, Executable<T, TError> executable, Consumer<Pair<T, TError>> ondone) {
        return new Task<T, TError>(Threading.getDrivesManager().getTaskManager(file), description, priority, executable, ondone);
    }

    public static <T, TError extends Exception> Task<T, TError> file(File file, String description, Priority priority, Executable<T, TError> executable) {
        return new Task<T, TError>(Threading.getDrivesManager().getTaskManager(file), description, priority, executable, null);
    }

    public static <T, TError extends Exception> Task<T, TError> unmanaged(String description, Priority priority, Executable<T, TError> executable, Consumer<Pair<T, TError>> ondone) {
        return new Task<T, TError>(Threading.getUnmanagedTaskManager(), description, priority, executable, ondone);
    }

    public static <T, TError extends Exception> Task<T, TError> unmanaged(String description, Executable<T, TError> executable, Consumer<Pair<T, TError>> ondone) {
        return new Task<T, TError>(Threading.getUnmanagedTaskManager(), description, null, executable, ondone);
    }

    public static <T, TError extends Exception> Task<T, TError> unmanaged(String description, Priority priority, Executable<T, TError> executable) {
        return new Task<T, TError>(Threading.getUnmanagedTaskManager(), description, priority, executable, null);
    }

    public static <T, TError extends Exception> Task<T, TError> unmanaged(String description, Executable<T, TError> executable) {
        return new Task<T, TError>(Threading.getUnmanagedTaskManager(), description, null, executable, null);
    }

    private final class Output
    extends AsyncSupplier<T, TError> {
        private Output() {
        }

        @Override
        public void unblockCancel(CancelException reason) {
            Task.this.cancel(reason);
        }

        void cancelled(CancelException reason) {
            super.unblockCancel(reason);
        }

        public String toString() {
            return "Task result [" + Task.this.description + "]";
        }
    }

    public static enum Priority {
        URGENT(0),
        IMPORTANT(1),
        RATHER_IMPORTANT(2),
        NORMAL(3),
        RATHER_LOW(4),
        LOW(5),
        BACKGROUND(100);

        public static final int NB = 6;
        private int value;

        private Priority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public Priority less() {
            switch (this) {
                case URGENT: {
                    return IMPORTANT;
                }
                case IMPORTANT: {
                    return RATHER_IMPORTANT;
                }
                case RATHER_IMPORTANT: {
                    return NORMAL;
                }
                case NORMAL: {
                    return RATHER_LOW;
                }
            }
            return LOW;
        }

        public Priority more() {
            switch (this) {
                case BACKGROUND: {
                    return LOW;
                }
                case LOW: {
                    return RATHER_LOW;
                }
                case RATHER_LOW: {
                    return NORMAL;
                }
                case NORMAL: {
                    return RATHER_IMPORTANT;
                }
                case RATHER_IMPORTANT: {
                    return IMPORTANT;
                }
            }
            return URGENT;
        }
    }
}

