/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.threads;

import java.io.Closeable;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Iterator;
import java.util.List;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskExecutor;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.util.DebugUtil;

public final class TaskManagerMonitor {
    private TaskManager manager;
    private Configuration config;
    private Monitor thread;

    TaskManagerMonitor(TaskManager manager, Configuration config) {
        this.manager = manager;
        this.config = config;
        this.thread = new Monitor();
        Thread t = manager.threadFactory.newThread(this.thread);
        t.setName(manager.getName() + " - Task Monitoring");
        t.start();
        LCCore.get().toClose(this.thread);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConfiguration(Configuration config) {
        Object object = this.thread.lock;
        synchronized (object) {
            this.config = config;
            this.thread.wait = 0L;
            this.thread.lock.notify();
        }
    }

    private class Monitor
    implements Runnable,
    Closeable {
        private Object lock = new Object();
        private boolean closed = false;
        private long wait;

        private Monitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.wait = TaskManagerMonitor.this.config.taskExecutionMillisecondsBeforeToWarn;
            while (!this.closed) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.wait > 0L) {
                        try {
                            this.lock.wait(this.wait);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    if (this.closed || TaskManagerMonitor.this.manager.isStopping() && TaskManagerMonitor.this.manager.allActiveExecutorsStopped()) {
                        break;
                    }
                }
                this.wait = this.check();
                if (this.wait != -1L) continue;
                this.wait = TaskManagerMonitor.this.config.taskExecutionMillisecondsBeforeToWarn;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this.closed = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        private long check() {
            long nextTime = -1L;
            for (TaskExecutor executor : TaskManagerMonitor.this.manager.getAllActiveExecutors()) {
                long next = this.check(executor);
                if (next == -1L || nextTime != -1L && nextTime <= next) continue;
                nextTime = next;
            }
            if (TaskManagerMonitor.this.config.checkLocksOnBlockedTasks) {
                this.checkLocks(TaskManagerMonitor.this.manager.getBlockedExecutors());
            }
            return nextTime;
        }

        private long check(TaskExecutor executor) {
            if (executor == null) {
                return -1L;
            }
            long now = System.nanoTime();
            Task<?, ?> task = executor.currentTask;
            if (task == null) {
                return -1L;
            }
            long start = executor.currentTaskStart;
            long ms = (now - start) / 1000000L;
            if (ms < (long)TaskManagerMonitor.this.config.taskExecutionMillisecondsBeforeToWarn) {
                return (long)TaskManagerMonitor.this.config.taskExecutionMillisecondsBeforeToWarn - ms;
            }
            if (ms < (long)TaskManagerMonitor.this.config.taskExecutionMillisecondsBeforeToPutAside) {
                StringBuilder s = new StringBuilder(256);
                this.startMessage(s, executor, ms);
                Threading.getLogger().warn(s.toString());
                return (long)TaskManagerMonitor.this.config.taskExecutionMillisecondsBeforeToPutAside - ms;
            }
            if (ms < (long)TaskManagerMonitor.this.config.taskExecutionMillisecondsBeforeToKill) {
                if (executor.aside) {
                    return -1L;
                }
                StringBuilder s = new StringBuilder(2048);
                this.startMessage(s, executor, ms);
                s.append(" ! put the thread aside and start a new thread, current stack:");
                DebugUtil.createStackTrace(s, executor.thread.getStackTrace());
                this.appendLocks(s, executor.thread);
                Threading.getLogger().warn(s.toString());
                executor.manager.putExecutorAside(executor);
                return (long)TaskManagerMonitor.this.config.taskExecutionMillisecondsBeforeToKill - ms;
            }
            StringBuilder s = new StringBuilder(2048);
            this.startMessage(s, executor, ms);
            s.append(" ! kill the thread! current stack:");
            DebugUtil.createStackTrace(s, executor.thread.getStackTrace());
            this.appendLocks(s, executor.thread);
            Threading.getLogger().error(s.toString());
            executor.manager.killExecutor(executor);
            return 1L;
        }

        private void startMessage(StringBuilder s, TaskExecutor executor, long ms) {
            s.append("Task ").append(executor.currentTask).append(" is running since ").append(ms).append(" milliseconds on thread ").append(executor.thread);
        }

        private void checkLocks(List<TaskExecutor> executors) {
            if (executors.isEmpty()) {
                return;
            }
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            if (bean == null) {
                return;
            }
            long[] ids = new long[executors.size()];
            int i = 0;
            for (TaskExecutor executor : executors) {
                ids[i++] = executor.thread.getId();
            }
            ThreadInfo[] info = bean.getThreadInfo(ids, true, false);
            Iterator<TaskExecutor> it = executors.iterator();
            for (ThreadInfo ti : info) {
                MonitorInfo[] monitors;
                TaskExecutor executor = it.next();
                Task<?, ?> task = executor.currentTask;
                if (task == null || !executor.blocked || (monitors = ti.getLockedMonitors()).length == 0) continue;
                StringBuilder s = new StringBuilder(1024);
                s.append("TaskWorker is blocked while locking objects in task ").append(task.getDescription()).append(":\r\n");
                DebugUtil.createStackTrace(s, ti.getStackTrace());
                if (this.append(s, monitors) == 0 || !executor.blocked) continue;
                Threading.getLogger().error(s.toString());
            }
        }

        private void appendLocks(StringBuilder s, Thread t) {
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            if (bean == null) {
                return;
            }
            ThreadInfo info = bean.getThreadInfo(new long[]{t.getId()}, true, false)[0];
            if (info == null) {
                return;
            }
            MonitorInfo[] monitors = info.getLockedMonitors();
            this.append(s, monitors);
        }

        private int append(StringBuilder s, MonitorInfo[] monitors) {
            int nb = 0;
            s.append("\r\nLocked monitors:");
            for (int i = 0; i < monitors.length; ++i) {
                String className = monitors[i].getClassName();
                if (className.startsWith("net.lecousin.framework.concurrent.threads.") && (className.startsWith("net.lecousin.framework.concurrent.threads.priority") || "net.lecousin.framework.concurrent.threads.Task".equals(className))) continue;
                StackTraceElement trace = monitors[i].getLockedStackFrame();
                s.append("\r\n - ").append(className).append(" at ").append(trace.getClassName()).append('.').append(trace.getMethodName()).append('(').append(trace.getFileName()).append(':').append(trace.getLineNumber()).append(')');
                ++nb;
            }
            return nb;
        }
    }

    public static class Configuration {
        private int taskExecutionMillisecondsBeforeToWarn;
        private int taskExecutionMillisecondsBeforeToPutAside;
        private int taskExecutionMillisecondsBeforeToKill;
        private boolean checkLocksOnBlockedTasks;

        public Configuration(int taskExecutionMillisecondsBeforeToWarn, int taskExecutionMillisecondsBeforeToPutAside, int taskExecutionMillisecondsBeforeToKill, boolean checkLocksOnBlockedTasks) {
            this.taskExecutionMillisecondsBeforeToWarn = taskExecutionMillisecondsBeforeToWarn;
            this.taskExecutionMillisecondsBeforeToPutAside = taskExecutionMillisecondsBeforeToPutAside;
            this.taskExecutionMillisecondsBeforeToKill = taskExecutionMillisecondsBeforeToKill;
            this.checkLocksOnBlockedTasks = checkLocksOnBlockedTasks;
        }

        public Configuration duplicate() {
            return new Configuration(this.taskExecutionMillisecondsBeforeToWarn, this.taskExecutionMillisecondsBeforeToPutAside, this.taskExecutionMillisecondsBeforeToKill, this.checkLocksOnBlockedTasks);
        }
    }
}

