/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.threads;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.Blockable;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.DrivesThreadingManager;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskExecutor;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.TaskManagerMonitor;
import net.lecousin.framework.concurrent.threads.TaskScheduler;
import net.lecousin.framework.concurrent.threads.fixed.MultiThreadTaskManager;
import net.lecousin.framework.concurrent.threads.pool.ThreadPoolTaskManager;
import net.lecousin.framework.concurrent.threads.priority.SimpleTaskPriorityManager;
import net.lecousin.framework.concurrent.threads.priority.TaskPriorityManager;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.util.AsyncCloseable;

public final class Threading {
    private static Logger logger;
    public static boolean traceBlockingTasks;
    public static boolean traceTaskTime;
    public static long debugListenersTakingMoreThanMilliseconds;
    public static final Object CPU;
    public static final Object UNMANAGED;
    private static TaskManager cpuManager;
    private static DrivesThreadingManager drivesManager;
    private static ThreadPoolTaskManager unmanagedManager;
    private static Map<Object, TaskManager> resources;
    private static Map<Thread, TaskExecutor> executors;
    private static Map<Thread, Blockable> blockables;

    private Threading() {
    }

    public static Logger getLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(ThreadFactory threadFactory, Class<? extends TaskPriorityManager> taskPriorityManagerClass, int nbCPUThreads, TaskManagerMonitor.Configuration cpuMonitoring, DrivesThreadingManager.DrivesProvider drivesProvider, TaskManagerMonitor.Configuration driveMonitoring, int nbUnmanagedThreads, TaskManagerMonitor.Configuration unmanagedMonitoring) {
        TaskPriorityManager prioDrive;
        TaskPriorityManager prioCpu;
        if (Threading.isInitialized()) {
            throw new IllegalStateException("Threading has been already initialized.");
        }
        logger = LCCore.get().getThreadingLogger();
        TaskScheduler.init();
        try {
            prioCpu = taskPriorityManagerClass.newInstance();
            prioDrive = taskPriorityManagerClass.newInstance();
        }
        catch (Exception e) {
            Threading.getLogger().error("Unable to instantiate " + taskPriorityManagerClass.getName());
            prioCpu = new SimpleTaskPriorityManager();
            prioDrive = new SimpleTaskPriorityManager();
        }
        cpuManager = new MultiThreadTaskManager("CPU", CPU, nbCPUThreads > 0 ? nbCPUThreads : Runtime.getRuntime().availableProcessors(), threadFactory, prioCpu, cpuMonitoring);
        cpuManager.start();
        resources.put(CPU, cpuManager);
        drivesManager = new DrivesThreadingManager(threadFactory, taskPriorityManagerClass, drivesProvider, driveMonitoring);
        unmanagedManager = new ThreadPoolTaskManager("Unmanaged tasks manager", UNMANAGED, nbUnmanagedThreads, threadFactory, prioDrive, unmanagedMonitoring);
        resources.put(UNMANAGED, unmanagedManager);
        LCCore.get().toClose(new StopMultiThreading());
        Map<Object, TaskManager> map = resources;
        synchronized (map) {
            for (TaskManager tm : resources.values()) {
                tm.started();
            }
        }
    }

    public static boolean isInitialized() {
        return cpuManager != null;
    }

    public static TaskManager getCPUTaskManager() {
        return cpuManager;
    }

    public static DrivesThreadingManager getDrivesManager() {
        return drivesManager;
    }

    public static ThreadPoolTaskManager getUnmanagedTaskManager() {
        return unmanagedManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerResource(Object resource, TaskManager tm) {
        if (resource == null) {
            return;
        }
        Map<Object, TaskManager> map = resources;
        synchronized (map) {
            resources.put(resource, tm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskManager unregisterResource(Object resource) {
        if (resource == null) {
            return null;
        }
        Map<Object, TaskManager> map = resources;
        synchronized (map) {
            return resources.remove(resource);
        }
    }

    public static TaskManager get(Object resource) {
        return resources.get(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TaskManager> getAllTaskManagers() {
        Map<Object, TaskManager> map = resources;
        synchronized (map) {
            return new ArrayList<TaskManager>(resources.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerBlockable(Blockable handler, Thread thread) {
        Map<Thread, Blockable> map = blockables;
        synchronized (map) {
            blockables.put(thread, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterBlockable(Thread thread) {
        Map<Thread, Blockable> map = blockables;
        synchronized (map) {
            blockables.remove(thread);
        }
    }

    public static Blockable getBlockable(Thread thread) {
        Blockable b = executors.get(thread);
        if (b != null) {
            return b;
        }
        return blockables.get(thread);
    }

    public static Blockable getBlockable() {
        return Threading.getBlockable(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerTaskExecutor(TaskExecutor handler, Thread thread) {
        Map<Thread, TaskExecutor> map = executors;
        synchronized (map) {
            executors.put(thread, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterTaskExecutor(Thread thread) {
        Map<Thread, TaskExecutor> map = executors;
        synchronized (map) {
            executors.remove(thread);
        }
    }

    public static TaskExecutor getTaskExecutor(Thread thread) {
        return executors.get(thread);
    }

    public static TaskExecutor getTaskExecutor() {
        return executors.get(Thread.currentThread());
    }

    public static Task<?, ?> currentTask() {
        TaskExecutor executor = executors.get(Thread.currentThread());
        return executor != null ? executor.getCurrentTask() : null;
    }

    public static void setCpuMonitorConfiguration(TaskManagerMonitor.Configuration config) {
        if (!LCCore.get().currentThreadIsSystem()) {
            throw new IllegalThreadStateException();
        }
        cpuManager.getMonitor().setConfiguration(config);
    }

    public static void setDrivesMonitorConfiguration(TaskManagerMonitor.Configuration config) {
        if (!LCCore.get().currentThreadIsSystem()) {
            throw new IllegalThreadStateException();
        }
        drivesManager.setMonitoringConfiguration(config);
    }

    public static void setUnmanagedMonitorConfiguration(TaskManagerMonitor.Configuration config) {
        if (!LCCore.get().currentThreadIsSystem()) {
            throw new IllegalThreadStateException();
        }
        unmanagedManager.getMonitor().setConfiguration(config);
    }

    public static String debug() {
        StringBuilder s = new StringBuilder();
        for (TaskManager tm : resources.values()) {
            tm.debug(s);
            s.append("\r\n");
        }
        return s.toString();
    }

    public static void debugListenerCall(Object listener, long nanoseconds) {
        if (nanoseconds > debugListenersTakingMoreThanMilliseconds * 1000000L) {
            logger.debug("Listener took " + (double)nanoseconds / 1000000.0 + "ms: " + listener);
        }
    }

    static {
        traceBlockingTasks = System.getProperty("lc.traceBlockingTasks") != null;
        traceTaskTime = System.getProperty("lc.traceTaskTime") != null;
        debugListenersTakingMoreThanMilliseconds = 20L;
        CPU = new Object();
        UNMANAGED = new Object();
        resources = new HashMap<Object, TaskManager>();
        executors = new HashMap<Thread, TaskExecutor>();
        blockables = new HashMap<Thread, Blockable>();
    }

    private static class StopMultiThreading
    implements AsyncCloseable<Exception> {
        private StopMultiThreading() {
        }

        @Override
        public IAsync<Exception> closeAsync() {
            final Async<Exception> sp = new Async<Exception>();
            Thread t = new Thread("Stopping tasks managers"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean hasTasks = false;
                    long start = System.currentTimeMillis();
                    while (true) {
                        hasTasks = false;
                        Map map = resources;
                        synchronized (map) {
                            for (TaskManager tm : resources.values()) {
                                int nb = tm.getRemainingTasks(false);
                                if (nb <= 0) continue;
                                System.out.println("   * Still " + nb + " tasks to do for " + tm.getName());
                                hasTasks = true;
                            }
                        }
                        if (!hasTasks || System.currentTimeMillis() - start > 5000L) break;
                        try {
                            Thread.sleep(25L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    if (!hasTasks) {
                        System.out.println("   * No more task to do in any task manager, continue stop process");
                    } else {
                        System.out.println("   * Still some tasks after 5 seconds, continue stop process anyway");
                    }
                    TaskScheduler.end();
                    Map e = resources;
                    synchronized (e) {
                        for (TaskManager tm : resources.values()) {
                            tm.shutdownWhenNoMoreTasks();
                        }
                    }
                    boolean stop = true;
                    start = System.currentTimeMillis();
                    while (true) {
                        Object object = resources;
                        synchronized (object) {
                            for (TaskManager tm : resources.values()) {
                                stop &= tm.allActiveExecutorsStopped();
                            }
                        }
                        if (stop) break;
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e2) {
                            break;
                        }
                        stop = true;
                        if (System.currentTimeMillis() - start <= 10000L) continue;
                        start = Long.MAX_VALUE;
                        TaskScheduler.end();
                        object = resources;
                        synchronized (object) {
                            for (TaskManager tm : resources.values()) {
                                if (tm.allActiveExecutorsStopped()) continue;
                                System.err.println("Force to stop " + tm.getName());
                                tm.forceStop();
                            }
                        }
                    }
                    System.out.println("   * All Task Managers are stopped");
                    sp.unblock();
                }
            };
            t.start();
            return sp;
        }
    }
}

