/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.threads.fixed;

import java.util.concurrent.ThreadFactory;
import net.lecousin.framework.concurrent.threads.TaskManagerMonitor;
import net.lecousin.framework.concurrent.threads.fixed.FixedThreadTaskManager;
import net.lecousin.framework.concurrent.threads.fixed.TaskWorker;
import net.lecousin.framework.concurrent.threads.priority.TaskPriorityManager;

public class MonoThreadTaskManager
extends FixedThreadTaskManager {
    private TaskWorker worker;
    private int workerCount = 2;

    public MonoThreadTaskManager(String name, Object resource, ThreadFactory threadFactory, TaskPriorityManager taskPriorityManager, TaskManagerMonitor.Configuration monitorConfig) {
        super(name, resource, 1, threadFactory, taskPriorityManager, monitorConfig);
        this.worker = new TaskWorker(name + " - Worker 1", this);
    }

    @Override
    protected void startThreads() {
        this.worker.getThread().start();
    }

    @Override
    protected TaskWorker[] getWorkers() {
        return new TaskWorker[]{this.worker};
    }

    @Override
    protected void forceStopWorkers() {
        this.worker.forceStop(false);
    }

    @Override
    protected void finishAndStopWorkers() {
        this.worker.finishAndStop();
    }

    @Override
    public boolean allActiveExecutorsStopped() {
        return !this.worker.getThread().isAlive();
    }

    @Override
    protected TaskWorker createWorker() {
        return new TaskWorker(this.getName() + " - Worker " + this.workerCount++, this);
    }

    @Override
    protected void replaceWorkerBySpare(TaskWorker currentWorker, TaskWorker spareWorker) {
        this.worker = spareWorker;
    }
}

