/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.threads.fixed;

import java.util.concurrent.ThreadFactory;
import net.lecousin.framework.concurrent.threads.TaskManagerMonitor;
import net.lecousin.framework.concurrent.threads.fixed.FixedThreadTaskManager;
import net.lecousin.framework.concurrent.threads.fixed.TaskWorker;
import net.lecousin.framework.concurrent.threads.priority.TaskPriorityManager;

public class MultiThreadTaskManager
extends FixedThreadTaskManager {
    private TaskWorker[] workers;
    private int workerCount = 1;

    public MultiThreadTaskManager(String name, Object resource, int nbThreads, ThreadFactory threadFactory, TaskPriorityManager taskPriorityManager, TaskManagerMonitor.Configuration monitorConfig) {
        super(name, resource, nbThreads, threadFactory, taskPriorityManager, monitorConfig);
        this.workers = new TaskWorker[nbThreads];
        for (int i = 0; i < nbThreads; ++i) {
            this.workers[i] = new TaskWorker(name + " - Worker " + this.workerCount++, this);
        }
    }

    @Override
    protected void startThreads() {
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].getThread().start();
        }
    }

    @Override
    protected TaskWorker[] getWorkers() {
        return this.workers;
    }

    @Override
    protected void forceStopWorkers() {
        for (int i = this.getNbThreads() - 1; i >= 0; --i) {
            if (!this.workers[i].getThread().isAlive()) continue;
            this.workers[i].forceStop(false);
        }
    }

    @Override
    protected void finishAndStopWorkers() {
        for (int i = this.getNbThreads() - 1; i >= 0; --i) {
            this.workers[i].finishAndStop();
        }
    }

    @Override
    public boolean allActiveExecutorsStopped() {
        for (int i = this.getNbThreads() - 1; i >= 0; --i) {
            if (!this.workers[i].getThread().isAlive()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TaskWorker createWorker() {
        int nb;
        MultiThreadTaskManager multiThreadTaskManager = this;
        synchronized (multiThreadTaskManager) {
            nb = this.workerCount++;
        }
        return new TaskWorker(this.getName() + " - Worker " + nb, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void replaceWorkerBySpare(TaskWorker currentWorker, TaskWorker spareWorker) {
        TaskWorker[] taskWorkerArray = this.workers;
        synchronized (this.workers) {
            for (int i = this.getNbThreads() - 1; i >= 0; --i) {
                if (this.workers[i] != currentWorker) continue;
                this.workers[i] = spareWorker;
                break;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

