/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.threads.pool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskExecutor;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.TaskManagerMonitor;
import net.lecousin.framework.concurrent.threads.pool.TaskWorker;
import net.lecousin.framework.concurrent.threads.priority.TaskPriorityManager;

public class ThreadPoolTaskManager
extends TaskManager {
    private int maxThreads;
    LinkedList<TaskWorker> active = new LinkedList();
    long tasksDone = 0L;
    long tasksTime = 0L;
    private long threadCounter = 1L;

    public ThreadPoolTaskManager(String name, Object resource, int maxThreads, ThreadFactory threadFactory, TaskPriorityManager taskPriorityManager, TaskManagerMonitor.Configuration monitorConfig) {
        super(name, resource, threadFactory, taskPriorityManager, monitorConfig);
        this.maxThreads = maxThreads > 0 ? maxThreads : 100;
    }

    private String newThreadName() {
        return "ThreadPool " + this.getName() + " - " + this.threadCounter++;
    }

    TaskPriorityManager getPriorityManager() {
        return this.taskPriorityManager;
    }

    @Override
    protected void startThreads() {
    }

    @Override
    protected void threadingStarted() {
    }

    @Override
    protected void finishAndStopActiveAndInactiveExecutors() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void forceStopActiveAndInactiveExecutors() {
        TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
        synchronized (taskPriorityManager) {
            for (TaskWorker w : this.active) {
                w.forceStop = true;
            }
            this.taskPriorityManager.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allActiveExecutorsStopped() {
        TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
        synchronized (taskPriorityManager) {
            return this.active.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void add(Task<?, ?> t) {
        TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
        synchronized (taskPriorityManager) {
            if (this.active.size() < this.maxThreads) {
                this.active.add(new TaskWorker(t, this, this.newThreadName()));
            } else {
                this.taskPriorityManager.add(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executorUncaughtException(TaskExecutor executor) {
        TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
        synchronized (taskPriorityManager) {
            this.active.remove(executor);
            Task<?, ?> task = this.taskPriorityManager.peekNext();
            if (task != null) {
                this.active.add(new TaskWorker(task, this, this.newThreadName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void replaceBlockedExecutor(TaskExecutor executor) {
        TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
        synchronized (taskPriorityManager) {
            this.active.remove(executor);
            Task<?, ?> task = this.taskPriorityManager.peekNext();
            if (task != null) {
                this.active.add(new TaskWorker(task, this, this.newThreadName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unblockedExecutor(TaskExecutor executor) {
        TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
        synchronized (taskPriorityManager) {
            this.active.add((TaskWorker)executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executorAside(TaskExecutor executor) {
        TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
        synchronized (taskPriorityManager) {
            this.active.remove(executor);
            Task<?, ?> task = this.taskPriorityManager.peekNext();
            if (task != null) {
                this.active.add(new TaskWorker(task, this, this.newThreadName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskExecutor> getActiveExecutors() {
        TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
        synchronized (taskPriorityManager) {
            return new ArrayList<TaskExecutor>(this.active);
        }
    }

    @Override
    public List<TaskExecutor> getInactiveExecutors() {
        return Collections.emptyList();
    }

    @Override
    protected void getDebugDescription(StringBuilder s) {
        s.append("Thread pool ").append(this.getName()).append(": ").append(this.active.size()).append('/').append(this.maxThreads).append(" active threads");
    }
}

