/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.threads.priority;

import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.priority.TaskPriorityManager;
import net.lecousin.framework.util.ThreadUtil;

public class SimpleTaskPriorityManager
implements TaskPriorityManager {
    private TurnArray<Task<?, ?>>[] ready = new TurnArray[6];
    private TurnArray<Task<?, ?>> background;
    private int nextPriority = 6;
    private long lastIdle = -1L;
    private boolean stopping = false;

    public SimpleTaskPriorityManager() {
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            this.ready[i] = new TurnArray(128);
        }
        this.background = new TurnArray(32);
    }

    @Override
    public final synchronized void add(Task<?, ?> task) {
        int p = task.getPriority().getValue();
        if (p == 100) {
            this.background.add(task);
        } else {
            this.ready[p].addLast(task);
            if (this.nextPriority > p) {
                this.nextPriority = p;
            }
        }
        this.notify();
    }

    @Override
    public final synchronized boolean remove(Task<?, ?> task) {
        int p = task.getPriority().getValue();
        if (p == 100) {
            return this.background.removeInstance(task);
        }
        return this.ready[p].removeInstance(task);
    }

    @Override
    public final Task<?, ?> peekNextOrWait() {
        long wait;
        while (this.nextPriority < 6) {
            Task<?, ?> t = this.ready[this.nextPriority].pollFirst();
            if (t != null) {
                if (t.getRepetitionDelay() <= 0L) {
                    this.lastIdle = -1L;
                }
                return t;
            }
            ++this.nextPriority;
        }
        if (this.lastIdle < 0L) {
            this.lastIdle = System.currentTimeMillis();
        }
        if ((wait = this.lastIdle + 1000L - System.currentTimeMillis()) > 50L) {
            if (!this.stopping) {
                ThreadUtil.wait(this, wait);
            }
            return null;
        }
        Task<?, ?> t = this.background.pollFirst();
        if (t != null) {
            return t;
        }
        if (!this.stopping) {
            ThreadUtil.wait(this, 0L);
        }
        return null;
    }

    @Override
    public final Task<?, ?> peekNext() {
        while (this.nextPriority < 6) {
            Task<?, ?> t = this.ready[this.nextPriority].pollFirst();
            if (t != null) {
                if (t.getRepetitionDelay() <= 0L) {
                    this.lastIdle = -1L;
                }
                return t;
            }
            ++this.nextPriority;
        }
        if (this.lastIdle < 0L) {
            this.lastIdle = System.currentTimeMillis();
        }
        return null;
    }

    @Override
    public void stopping() {
        this.stopping = true;
    }

    @Override
    public final List<Task<?, ?>> removeAllPendingTasks() {
        LinkedList list = new LinkedList();
        for (int p = 0; p < this.ready.length; ++p) {
            while (!this.ready[p].isEmpty()) {
                list.add(this.ready[p].removeFirst());
            }
        }
        while (!this.background.isEmpty()) {
            list.add(this.background.removeFirst());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void forceStop() {
        this.nextPriority = 6;
        TurnArray<Task<?, ?>>[] turnArrayArray = this.ready;
        synchronized (this.ready) {
            this.ready.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.nextPriority = 6;
            for (int p = 0; p < 6; ++p) {
                if (this.ready[p].isEmpty()) continue;
                for (Task<?, ?> t : this.ready[p]) {
                    System.err.println("Task Manager stopped while the following task was remaining: " + t.getDescription());
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getRemainingTasks(boolean includingBackground) {
        int nb = 0;
        SimpleTaskPriorityManager simpleTaskPriorityManager = this;
        synchronized (simpleTaskPriorityManager) {
            for (int p = 0; p < 6; ++p) {
                nb += this.ready[p].size();
            }
            if (includingBackground) {
                nb += this.background.size();
            }
        }
        return nb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasRemainingTasks(boolean includingBackground) {
        SimpleTaskPriorityManager simpleTaskPriorityManager = this;
        synchronized (simpleTaskPriorityManager) {
            if (includingBackground && !this.background.isEmpty()) {
                return false;
            }
            for (int p = 0; p < 6; ++p) {
                if (this.ready[p].isEmpty()) continue;
                return true;
            }
            return false;
        }
    }
}

