/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.util;

import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.util.Pair;

public class BufferedAsyncConsumer<T, TError extends Exception>
implements AsyncConsumer<T, TError> {
    protected AsyncConsumer<T, TError> consumer;
    protected TurnArray<T> queue;
    protected IAsync<TError> lastOperation;
    protected Pair<T, Async<TError>> waiting;
    protected Async<TError> end;
    protected TError error;

    public BufferedAsyncConsumer(int nbPending, AsyncConsumer<T, TError> consumer) {
        this.consumer = consumer;
        if (nbPending < 2) {
            nbPending = 2;
        }
        this.queue = new TurnArray(nbPending - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAsync<TError> consume(T data) {
        TurnArray<T> turnArray = this.queue;
        synchronized (turnArray) {
            if (this.error != null) {
                return new Async<TError>(this.error);
            }
            if (this.lastOperation == null) {
                this.lastOperation = this.consumer.consume(data);
                this.lastOperation.onDone(this::nextPending, this::error, c -> {});
                return new Async<boolean>(true);
            }
            if (!this.queue.isFull()) {
                this.queue.add(data);
                return new Async<boolean>(true);
            }
            this.waiting = new Pair(data, new Async());
            return this.waiting.getValue2();
        }
    }

    private void nextPending() {
        Task.cpu("Consume next buffer", Task.Priority.NORMAL, t -> {
            Async<TError> unblock = null;
            TurnArray<T> turnArray = this.queue;
            synchronized (turnArray) {
                if (this.error != null) {
                    this.consumer.error(this.error);
                    return null;
                }
                T next = this.queue.pollFirst();
                if (next != null) {
                    this.lastOperation = this.consumer.consume(next);
                    if (this.waiting != null) {
                        this.queue.add(this.waiting.getValue1());
                        unblock = this.waiting.getValue2();
                        this.waiting = null;
                    }
                    this.lastOperation.onDone(this::nextPending, this::error, c -> {});
                } else {
                    this.lastOperation = null;
                    if (this.end != null) {
                        this.consumer.end().onDone(this.end);
                    }
                }
            }
            if (unblock != null) {
                unblock.unblock();
            }
            return null;
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAsync<TError> end() {
        TurnArray<T> turnArray = this.queue;
        synchronized (turnArray) {
            if (this.error != null) {
                return new Async<TError>(this.error);
            }
            if (this.lastOperation == null && this.queue.isEmpty()) {
                return this.consumer.end();
            }
            this.end = new Async();
            return this.end;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error(TError error) {
        TurnArray<T> turnArray = this.queue;
        synchronized (turnArray) {
            if (this.error != null) {
                return;
            }
            this.error = error;
            while (!this.queue.isEmpty()) {
                this.queue.pollFirst();
            }
            if (this.waiting != null) {
                this.waiting.getValue2().error(error);
            }
            this.waiting = null;
            if (this.lastOperation == null) {
                this.consumer.error(error);
            } else {
                this.lastOperation = null;
            }
            if (this.end != null) {
                this.end.error(error);
            }
        }
    }
}

