/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.encoding;

import java.util.function.Function;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.encoding.BytesDecoder;
import net.lecousin.framework.encoding.BytesEncoder;
import net.lecousin.framework.encoding.EncodingException;
import net.lecousin.framework.io.data.ByteArray;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.memory.ByteArrayCache;

public final class HexaDecimalEncoding
implements BytesEncoder.KnownOutputSize,
BytesDecoder.KnownOutputSize {
    public static final HexaDecimalEncoding instance = new HexaDecimalEncoding();
    private static final char[] hexaChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private HexaDecimalEncoding() {
    }

    public static char encodeDigit(int value) {
        return hexaChar[value];
    }

    public static int decodeChar(char c) throws EncodingException {
        if (c >= 'A') {
            if (c <= 'F') {
                return c - 65 + 10;
            }
            if (c >= 'a' && c <= 'f') {
                return c - 97 + 10;
            }
        } else if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new EncodingException("Invalid hexadecimal digit '" + c + "'");
    }

    public static boolean isHexaDigit(char c) {
        if (c >= 'A') {
            if (c <= 'F') {
                return true;
            }
            if (c >= 'a' && c <= 'f') {
                return true;
            }
        } else if (c >= '0' && c <= '9') {
            return true;
        }
        return false;
    }

    @Override
    public byte[] encode(byte[] input, int offset, int length) {
        byte[] out = new byte[length * 2];
        for (int i = 0; i < length; ++i) {
            out[i * 2] = (byte)HexaDecimalEncoding.encodeDigit((input[offset + i] & 0xF0) >> 4);
            out[i * 2 + 1] = (byte)HexaDecimalEncoding.encodeDigit(input[offset + i] & 0xF);
        }
        return out;
    }

    @Override
    public void encode(Bytes.Readable input, Bytes.Writable output, boolean end) {
        int len = Math.min(input.remaining(), output.remaining() / 2);
        for (int i = 0; i < len; ++i) {
            byte b = input.get();
            output.put((byte)HexaDecimalEncoding.encodeDigit((b & 0xF0) >> 4));
            output.put((byte)HexaDecimalEncoding.encodeDigit(b & 0xF));
        }
    }

    @Override
    public byte[] encode(Bytes.Readable input) throws EncodingException {
        byte[] out = new byte[input.remaining() * 2];
        int i = 0;
        while (input.hasRemaining()) {
            byte b = input.get();
            out[i++] = (byte)HexaDecimalEncoding.encodeDigit((b & 0xF0) >> 4);
            out[i++] = (byte)HexaDecimalEncoding.encodeDigit(b & 0xF);
        }
        return out;
    }

    @Override
    public byte[] decode(byte[] input, int offset, int length) throws EncodingException {
        byte[] s = new byte[length / 2];
        for (int i = 0; i < s.length; ++i) {
            s[i] = (byte)(HexaDecimalEncoding.decodeChar((char)input[offset + i * 2]) << 4 | HexaDecimalEncoding.decodeChar((char)input[offset + i * 2 + 1]));
        }
        return s;
    }

    @Override
    public byte[] decode(Bytes.Readable input) throws EncodingException {
        byte[] s = new byte[input.remaining() / 2];
        for (int i = 0; i < s.length; ++i) {
            s[i] = (byte)(HexaDecimalEncoding.decodeChar((char)input.get()) << 4 | HexaDecimalEncoding.decodeChar((char)input.get()));
        }
        return s;
    }

    @Override
    public void decode(Bytes.Readable input, Bytes.Writable output, boolean end) throws EncodingException {
        int len = Math.min(input.remaining() / 2, output.remaining());
        for (int i = 0; i < len; ++i) {
            output.put((byte)(HexaDecimalEncoding.decodeChar((char)input.get()) << 4 | HexaDecimalEncoding.decodeChar((char)input.get())));
        }
    }

    @Override
    public <TError extends Exception> AsyncConsumer<Bytes.Readable, TError> createDecoderConsumer(AsyncConsumer<Bytes.Readable, TError> decodedConsumer, Function<EncodingException, TError> errorConverter) {
        return new DecoderConsumer<TError>(decodedConsumer, errorConverter);
    }

    @Override
    public <TError extends Exception> AsyncConsumer<Bytes.Readable, TError> createEncoderConsumer(AsyncConsumer<Bytes.Readable, TError> encodedConsumer, Function<EncodingException, TError> errorConverter) {
        return new EncoderConsumer<TError>(encodedConsumer);
    }

    public static class DecoderConsumer<TError extends Exception>
    implements AsyncConsumer<Bytes.Readable, TError> {
        private ByteArrayCache cache = ByteArrayCache.getInstance();
        private AsyncConsumer<Bytes.Readable, TError> decodedBytesConsumer;
        private Function<EncodingException, TError> errorConverter;
        private int firstChar = -1;

        public DecoderConsumer(AsyncConsumer<Bytes.Readable, TError> decodedBytesConsumer, Function<EncodingException, TError> errorConverter) {
            this.decodedBytesConsumer = decodedBytesConsumer;
            this.errorConverter = errorConverter;
        }

        @Override
        public IAsync<TError> consume(Bytes.Readable data) {
            int len = ((this.firstChar != -1 ? 1 : 0) + data.remaining()) / 2;
            if (len == 0) {
                this.firstChar = data.get() & 0xFF;
                data.free();
                return new Async<boolean>(true);
            }
            ByteArray.Writable output = new ByteArray.Writable((byte[])this.cache.get(len, true), true);
            try {
                if (this.firstChar != -1) {
                    output.put((byte)(HexaDecimalEncoding.decodeChar((char)this.firstChar) << 4 | HexaDecimalEncoding.decodeChar((char)data.get())));
                    this.firstChar = -1;
                }
                instance.decode(data, output, false);
            }
            catch (EncodingException e) {
                EncodingException err = this.errorConverter != null ? (Exception)this.errorConverter.apply(e) : e;
                this.decodedBytesConsumer.error(err);
                return new Async<EncodingException>(err);
            }
            if (data.hasRemaining()) {
                this.firstChar = data.get() & 0xFF;
            }
            data.free();
            output.flip();
            return this.decodedBytesConsumer.consume(output);
        }

        @Override
        public IAsync<TError> end() {
            return this.decodedBytesConsumer.end();
        }

        @Override
        public void error(TError error) {
            this.decodedBytesConsumer.error(error);
        }
    }

    public static class EncoderConsumer<TError extends Exception>
    implements AsyncConsumer<Bytes.Readable, TError> {
        private ByteArrayCache cache = ByteArrayCache.getInstance();
        private AsyncConsumer<Bytes.Readable, TError> encodedBytesConsumer;

        public EncoderConsumer(AsyncConsumer<Bytes.Readable, TError> encodedBytesConsumer) {
            this.encodedBytesConsumer = encodedBytesConsumer;
        }

        @Override
        public IAsync<TError> consume(Bytes.Readable data) {
            ByteArray.Writable output = new ByteArray.Writable((byte[])this.cache.get(data.remaining() * 2, true), true);
            instance.encode(data, output, false);
            data.free();
            output.flip();
            return this.encodedBytesConsumer.consume(output);
        }

        @Override
        public IAsync<TError> end() {
            return this.encodedBytesConsumer.end();
        }

        @Override
        public void error(TError error) {
            this.encodedBytesConsumer.error(error);
        }
    }
}

