/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.encoding;

import java.nio.charset.StandardCharsets;
import net.lecousin.framework.encoding.BytesDecoder;
import net.lecousin.framework.encoding.BytesEncoder;
import net.lecousin.framework.encoding.EncodingException;
import net.lecousin.framework.io.util.DataUtil;

public interface StringEncoding<T> {
    public String encode(T var1) throws EncodingException;

    public T decode(String var1) throws EncodingException;

    public static class EncodedLong
    implements StringEncoding<Long> {
        protected BytesEncoder.KnownOutputSize encoder;
        protected BytesDecoder.KnownOutputSize decoder;

        public EncodedLong(BytesEncoder.KnownOutputSize encoder, BytesDecoder.KnownOutputSize decoder) {
            this.encoder = encoder;
            this.decoder = decoder;
        }

        @Override
        public String encode(Long value) throws EncodingException {
            byte[] b = new byte[8];
            DataUtil.Write64.LE.write(b, 0, value);
            return new String(this.encoder.encode(b), StandardCharsets.ISO_8859_1);
        }

        @Override
        public Long decode(String string) throws EncodingException {
            return DataUtil.Read64.LE.read(this.decoder.decode(string.getBytes(StandardCharsets.ISO_8859_1)), 0);
        }
    }

    public static class SimpleLong
    implements StringEncoding<Long> {
        @Override
        public String encode(Long value) {
            return value.toString();
        }

        @Override
        public Long decode(String string) throws EncodingException {
            try {
                return Long.valueOf(string);
            }
            catch (NumberFormatException e) {
                throw new EncodingException("Invalid long: " + string);
            }
        }
    }

    public static class SimpleInteger
    implements StringEncoding<Integer> {
        @Override
        public String encode(Integer value) {
            return value.toString();
        }

        @Override
        public Integer decode(String string) throws EncodingException {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException e) {
                throw new EncodingException("Invalid integer: " + string);
            }
        }
    }
}

