/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.encoding;

import java.util.BitSet;
import net.lecousin.framework.encoding.EncodingException;
import net.lecousin.framework.encoding.HexaDecimalEncoding;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.io.data.CharArray;
import net.lecousin.framework.io.data.Chars;
import net.lecousin.framework.memory.CharArrayCache;
import net.lecousin.framework.text.CharArrayStringBuffer;

public final class URLEncoding {
    private static BitSet dontNeedEncoding;

    private URLEncoding() {
    }

    public static void encode(Chars.Readable chars, Bytes.Writable out, boolean isPath, boolean endOfChars) {
        while (out.hasRemaining() && chars.hasRemaining()) {
            char c = chars.get();
            if (c < '\u0080') {
                if (c == ' ') {
                    out.put((byte)43);
                    continue;
                }
                if (dontNeedEncoding.get(c) || c == '/' && isPath) {
                    out.put((byte)c);
                    continue;
                }
                if (out.remaining() < 3) {
                    chars.setPosition(chars.position() - 1);
                    break;
                }
                out.put((byte)37);
                out.put((byte)HexaDecimalEncoding.encodeDigit((c & 0xF0) >> 4));
                out.put((byte)HexaDecimalEncoding.encodeDigit(c & 0xF));
                continue;
            }
            if (c < '\u0800') {
                if (out.remaining() < 6) {
                    chars.setPosition(chars.position() - 1);
                    break;
                }
                out.put((byte)37);
                out.put((byte)HexaDecimalEncoding.encodeDigit(0xC | (c & 0x400) >> 10));
                out.put((byte)HexaDecimalEncoding.encodeDigit((c & 0x3C0) >> 6));
                out.put((byte)37);
                out.put((byte)HexaDecimalEncoding.encodeDigit(8 | (c & 0x30) >> 4));
                out.put((byte)HexaDecimalEncoding.encodeDigit(c & 0xF));
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff') {
                if (!chars.hasRemaining()) {
                    if (endOfChars) break;
                    chars.setPosition(chars.position() - 1);
                    break;
                }
                if (out.remaining() < 12) {
                    chars.setPosition(chars.position() - 1);
                    break;
                }
                char c2 = chars.get();
                if (c2 < '\udc00' || c2 > '\udfff') continue;
                int uuuuu = ((c & 0x3C0) >> 6) + 1;
                out.put((byte)37);
                out.put((byte)HexaDecimalEncoding.encodeDigit(15));
                out.put((byte)HexaDecimalEncoding.encodeDigit((uuuuu & 0x1C) >> 2));
                out.put((byte)37);
                out.put((byte)HexaDecimalEncoding.encodeDigit(8 | uuuuu & 3));
                out.put((byte)HexaDecimalEncoding.encodeDigit((c & 0x3C) >> 2));
                out.put((byte)37);
                out.put((byte)HexaDecimalEncoding.encodeDigit(8 | c & 3));
                out.put((byte)HexaDecimalEncoding.encodeDigit((c2 & 0x3C0) >> 6));
                out.put((byte)37);
                out.put((byte)HexaDecimalEncoding.encodeDigit(8 | (c2 & 0x30) >> 4));
                out.put((byte)HexaDecimalEncoding.encodeDigit(c2 & 0xF));
                continue;
            }
            if (out.remaining() < 9) {
                chars.setPosition(chars.position() - 1);
                break;
            }
            out.put((byte)37);
            out.put((byte)HexaDecimalEncoding.encodeDigit(14));
            out.put((byte)HexaDecimalEncoding.encodeDigit((c & 0xF000) >> 12));
            out.put((byte)37);
            out.put((byte)HexaDecimalEncoding.encodeDigit(8 | (c & 0xC00) >> 10));
            out.put((byte)HexaDecimalEncoding.encodeDigit((c & 0x3C0) >> 6));
            out.put((byte)37);
            out.put((byte)HexaDecimalEncoding.encodeDigit(8 | (c & 0x30) >> 4));
            out.put((byte)HexaDecimalEncoding.encodeDigit(c & 0xF));
        }
    }

    public static void decode(Bytes.Readable bytes, Chars.Writable out, boolean endOfBytes) {
        while (bytes.hasRemaining() && out.hasRemaining()) {
            byte b = bytes.get();
            if (b == 43) {
                out.put(' ');
                continue;
            }
            if (b == 37) {
                int v4;
                int v3;
                int v2;
                int v1;
                if (bytes.remaining() < 2) {
                    if (endOfBytes) {
                        bytes.goToEnd();
                        break;
                    }
                    bytes.setPosition(bytes.position() - 1);
                    break;
                }
                try {
                    v1 = HexaDecimalEncoding.decodeChar((char)(bytes.get() & 0xFF)) << 4;
                }
                catch (EncodingException e) {
                    out.put('%');
                    bytes.setPosition(bytes.position() - 1);
                    continue;
                }
                try {
                }
                catch (EncodingException e) {
                    out.put('%');
                    bytes.setPosition(bytes.position() - 2);
                    continue;
                }
                if (((v1 |= HexaDecimalEncoding.decodeChar((char)(bytes.get() & 0xFF))) & 0x80) == 0) {
                    out.put((char)v1);
                    continue;
                }
                if (bytes.remaining() < 3) {
                    if (endOfBytes) {
                        out.put((char)v1);
                        continue;
                    }
                    bytes.setPosition(bytes.position() - 3);
                    break;
                }
                b = bytes.get();
                if (b != 37) {
                    out.put((char)v1);
                    bytes.setPosition(bytes.position() - 1);
                    continue;
                }
                try {
                    v2 = HexaDecimalEncoding.decodeChar((char)(bytes.get() & 0xFF)) << 4;
                }
                catch (EncodingException e) {
                    out.put((char)v1);
                    bytes.setPosition(bytes.position() - 2);
                    continue;
                }
                try {
                    v2 |= HexaDecimalEncoding.decodeChar((char)(bytes.get() & 0xFF));
                }
                catch (EncodingException e) {
                    out.put((char)v1);
                    bytes.setPosition(bytes.position() - 3);
                    continue;
                }
                if ((v1 & 0xE0) == 192) {
                    if ((v2 & 0xC0) == 128) {
                        out.put((char)((v1 & 0x1F) << 6 | v2 & 0x3F));
                        continue;
                    }
                    out.put('\ufffd');
                    continue;
                }
                if (bytes.remaining() < 3) {
                    if (endOfBytes) continue;
                    bytes.setPosition(bytes.position() - 6);
                    break;
                }
                b = bytes.get();
                if (b != 37) {
                    out.put('\ufffd');
                    bytes.setPosition(bytes.position() - 1);
                    continue;
                }
                try {
                    v3 = HexaDecimalEncoding.decodeChar((char)(bytes.get() & 0xFF)) << 4;
                }
                catch (EncodingException e) {
                    out.put('\ufffd');
                    bytes.setPosition(bytes.position() - 2);
                    continue;
                }
                try {
                    v3 |= HexaDecimalEncoding.decodeChar((char)(bytes.get() & 0xFF));
                }
                catch (EncodingException e) {
                    out.put('\ufffd');
                    bytes.setPosition(bytes.position() - 3);
                    continue;
                }
                if ((v1 & 0xF0) == 224) {
                    if ((v2 & 0xC0) == 128 && (v3 & 0xC0) == 128) {
                        out.put((char)((v1 & 0xF) << 12 | (v2 & 0x3F) << 6 | v3 & 0x3F));
                        continue;
                    }
                    out.put('\ufffd');
                    continue;
                }
                if (bytes.remaining() < 3) {
                    if (endOfBytes) continue;
                    bytes.setPosition(bytes.position() - 9);
                    break;
                }
                b = bytes.get();
                if (b != 37) {
                    out.put('\ufffd');
                    bytes.setPosition(bytes.position() - 1);
                    continue;
                }
                try {
                    v4 = HexaDecimalEncoding.decodeChar((char)(bytes.get() & 0xFF)) << 4;
                }
                catch (EncodingException e) {
                    out.put('\ufffd');
                    bytes.setPosition(bytes.position() - 2);
                    continue;
                }
                try {
                    v4 |= HexaDecimalEncoding.decodeChar((char)(bytes.get() & 0xFF));
                }
                catch (EncodingException e) {
                    out.put('\ufffd');
                    bytes.setPosition(bytes.position() - 3);
                    continue;
                }
                if ((v1 & 0xF8) == 240) {
                    if ((v2 & 0xC0) == 128 && (v3 & 0xC0) == 128 && (v4 & 0xC0) == 128) {
                        if (out.remaining() < 2) {
                            bytes.setPosition(bytes.position() - 12);
                            break;
                        }
                        int v = (v1 & 7) << 12 | (v2 & 0x3F) << 6 | v3 & 0x3F;
                        int uuuuu = (v & 0x7C00) >> 10;
                        if (uuuuu > 16) {
                            out.put('\ufffd');
                            continue;
                        }
                        int wwww = uuuuu - 1;
                        out.put((char)(0xD800 | wwww << 6 | (v & 0x3C0) >> 4 | (v & 0x30) >> 4));
                        out.put((char)(0xDC00 | (v & 0xF) << 6 | v4 & 0x3F));
                        continue;
                    }
                    out.put('\ufffd');
                    continue;
                }
                out.put('\ufffd');
                continue;
            }
            out.put((char)(b & 0xFF));
        }
    }

    public static CharArrayStringBuffer decode(Bytes.Readable bytes) {
        CharArrayStringBuffer chars = new CharArrayStringBuffer();
        CharArrayCache cache = CharArrayCache.getInstance();
        do {
            char[] buf = (char[])cache.get(Math.max(bytes.remaining(), 128), true);
            CharArray.Writable ca = new CharArray.Writable(buf, true);
            URLEncoding.decode(bytes, ca, true);
            if (ca.position() > 0) {
                chars.append(buf, 0, ca.position());
                continue;
            }
            cache.free(buf);
        } while (bytes.hasRemaining());
        return chars;
    }

    static {
        int i;
        dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }
}

