/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.event;

import java.util.ArrayList;
import java.util.LinkedList;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.event.SimpleListenable;
import net.lecousin.framework.exception.NoException;

public class AsyncEvent
implements SimpleListenable {
    private LinkedList<Runnable> listeners = new LinkedList();
    private Task<Void, NoException> next = null;
    private Task<Void, NoException> current = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Runnable listener) {
        LinkedList<Runnable> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Runnable listener) {
        LinkedList<Runnable> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire() {
        LinkedList<Runnable> linkedList = this.listeners;
        synchronized (linkedList) {
            if (this.next == null) {
                this.next = Task.cpu("Fire AsyncEvent listeners", task -> {
                    ArrayList<Runnable> list;
                    LinkedList<Runnable> linkedList = this.listeners;
                    synchronized (linkedList) {
                        this.current = this.next;
                        this.next = null;
                        list = new ArrayList<Runnable>(this.listeners);
                    }
                    for (Runnable listener : list) {
                        try {
                            listener.run();
                        }
                        catch (Exception t) {
                            LCCore.getApplication().getDefaultLogger().error("Listener of AsyncEvent thrown an exception", t);
                        }
                    }
                    return null;
                });
                if (this.current != null) {
                    this.current.getOutput().thenStart(this.next, true);
                } else {
                    this.next.start();
                }
            }
        }
    }
}

