/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.event;

import java.util.function.Consumer;
import net.lecousin.framework.event.AbstractListenable;

public class SingleEvent<T>
extends AbstractListenable<T> {
    private boolean occured = false;
    private T data = null;

    @Override
    public synchronized void addListener(Consumer<T> listener) {
        if (this.occured) {
            listener.accept(this.data);
        } else {
            super.addListener(listener);
        }
    }

    @Override
    public synchronized void addListener(Runnable listener) {
        if (this.occured) {
            listener.run();
        } else {
            super.addListener(listener);
        }
    }

    public synchronized void fire(T event) {
        if (this.occured) {
            throw new IllegalStateException("SingleEvent already fired");
        }
        this.occured = true;
        this.data = event;
        if (this.listenersConsumer != null) {
            for (Object listener : this.listenersConsumer) {
                listener.accept(event);
            }
            this.listenersConsumer = null;
        }
        if (this.listenersRunnable != null) {
            for (Object listener : this.listenersRunnable) {
                listener.run();
            }
            this.listenersRunnable = null;
        }
    }

    public boolean occured() {
        return this.occured;
    }
}

